/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.constants;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.ConstantValueFactory;
import org.jetbrains.kotlin.resolve.constants.IntegerValueTypeConstructor;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeImpl;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeUtils;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0004\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00020\u00152\u0006\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0003\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/resolve/constants/IntegerValueTypeConstant;", "Lorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant;", "", "value", "builtIns", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "parameters", "Lorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant$Parameters;", "(Ljava/lang/Number;Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;Lorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant$Parameters;)V", "getParameters", "()Lorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant$Parameters;", "typeConstructor", "Lorg/jetbrains/kotlin/resolve/constants/IntegerValueTypeConstructor;", "unknownIntegerType", "Lorg/jetbrains/kotlin/types/KotlinTypeImpl;", "getUnknownIntegerType", "()Lorg/jetbrains/kotlin/types/KotlinTypeImpl;", "getType", "Lorg/jetbrains/kotlin/types/KotlinType;", "expectedType", "toConstantValue", "Lorg/jetbrains/kotlin/resolve/constants/ConstantValue;", "toString", "", "kotlin-compiler"})
public final class IntegerValueTypeConstant
implements CompileTimeConstant<Number> {
    private final IntegerValueTypeConstructor typeConstructor;
    @NotNull
    private final KotlinTypeImpl unknownIntegerType;
    private final Number value;
    private final KotlinBuiltIns builtIns;
    @NotNull
    private final CompileTimeConstant.Parameters parameters;

    @Override
    @NotNull
    public ConstantValue<Number> toConstantValue(@NotNull KotlinType expectedType) {
        Intrinsics.checkParameterIsNotNull(expectedType, "expectedType");
        ConstantValueFactory factory = new ConstantValueFactory(this.builtIns);
        KotlinType type2 = this.getType(expectedType);
        return KotlinBuiltIns.isInt(type2) ? (ConstantValue)factory.createIntValue(this.value.intValue()) : (KotlinBuiltIns.isByte(type2) ? (ConstantValue)factory.createByteValue(this.value.byteValue()) : (KotlinBuiltIns.isShort(type2) ? (ConstantValue)factory.createShortValue(this.value.shortValue()) : (ConstantValue)factory.createLongValue(this.value.longValue())));
    }

    @NotNull
    public final KotlinTypeImpl getUnknownIntegerType() {
        return this.unknownIntegerType;
    }

    @NotNull
    public final KotlinType getType(@NotNull KotlinType expectedType) {
        Intrinsics.checkParameterIsNotNull(expectedType, "expectedType");
        KotlinType kotlinType = TypeUtils.getPrimitiveNumberType(this.typeConstructor, expectedType);
        Intrinsics.checkExpressionValueIsNotNull(kotlinType, "TypeUtils.getPrimitiveNu\u2026onstructor, expectedType)");
        return kotlinType;
    }

    @NotNull
    public String toString() {
        return this.typeConstructor.toString();
    }

    @Override
    @NotNull
    public CompileTimeConstant.Parameters getParameters() {
        return this.parameters;
    }

    public IntegerValueTypeConstant(@NotNull Number value, @NotNull KotlinBuiltIns builtIns, @NotNull CompileTimeConstant.Parameters parameters2) {
        Intrinsics.checkParameterIsNotNull(value, "value");
        Intrinsics.checkParameterIsNotNull(builtIns, "builtIns");
        Intrinsics.checkParameterIsNotNull(parameters2, "parameters");
        this.value = value;
        this.builtIns = builtIns;
        this.parameters = parameters2;
        this.typeConstructor = new IntegerValueTypeConstructor(this.value.longValue(), this.builtIns);
        Annotations annotations2 = Annotations.Companion.getEMPTY();
        TypeConstructor typeConstructor2 = this.typeConstructor;
        List list2 = CollectionsKt.emptyList();
        MemberScope memberScope2 = ErrorUtils.createErrorScope("Scope for number value type (" + this.typeConstructor.toString() + ")", true);
        Intrinsics.checkExpressionValueIsNotNull(memberScope2, "ErrorUtils.createErrorSc\u2026r.toString() + \")\", true)");
        this.unknownIntegerType = KotlinTypeImpl.Companion.create(annotations2, typeConstructor2, false, list2, memberScope2);
    }

    @Override
    public boolean getUsesNonConstValAsConstant() {
        return CompileTimeConstant.DefaultImpls.getUsesNonConstValAsConstant(this);
    }

    @Override
    public boolean isPure() {
        return CompileTimeConstant.DefaultImpls.isPure(this);
    }

    @Override
    public boolean isError() {
        return CompileTimeConstant.DefaultImpls.isError(this);
    }

    @Override
    public boolean getUsesVariableAsConstant() {
        return CompileTimeConstant.DefaultImpls.getUsesVariableAsConstant(this);
    }

    @Override
    @NotNull
    public Number getValue(@NotNull KotlinType expectedType) {
        Intrinsics.checkParameterIsNotNull(expectedType, "expectedType");
        return (Number)CompileTimeConstant.DefaultImpls.getValue(this, expectedType);
    }

    @Override
    public boolean getCanBeUsedInAnnotations() {
        return CompileTimeConstant.DefaultImpls.getCanBeUsedInAnnotations(this);
    }
}

