/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.diagnostics;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.FilteringIterator;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.diagnostics.BindingContextSuppressCache;
import org.jetbrains.kotlin.resolve.diagnostics.Diagnostics;
import org.jetbrains.kotlin.resolve.diagnostics.DiagnosticsElementsCache;
import org.jetbrains.kotlin.resolve.diagnostics.KotlinSuppressCache;
import org.jetbrains.kotlin.resolve.diagnostics.SimpleDiagnostics;

public class DiagnosticsWithSuppression
implements Diagnostics {
    private final KotlinSuppressCache kotlinSuppressCache;
    private final Collection<Diagnostic> diagnostics;
    private final DiagnosticsElementsCache elementsCache;

    public DiagnosticsWithSuppression(@NotNull BindingContext context, @NotNull Collection<Diagnostic> diagnostics) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/diagnostics/DiagnosticsWithSuppression", "<init>"));
        }
        if (diagnostics == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagnostics", "org/jetbrains/kotlin/resolve/diagnostics/DiagnosticsWithSuppression", "<init>"));
        }
        this.diagnostics = diagnostics;
        this.kotlinSuppressCache = new BindingContextSuppressCache(context);
        this.elementsCache = new DiagnosticsElementsCache(this, this.kotlinSuppressCache.getFilter());
    }

    @Override
    @NotNull
    public Diagnostics noSuppression() {
        SimpleDiagnostics simpleDiagnostics = new SimpleDiagnostics(this.diagnostics);
        if (simpleDiagnostics == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/diagnostics/DiagnosticsWithSuppression", "noSuppression"));
        }
        return simpleDiagnostics;
    }

    @Override
    @NotNull
    public Iterator<Diagnostic> iterator() {
        FilteringIterator filteringIterator = new FilteringIterator(this.diagnostics.iterator(), new Condition<Diagnostic>(){

            @Override
            public boolean value(Diagnostic diagnostic) {
                return DiagnosticsWithSuppression.this.kotlinSuppressCache.getFilter().invoke(diagnostic);
            }
        });
        if (filteringIterator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/diagnostics/DiagnosticsWithSuppression", "iterator"));
        }
        return filteringIterator;
    }

    @Override
    @NotNull
    public Collection<Diagnostic> all() {
        List<Diagnostic> list2 = CollectionsKt.filter(this.diagnostics, this.kotlinSuppressCache.getFilter());
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/diagnostics/DiagnosticsWithSuppression", "all"));
        }
        return list2;
    }

    @Override
    @NotNull
    public Collection<Diagnostic> forElement(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "org/jetbrains/kotlin/resolve/diagnostics/DiagnosticsWithSuppression", "forElement"));
        }
        Collection<Diagnostic> collection = this.elementsCache.getDiagnostics(psiElement);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/diagnostics/DiagnosticsWithSuppression", "forElement"));
        }
        return collection;
    }

    @Override
    public boolean isEmpty() {
        return this.all().isEmpty();
    }

    @Override
    @NotNull
    public ModificationTracker getModificationTracker() {
        throw new IllegalStateException("Trying to obtain modification tracker for readonly DiagnosticsWithSuppression.");
    }

    @NotNull
    public Collection<Diagnostic> getDiagnostics() {
        Collection<Diagnostic> collection = this.diagnostics;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/diagnostics/DiagnosticsWithSuppression", "getDiagnostics"));
        }
        return collection;
    }
}

