/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.OffsetKey;
import com.intellij.codeInsight.completion.OffsetMap;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InsertionContext {
    public static final OffsetKey TAIL_OFFSET = OffsetKey.create("tailOffset", true);
    private final OffsetMap myOffsetMap;
    private final char myCompletionChar;
    private final LookupElement[] myElements;
    private final PsiFile myFile;
    private final Editor myEditor;
    private Runnable myLaterRunnable;
    private boolean myAddCompletionChar;

    public InsertionContext(OffsetMap offsetMap, char completionChar, LookupElement[] elements, @NotNull PsiFile file, @NotNull Editor editor, boolean addCompletionChar) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/completion/InsertionContext", "<init>"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/completion/InsertionContext", "<init>"));
        }
        this.myOffsetMap = offsetMap;
        this.myCompletionChar = completionChar;
        this.myElements = elements;
        this.myFile = file;
        this.myEditor = editor;
        this.setTailOffset(editor.getCaretModel().getOffset());
        this.myAddCompletionChar = addCompletionChar;
    }

    public void setTailOffset(int offset) {
        this.myOffsetMap.addOffset(TAIL_OFFSET, offset);
    }

    public int getTailOffset() {
        return this.myOffsetMap.getOffset(TAIL_OFFSET);
    }

    @NotNull
    public PsiFile getFile() {
        PsiFile psiFile = this.myFile;
        if (psiFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/InsertionContext", "getFile"));
        }
        return psiFile;
    }

    @NotNull
    public Editor getEditor() {
        Editor editor = this.myEditor;
        if (editor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/InsertionContext", "getEditor"));
        }
        return editor;
    }

    public void commitDocument() {
        PsiDocumentManager.getInstance(this.getProject()).commitDocument(this.getDocument());
    }

    @NotNull
    public Document getDocument() {
        Document document = this.getEditor().getDocument();
        if (document == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/InsertionContext", "getDocument"));
        }
        return document;
    }

    public int getOffset(OffsetKey key) {
        return this.getOffsetMap().getOffset(key);
    }

    public OffsetMap getOffsetMap() {
        return this.myOffsetMap;
    }

    public OffsetKey trackOffset(int offset, boolean moveableToRight) {
        OffsetKey key = OffsetKey.create("tracked", moveableToRight);
        this.getOffsetMap().addOffset(key, offset);
        return key;
    }

    public int getStartOffset() {
        return this.myOffsetMap.getOffset(CompletionInitializationContext.START_OFFSET);
    }

    public char getCompletionChar() {
        return this.myCompletionChar;
    }

    public LookupElement[] getElements() {
        return this.myElements;
    }

    public Project getProject() {
        return this.myFile.getProject();
    }

    public int getSelectionEndOffset() {
        return this.myOffsetMap.getOffset(CompletionInitializationContext.SELECTION_END_OFFSET);
    }

    @Nullable
    public Runnable getLaterRunnable() {
        return this.myLaterRunnable;
    }

    public void setLaterRunnable(@Nullable Runnable laterRunnable) {
        this.myLaterRunnable = laterRunnable;
    }

    public void setAddCompletionChar(boolean addCompletionChar) {
        this.myAddCompletionChar = addCompletionChar;
    }

    public boolean shouldAddCompletionChar() {
        return this.myAddCompletionChar;
    }

    public CommonCodeStyleSettings getCodeStyleSettings() {
        Language lang = PsiUtilCore.getLanguageAtOffset(this.getFile(), this.getTailOffset());
        return CodeStyleSettingsManager.getSettings(this.getProject()).getCommonSettings(lang);
    }
}

