/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.requests;

import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleDiffRequest
extends ContentDiffRequest {
    @Nullable
    private final String myTitle;
    @NotNull
    private final List<DiffContent> myContents;
    @NotNull
    private final List<String> myContentTitles;

    public SimpleDiffRequest(@Nullable String title, @NotNull DiffContent content1, @NotNull DiffContent content2, @Nullable String title1, @Nullable String title2) {
        if (content1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content1", "com/intellij/diff/requests/SimpleDiffRequest", "<init>"));
        }
        if (content2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content2", "com/intellij/diff/requests/SimpleDiffRequest", "<init>"));
        }
        this(title, ContainerUtil.list((Object[])new DiffContent[]{content1, content2}), ContainerUtil.list((Object[])new String[]{title1, title2}));
    }

    public SimpleDiffRequest(@Nullable String title, @NotNull DiffContent content1, @NotNull DiffContent content2, @NotNull DiffContent content3, @Nullable String title1, @Nullable String title2, @Nullable String title3) {
        if (content1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content1", "com/intellij/diff/requests/SimpleDiffRequest", "<init>"));
        }
        if (content2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content2", "com/intellij/diff/requests/SimpleDiffRequest", "<init>"));
        }
        if (content3 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content3", "com/intellij/diff/requests/SimpleDiffRequest", "<init>"));
        }
        this(title, ContainerUtil.list((Object[])new DiffContent[]{content1, content2, content3}), ContainerUtil.list((Object[])new String[]{title1, title2, title3}));
    }

    public SimpleDiffRequest(@Nullable String title, @NotNull List<DiffContent> contents, @NotNull List<String> titles) {
        if (contents == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contents", "com/intellij/diff/requests/SimpleDiffRequest", "<init>"));
        }
        if (titles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "titles", "com/intellij/diff/requests/SimpleDiffRequest", "<init>"));
        }
        assert (contents.size() == titles.size());
        this.myTitle = title;
        this.myContents = contents;
        this.myContentTitles = titles;
    }

    @Override
    @NotNull
    public List<DiffContent> getContents() {
        List<DiffContent> list = this.myContents;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/requests/SimpleDiffRequest", "getContents"));
        }
        return list;
    }

    @Override
    @NotNull
    public List<String> getContentTitles() {
        List<String> list = this.myContentTitles;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/requests/SimpleDiffRequest", "getContentTitles"));
        }
        return list;
    }

    @Override
    @Nullable
    public String getTitle() {
        return this.myTitle;
    }

    @Override
    public void onAssigned(boolean isAssigned) {
        for (DiffContent content : this.myContents) {
            content.onAssigned(isAssigned);
        }
    }
}

