/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.Prefs;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PrivacyPolicy {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.PrivacyPolicy");
    private static final String CACHED_RESOURCE_NAME = "Cached";
    private static final String RELATIVE_RESOURCE_PATH = "JetBrains/PrivacyPolicy";
    private static final String VERSION_COMMENT_START = "<!--";
    private static final String VERSION_COMMENT_END = "-->";
    private static final String ACCEPTED_VERSION_KEY = "JetBrains.privacy_policy.accepted_version";
    private static final Version MAGIC_VERSION = new Version(999, 999);
    private static final File ourCachedPolicyFile;

    public static boolean isVersionAccepted(Version ver) {
        if (ver.isUnknown() || MAGIC_VERSION.equals(ver)) {
            return true;
        }
        Version currentAccepted = PrivacyPolicy.getAcceptedVersion();
        return !currentAccepted.isUnknown() && currentAccepted.getMajor() == ver.getMajor();
    }

    public static void setVersionAccepted(@NotNull Version version) {
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/intellij/ide/PrivacyPolicy", "setVersionAccepted"));
        }
        if (version.isUnknown()) {
            Prefs.remove(ACCEPTED_VERSION_KEY);
        } else {
            Prefs.put(ACCEPTED_VERSION_KEY, version.toString());
        }
    }

    @NotNull
    public static Version getAcceptedVersion() {
        Version version = Version.fromString(Prefs.get(ACCEPTED_VERSION_KEY, null));
        if (version == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/PrivacyPolicy", "getAcceptedVersion"));
        }
        return version;
    }

    @NotNull
    public static Pair<Version, String> getContent() {
        block4: {
            Pair<Version, String> pair;
            try {
                Pair<Version, String> fromFile = PrivacyPolicy.loadContent(new FileInputStream(ourCachedPolicyFile));
                if (((Version)fromFile.getFirst()).isUnknown()) break block4;
                pair = fromFile;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/PrivacyPolicy", "getContent"));
            }
            return pair;
        }
        Pair<Version, String> pair = PrivacyPolicy.loadContent(PrivacyPolicy.class.getResourceAsStream("/PrivacyPolicy.html"));
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/PrivacyPolicy", "getContent"));
        }
        return pair;
    }

    public static void updateText(String text) {
        try {
            FileUtil.writeToFile((File)ourCachedPolicyFile, (String)text);
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @NotNull
    private static Pair<Version, String> loadContent(InputStream stream) {
        block7: {
            if (stream == null) break block7;
            InputStreamReader reader = new InputStreamReader(stream, "utf-8");
            String text = new String(FileUtil.adaptiveLoadText((Reader)reader));
            Pair pair = Pair.create((Object)PrivacyPolicy.parseVersion(text), (Object)text);
            ((Reader)reader).close();
            Pair pair2 = pair;
            if (pair2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/PrivacyPolicy", "loadContent"));
            }
            return pair2;
            {
                catch (Throwable throwable) {
                    try {
                        ((Reader)reader).close();
                        throw throwable;
                    }
                    catch (IOException e) {
                        LOG.info((Throwable)e);
                    }
                }
            }
        }
        Pair pair = Pair.create((Object)Version.UNKNOWN, (Object)"");
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/PrivacyPolicy", "loadContent"));
        }
        return pair;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @NotNull
    private static Version parseVersion(String text) {
        block8: {
            BufferedReader reader;
            block7: {
                int endComment;
                int startComment;
                reader = new BufferedReader(new StringReader(text));
                String line = reader.readLine();
                if (line == null || (startComment = line.indexOf(VERSION_COMMENT_START)) < 0 || (endComment = line.indexOf(VERSION_COMMENT_END)) <= startComment) break block7;
                Version version = Version.fromString(line.substring(startComment + VERSION_COMMENT_START.length(), endComment).trim());
                reader.close();
                Version version2 = version;
                if (version2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/PrivacyPolicy", "parseVersion"));
                }
                return version2;
            }
            try {
                reader.close();
                break block8;
                {
                    catch (Throwable throwable) {
                        reader.close();
                        throw throwable;
                    }
                }
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
            }
        }
        Version version = Version.UNKNOWN;
        if (version == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/PrivacyPolicy", "parseVersion"));
        }
        return version;
    }

    static {
        File dataDir = null;
        if (SystemInfo.isWindows) {
            String appdata = System.getenv("APPDATA");
            if (appdata != null) {
                dataDir = new File(appdata, RELATIVE_RESOURCE_PATH);
            }
        } else {
            String userHome = System.getProperty("user.home");
            if (userHome != null) {
                if (SystemInfo.isMac) {
                    File dataRoot = new File(userHome, "/Library/Application Support");
                    if (dataRoot.exists()) {
                        dataDir = new File(dataRoot, RELATIVE_RESOURCE_PATH);
                    }
                } else if (SystemInfo.isUnix) {
                    File dataRoot;
                    String dataHome = System.getenv("XDG_DATA_HOME");
                    File file = dataRoot = dataHome == null ? new File(userHome, ".local/share") : new File(dataHome);
                    if (dataRoot.exists()) {
                        dataDir = new File(dataRoot, RELATIVE_RESOURCE_PATH);
                    }
                }
            }
        }
        if (dataDir == null) {
            dataDir = new File(PathManager.getSystemPath(), "PrivacyPolicy");
        }
        dataDir.mkdirs();
        ourCachedPolicyFile = new File(dataDir, CACHED_RESOURCE_NAME);
    }

    public static final class Version
    implements Comparable<Version> {
        public static final Version UNKNOWN = new Version(-1, -1);
        private final int myMajor;
        private final int myMinor;

        private Version(int major, int minor) {
            this.myMajor = major;
            this.myMinor = minor;
        }

        public static Version fromString(@Nullable String ver) {
            int dot;
            int major = -1;
            int minor = -1;
            int n = dot = ver == null ? -1 : ver.indexOf(46);
            if (dot > 0) {
                major = Integer.parseInt(ver.substring(0, dot));
                minor = Integer.parseInt(ver.substring(dot + 1));
            }
            return major < 0 || minor < 0 ? UNKNOWN : new Version(major, minor);
        }

        public boolean isUnknown() {
            return this.myMajor < 0 || this.myMinor < 0;
        }

        public int getMajor() {
            return this.myMajor;
        }

        public int getMinor() {
            return this.myMinor;
        }

        @Override
        public int compareTo(Version other) {
            if (this.isUnknown()) {
                return other.isUnknown() ? 0 : -1;
            }
            int majorDiff = this.myMajor - other.myMajor;
            return majorDiff != 0 ? majorDiff : this.myMinor - other.myMinor;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Version version = (Version)o;
            if (this.myMajor != version.myMajor) {
                return false;
            }
            return this.myMinor == version.myMinor;
        }

        public int hashCode() {
            int result = this.myMajor;
            result = 31 * result + this.myMinor;
            return result;
        }

        public String toString() {
            return this.isUnknown() ? "unknown" : this.myMajor + "." + this.myMinor;
        }
    }
}

