/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.concurrency.AsyncFuture;
import com.intellij.concurrency.AsyncUtil;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ArrayQuery<T>
implements Query<T> {
    private final T[] myArray;

    public ArrayQuery(T ... array) {
        if (array == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "array", "com/intellij/util/ArrayQuery", "<init>"));
        }
        this.myArray = array;
    }

    @Override
    @NotNull
    public Collection<T> findAll() {
        List<T> list = Arrays.asList(this.myArray);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ArrayQuery", "findAll"));
        }
        return list;
    }

    @Override
    public T findFirst() {
        return this.myArray.length > 0 ? (T)this.myArray[0] : null;
    }

    @Override
    public boolean forEach(@NotNull Processor<T> consumer) {
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/util/ArrayQuery", "forEach"));
        }
        return ContainerUtil.process((Object[])this.myArray, consumer);
    }

    @Override
    @NotNull
    public AsyncFuture<Boolean> forEachAsync(@NotNull Processor<T> consumer) {
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/util/ArrayQuery", "forEachAsync"));
        }
        AsyncFuture<Boolean> asyncFuture = AsyncUtil.wrapBoolean(this.forEach(consumer));
        if (asyncFuture == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ArrayQuery", "forEachAsync"));
        }
        return asyncFuture;
    }

    @Override
    @NotNull
    public T[] toArray(@NotNull T[] a) {
        if (a == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "a", "com/intellij/util/ArrayQuery", "toArray"));
        }
        if (this.myArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ArrayQuery", "toArray"));
        }
        return this.myArray;
    }

    @Override
    public Iterator<T> iterator() {
        return Arrays.asList(this.myArray).iterator();
    }
}

