/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan.formats.tiff.photometricinterpreters;

import java.awt.image.BufferedImage;
import java.io.IOException;
import org.apache.sanselan.ImageReadException;
import org.apache.sanselan.formats.tiff.photometricinterpreters.PhotometricInterpreter;

public class PhotometricInterpreterYCbCr
extends PhotometricInterpreter {
    public PhotometricInterpreterYCbCr(double[] fYCbCrCoefficients, int[] fYCbCrPositioning, int[] fYCbCrSubSampling, double[] fReferenceBlackWhite, int fSamplesPerPixel, int[] fBitsPerSample, int Predictor, int width, int height) {
        super(fSamplesPerPixel, fBitsPerSample, Predictor, width, height);
    }

    public int limit(int value, int min, int max) {
        return Math.min(max, Math.max(min, value));
    }

    public int convertYCbCrtoRGB(int Y, int Cb, int Cr) {
        double r1 = 1.164 * ((double)Y - 16.0) + 1.596 * ((double)Cr - 128.0);
        double g1 = 1.164 * ((double)Y - 16.0) - 0.813 * ((double)Cr - 128.0) - 0.392 * ((double)Cb - 128.0);
        double b1 = 1.164 * ((double)Y - 16.0) + 2.017 * ((double)Cb - 128.0);
        int r = this.limit((int)r1, 0, 255);
        int g = this.limit((int)g1, 0, 255);
        int b = this.limit((int)b1, 0, 255);
        int alpha = 255;
        int rgb = alpha << 24 | r << 16 | g << 8 | b << 0;
        return rgb;
    }

    @Override
    public void interpretPixel(BufferedImage bi, int[] samples, int x, int y) throws ImageReadException, IOException {
        int Y = samples[0];
        int Cb = samples[1];
        int Cr = samples[2];
        double R = (double)Y + 1.402 * ((double)Cr - 128.0);
        double G = (double)Y - 0.34414 * ((double)Cb - 128.0) - 0.71414 * ((double)Cr - 128.0);
        double B = (double)Y + 1.772 * ((double)Cb - 128.0);
        int red = this.limit((int)R, 0, 255);
        int green = this.limit((int)G, 0, 255);
        int blue = this.limit((int)B, 0, 255);
        int alpha = 255;
        int rgb = alpha << 24 | red << 16 | green << 8 | blue << 0;
        bi.setRGB(x, y, rgb);
    }
}

