/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.util.importProject;

import com.intellij.ide.util.projectWizard.importSources.DetectedProjectRoot;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.remoteServer.util.CloudGitDeploymentDetector;
import java.io.File;
import org.jetbrains.annotations.NotNull;

public class CloudGitProjectRoot
extends DetectedProjectRoot {
    private final String myRootTypeName;
    private final String myJavaSourceRootTypeName;
    private final VirtualFile myRepositoryRoot;
    private final String myApplicationName;

    public static String getProjectRootTypeName(CloudGitDeploymentDetector detector) {
        return detector.getCloudType().getPresentableName();
    }

    public static String getJavaSourceRootTypeName(CloudGitDeploymentDetector detector) {
        return "Java/" + CloudGitProjectRoot.getProjectRootTypeName(detector);
    }

    public CloudGitProjectRoot(CloudGitDeploymentDetector detector, @NotNull File directory, @NotNull VirtualFile repositoryRoot, String applicationName) {
        if (directory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directory", "com/intellij/remoteServer/util/importProject/CloudGitProjectRoot", "<init>"));
        }
        if (repositoryRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositoryRoot", "com/intellij/remoteServer/util/importProject/CloudGitProjectRoot", "<init>"));
        }
        super(directory);
        this.myRootTypeName = CloudGitProjectRoot.getProjectRootTypeName(detector);
        this.myJavaSourceRootTypeName = CloudGitProjectRoot.getJavaSourceRootTypeName(detector);
        this.myRepositoryRoot = repositoryRoot;
        this.myApplicationName = applicationName;
    }

    @NotNull
    public String getRootTypeName() {
        String string = this.myRootTypeName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/remoteServer/util/importProject/CloudGitProjectRoot", "getRootTypeName"));
        }
        return string;
    }

    public boolean canContainRoot(@NotNull DetectedProjectRoot root) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/remoteServer/util/importProject/CloudGitProjectRoot", "canContainRoot"));
        }
        return this.myJavaSourceRootTypeName.equals(root.getRootTypeName());
    }

    public String getApplicationName() {
        return this.myApplicationName;
    }

    public VirtualFile getRepositoryRoot() {
        return this.myRepositoryRoot;
    }

    public String getJavaSourceRootTypeName() {
        return this.myJavaSourceRootTypeName;
    }
}

