/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.packaging;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.module.JavaModuleType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.roots.ui.configuration.ChooseModulesDialog;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.packaging.artifacts.ArtifactTemplate;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.elements.ArtifactRootElement;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementFactory;
import com.intellij.packaging.elements.PackagingElementOutputKind;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaFxApplicationArtifactType
extends ArtifactType {
    public static JavaFxApplicationArtifactType getInstance() {
        return (JavaFxApplicationArtifactType)((Object)EP_NAME.findExtension(JavaFxApplicationArtifactType.class));
    }

    protected JavaFxApplicationArtifactType() {
        super("javafx", "JavaFx Application");
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = AllIcons.Nodes.Artifact;
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/packaging/JavaFxApplicationArtifactType", "getIcon"));
        }
        return icon;
    }

    @Nullable
    public String getDefaultPathFor(@NotNull PackagingElementOutputKind kind) {
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/plugins/javaFX/packaging/JavaFxApplicationArtifactType", "getDefaultPathFor"));
        }
        return "/";
    }

    @NotNull
    public CompositePackagingElement<?> createRootElement(@NotNull String artifactName) {
        if (artifactName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifactName", "org/jetbrains/plugins/javaFX/packaging/JavaFxApplicationArtifactType", "createRootElement"));
        }
        ArtifactRootElement artifactRootElement = PackagingElementFactory.getInstance().createArtifactRootElement();
        if (artifactRootElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/packaging/JavaFxApplicationArtifactType", "createRootElement"));
        }
        return artifactRootElement;
    }

    @NotNull
    public List<? extends ArtifactTemplate> getNewArtifactTemplates(@NotNull PackagingElementResolvingContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/javaFX/packaging/JavaFxApplicationArtifactType", "getNewArtifactTemplates"));
        }
        ArrayList<Module> modules = new ArrayList<Module>();
        for (Module module : context.getModulesProvider().getModules()) {
            if (!(ModuleType.get((Module)module) instanceof JavaModuleType)) continue;
            modules.add(module);
        }
        if (modules.isEmpty()) {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/packaging/JavaFxApplicationArtifactType", "getNewArtifactTemplates"));
            }
            return list;
        }
        List<JavaFxArtifactTemplate> list = Collections.singletonList(new JavaFxArtifactTemplate(modules));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/packaging/JavaFxApplicationArtifactType", "getNewArtifactTemplates"));
        }
        return list;
    }

    private class JavaFxArtifactTemplate
    extends ArtifactTemplate {
        private final List<Module> myModules;

        public JavaFxArtifactTemplate(List<Module> modules) {
            this.myModules = modules;
        }

        public String getPresentableName() {
            if (this.myModules.size() == 1) {
                return "From module '" + this.myModules.get(0).getName() + "'";
            }
            return "From module...";
        }

        public ArtifactTemplate.NewArtifactConfiguration createArtifact() {
            Module module = null;
            if (this.myModules.size() == 1) {
                module = this.myModules.get(0);
            } else {
                ChooseModulesDialog dialog = new ChooseModulesDialog(this.myModules.get(0).getProject(), this.myModules, "Select Module", "Selected module output would to be included in the artifact");
                dialog.setSingleSelectionMode();
                if (dialog.showAndGet()) {
                    List elements = dialog.getChosenElements();
                    if (elements.isEmpty()) {
                        return null;
                    }
                    module = (Module)elements.get(0);
                }
            }
            if (module == null) {
                return null;
            }
            CompositePackagingElement<?> rootElement = JavaFxApplicationArtifactType.this.createRootElement(module.getName());
            CompositePackagingElement subElement = PackagingElementFactory.getInstance().createArchive(FileUtil.sanitizeFileName((String)module.getName()) + ".jar");
            PackagingElement moduleOutputElement = PackagingElementFactory.getInstance().createModuleOutput(module);
            subElement.addFirstChild(moduleOutputElement);
            rootElement.addFirstChild((PackagingElement)subElement);
            return new ArtifactTemplate.NewArtifactConfiguration(rootElement, module.getName(), (ArtifactType)JavaFxApplicationArtifactType.this);
        }
    }
}

