/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.perflib.heap.hprof;

import com.android.tools.perflib.heap.hprof.HprofDumpRecord;
import com.android.tools.perflib.heap.hprof.HprofOutputStream;
import java.io.IOException;

public class HprofObjectArrayDump
implements HprofDumpRecord {
    public static final byte SUBTAG = 34;
    public final long arrayObjectId;
    public final int stackTraceSerialNumber;
    public final long arrayClassObjectId;
    public final long[] elements;

    public HprofObjectArrayDump(long arrayObjectId, int stackTraceSerialNumber, long arrayClassObjectId, long[] elements) {
        this.arrayObjectId = arrayObjectId;
        this.stackTraceSerialNumber = stackTraceSerialNumber;
        this.arrayClassObjectId = arrayClassObjectId;
        this.elements = elements;
    }

    @Override
    public void write(HprofOutputStream hprof) throws IOException {
        hprof.writeU1((byte)34);
        hprof.writeId(this.arrayObjectId);
        hprof.writeU4(this.stackTraceSerialNumber);
        hprof.writeU4(this.elements.length);
        hprof.writeId(this.arrayClassObjectId);
        for (long element : this.elements) {
            hprof.writeId(element);
        }
    }

    @Override
    public int getLength(int idSize) {
        return 1 + idSize + 4 + idSize + 4 + this.elements.length * idSize;
    }
}

