/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.rpclib.multiplex;

import com.android.tools.rpclib.binary.Encoder;
import gnu.trove.TLongObjectHashMap;
import gnu.trove.TLongObjectIterator;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import org.jetbrains.annotations.NotNull;

class Sender {
    private static final int MAX_PENDING_SEND_COUNT = 1024;
    private static final SendItem NOP_ITEM = new SendNop();
    private final int mMtu;
    @NotNull
    private ExecutorService mExecutorService;
    @NotNull
    private final LinkedBlockingQueue<SendItem> mPendingItems;
    private Worker mWorker;

    Sender(int mtu, @NotNull ExecutorService executorService) {
        if (executorService == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executorService", "com/android/tools/rpclib/multiplex/Sender", "<init>"));
        }
        this.mMtu = mtu;
        this.mExecutorService = executorService;
        this.mPendingItems = new LinkedBlockingQueue(1024);
    }

    void begin(Encoder out) {
        this.mWorker = new Worker(out);
        this.mExecutorService.execute(this.mWorker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void end() {
        try {
            Worker worker = this.mWorker;
            synchronized (worker) {
                this.mWorker.setRunning(false);
                this.mPendingItems.add(NOP_ITEM);
                while (!this.mWorker.isStopped()) {
                    this.mWorker.wait();
                }
                this.mWorker = null;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    void sendData(long channel, byte[] b, int off, int len) throws IOException {
        this.send(new SendData(channel, b, off, len));
    }

    void sendOpenChannel(long channel) throws IOException {
        this.send(new OpenChannel(channel));
    }

    void sendCloseChannel(long channel) throws IOException {
        this.send(new CloseChannel(channel));
    }

    private void send(SendItem item) throws IOException {
        if (this.mWorker == null) {
            throw new RuntimeException("Attempting to send item when sender is not running");
        }
        this.mPendingItems.add(item);
        item.sync();
    }

    private class SendMap {
        @NotNull
        private final TLongObjectHashMap<Queue<SendItem>> mQueues = new TLongObjectHashMap();

        private SendMap() {
        }

        public int size() {
            return this.mQueues.size();
        }

        public void add(SendItem item) {
            long channel = item.mChannel;
            ArrayDeque<SendItem> queue = (ArrayDeque<SendItem>)this.mQueues.get(channel);
            if (queue == null) {
                queue = new ArrayDeque<SendItem>();
                this.mQueues.put(channel, queue);
            }
            queue.add(item);
        }

        public void flush(Encoder e) {
            TLongObjectIterator it = this.mQueues.iterator();
            int i = this.mQueues.size();
            while (i-- > 0) {
                it.advance();
                Queue queue = (Queue)it.value();
                SendItem item = (SendItem)queue.peek();
                if (!item.send(e)) continue;
                queue.remove();
                if (queue.poll() != null) continue;
                it.remove();
            }
        }
    }

    private class SendData
    extends SendItem {
        final byte[] mData;
        int mOffset;
        int mLength;

        SendData(long channel, byte[] data, int off, int len) {
            super(channel);
            this.mData = (byte[])data.clone();
            this.mOffset = off;
            this.mLength = len;
        }

        @Override
        protected boolean encode(Encoder e) throws IOException {
            e.uint8((short)2);
            e.uint32(this.mChannel);
            int c = Math.min(this.mLength, Sender.this.mMtu);
            e.uint32(c);
            e.stream().write(this.mData, this.mOffset, c);
            this.mOffset += c;
            this.mLength -= c;
            return this.mLength == 0;
        }
    }

    private final class Worker
    extends Thread {
        private final Encoder mEncoder;
        private boolean mIsRunning;
        private boolean mIsStopped;

        Worker(Encoder encoder) {
            super("rpclib.multiplex Sender");
            this.mEncoder = encoder;
            this.mIsRunning = true;
        }

        public boolean isStopped() {
            return this.mIsStopped;
        }

        public void setRunning(boolean running) {
            this.mIsRunning = running;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            SendMap map = new SendMap();
            try {
                Object item;
                while (this.mIsRunning) {
                    item = map.size() == 0 ? (SendItem)Sender.this.mPendingItems.take() : (SendItem)Sender.this.mPendingItems.poll();
                    if (item != null) {
                        map.add((SendItem)item);
                    }
                    map.flush(this.mEncoder);
                }
                while (map.size() > 0) {
                    map.flush(this.mEncoder);
                }
                item = this;
                synchronized (item) {
                    this.mIsStopped = true;
                    this.notifyAll();
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private static class SendNop
    extends SendItem {
        SendNop() {
            super(0L);
        }

        @Override
        protected boolean encode(Encoder e) {
            return true;
        }
    }

    private static class CloseChannel
    extends SendItem {
        CloseChannel(long channel) {
            super(channel);
        }

        @Override
        protected boolean encode(Encoder e) throws IOException {
            e.uint8((short)1);
            e.uint32(this.mChannel);
            return true;
        }
    }

    private static class OpenChannel
    extends SendItem {
        OpenChannel(long channel) {
            super(channel);
        }

        @Override
        protected boolean encode(Encoder e) throws IOException {
            e.uint8((short)0);
            e.uint32(this.mChannel);
            return true;
        }
    }

    private static abstract class SendItem {
        final long mChannel;
        private boolean mDone;
        private IOException mException;

        SendItem(long channel) {
            this.mChannel = channel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final boolean send(Encoder e) {
            try {
                boolean bl = this.encode(e);
                return bl;
            }
            catch (IOException exception) {
                SendItem sendItem = this;
                synchronized (sendItem) {
                    this.mException = exception;
                }
                boolean bl = true;
                return bl;
            }
            finally {
                SendItem sendItem = this;
                synchronized (sendItem) {
                    this.mDone = true;
                    this.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void sync() throws IOException {
            SendItem sendItem = this;
            synchronized (sendItem) {
                while (!this.mDone) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (this.mException != null) {
                    throw this.mException;
                }
            }
        }

        protected abstract boolean encode(Encoder var1) throws IOException;
    }
}

