/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.Trinity;
import com.intellij.util.containers.Convertor;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.idea.svn.NativeLogReader;

public class SvnNativeCallsTranslator {
    private static final String ourGenericAdvice = "An error result is returned by native " + SystemInfo.OS_NAME + " " + SystemInfo.OS_VERSION + " call \"{0}\" done from Subversion plugin.\n" + "Error code is {1}";

    public static String getMessage(NativeLogReader.CallInfo callInfo) {
        if (SystemInfo.isMac) {
            return SvnNativeCallsTranslator.forMac(callInfo);
        }
        if (SystemInfo.isWindows) {
            return SvnNativeCallsTranslator.forWindows(callInfo);
        }
        if (SystemInfo.isLinux) {
            return SvnNativeCallsTranslator.forLinux(callInfo);
        }
        return null;
    }

    public static String forLinux(NativeLogReader.CallInfo callInfo) {
        String translate = LinuxParser.translate(callInfo);
        if (translate != null) {
            return translate;
        }
        return null;
    }

    public static String forWindows(NativeLogReader.CallInfo callInfo) {
        String translate = WindowsParser.translate(callInfo);
        if (translate != null) {
            return translate;
        }
        return null;
    }

    public static String forMac(NativeLogReader.CallInfo callInfo) {
        if (callInfo.getResultCode() == 0) {
            return null;
        }
        String translate = MacParser.translate(callInfo);
        if (translate != null) {
            return translate;
        }
        return SvnNativeCallsTranslator.defaultMessage(callInfo);
    }

    public static String defaultMessage(NativeLogReader.CallInfo callInfo) {
        return MessageFormat.format(ourGenericAdvice, callInfo.getFunctionName(), "" + callInfo.getResultCode());
    }

    public static String defaultMessageStr(NativeLogReader.CallInfo callInfo) {
        return MessageFormat.format(ourGenericAdvice, callInfo.getFunctionName(), "" + callInfo.getStrResultCode());
    }

    private static class MacParser {
        private static final Map<Integer, Trinity<String, String, String>> macMessages = new HashMap<Integer, Trinity<String, String, String>>();
        private static final HashMap<Integer, Convertor<NativeLogReader.CallInfo, String>> ourAdvices = new HashMap();

        private MacParser() {
        }

        public static String translate(NativeLogReader.CallInfo callInfo) {
            String advice;
            Convertor<NativeLogReader.CallInfo, String> convertor = ourAdvices.get(callInfo.getResultCode());
            if (convertor != null && (advice = (String)convertor.convert((Object)callInfo)) != null) {
                return advice;
            }
            Trinity<String, String, String> trinity = macMessages.get(callInfo.getResultCode());
            if (trinity == null) {
                return null;
            }
            return MessageFormat.format(ourGenericAdvice, callInfo.getFunctionName(), callInfo.getResultCode() + " ( " + (String)trinity.getFirst() + " - " + (String)trinity.getSecond() + ")");
        }

        static {
            ourAdvices.put(-25293, new Convertor<NativeLogReader.CallInfo, String>(){

                public String convert(NativeLogReader.CallInfo callInfo) {
                    if (!SystemInfo.isMac) {
                        return null;
                    }
                    Trinity trinity = (Trinity)macMessages.get(callInfo.getResultCode());
                    if (trinity == null) {
                        return null;
                    }
                    return MessageFormat.format(ourGenericAdvice, callInfo.getFunctionName(), callInfo.getResultCode() + " ( " + (String)trinity.getFirst() + " - " + (String)trinity.getSecond() + ")" + "\nYou are likely to have modified " + ApplicationInfo.getInstance().getVersionName() + " bundle.\n" + "Please try to reinstall " + ApplicationInfo.getInstance().getVersionName());
                }
            });
            macMessages.put(0, (Trinity<String, String, String>)new Trinity((Object)"errSecSuccess", (Object)"No error.", (Object)"Available in OS X v10.6 and later."));
            macMessages.put(-4, (Trinity<String, String, String>)new Trinity((Object)"errSecUnimplemented", (Object)"Function or operation not implemented.", (Object)"Available in OS X v10.6 and later."));
            macMessages.put(-50, (Trinity<String, String, String>)new Trinity((Object)"errSecParam", (Object)"One or more parameters passed to the function were not valid.", (Object)"Available in OS X v10.6 and later."));
            macMessages.put(-108, (Trinity<String, String, String>)new Trinity((Object)"errSecAllocate", (Object)"Failed to allocate memory.", (Object)"Available in OS X v10.6 and later."));
            macMessages.put(-25291, (Trinity<String, String, String>)new Trinity((Object)"errSecNotAvailable", (Object)"No trust results are available.", (Object)"Available in OS X v10.2 and later."));
            macMessages.put(-25292, (Trinity<String, String, String>)new Trinity((Object)"errSecReadOnly", (Object)"Read only error.", (Object)"Available in OS X v10.2 and later."));
            macMessages.put(-25293, (Trinity<String, String, String>)new Trinity((Object)"errSecAuthFailed", (Object)"Authorization/Authentication failed.", (Object)"Available in OS X v10.2 and later."));
            macMessages.put(-25294, (Trinity<String, String, String>)new Trinity((Object)"errSecNoSuchKeychain", (Object)"The keychain does not exist.", (Object)"Available in OS X v10.2 and later."));
            macMessages.put(-25295, (Trinity<String, String, String>)new Trinity((Object)"errSecInvalidKeychain", (Object)"The keychain is not valid.", (Object)"Available in OS X v10.2 and later."));
            macMessages.put(-25296, (Trinity<String, String, String>)new Trinity((Object)"errSecDuplicateKeychain", (Object)"A keychain with the same name already exists.", (Object)"Available in OS X v10.2 and later."));
            macMessages.put(-25297, (Trinity<String, String, String>)new Trinity((Object)"errSecDuplicateCallback", (Object)"More than one callback of the same name exists.", (Object)"Available in OS X v10.2 and later."));
            macMessages.put(-25298, (Trinity<String, String, String>)new Trinity((Object)"errSecInvalidCallback", (Object)"The callback is not valid.", (Object)"Available in OS X v10.2 and later."));
            macMessages.put(-25299, (Trinity<String, String, String>)new Trinity((Object)"errSecDuplicateItem", (Object)"The item already exists.", (Object)"Available in OS X v10.2 and later."));
            macMessages.put(-25300, (Trinity<String, String, String>)new Trinity((Object)"errSecItemNotFound", (Object)"The item cannot be found.", (Object)"Available in OS X v10.2 and later."));
            macMessages.put(-25301, (Trinity<String, String, String>)new Trinity((Object)"errSecBufferTooSmall", (Object)"The buffer is too small.", (Object)"Available in OS X v10.2 and later."));
            macMessages.put(-25302, (Trinity<String, String, String>)new Trinity((Object)"errSecDataTooLarge", (Object)"The data is too large for the particular data type.", (Object)"Available in OS X v10.2 and later."));
            macMessages.put(-25303, (Trinity<String, String, String>)new Trinity((Object)"errSecNoSuchAttr", (Object)"The attribute does not exist.", (Object)"Available in OS X v10.2 and later."));
            macMessages.put(-25304, (Trinity<String, String, String>)new Trinity((Object)"errSecInvalidItemRef", (Object)"The item reference is invalid.", (Object)"Available in OS X v10.2 and later."));
            macMessages.put(-25305, (Trinity<String, String, String>)new Trinity((Object)"errSecInvalidSearchRef", (Object)"The search reference is invalid.", (Object)"Available in OS X v10.2 and later."));
            macMessages.put(-25306, (Trinity<String, String, String>)new Trinity((Object)"errSecNoSuchClass", (Object)"The keychain item class does not exist.", (Object)"Available in OS X v10.2 and later."));
            macMessages.put(-25307, (Trinity<String, String, String>)new Trinity((Object)"errSecNoDefaultKeychain", (Object)"A default keychain does not exist.", (Object)"Available in OS X v10.2 and later."));
            macMessages.put(-25308, (Trinity<String, String, String>)new Trinity((Object)"errSecInteractionNotAllowed", (Object)"Interaction with the Security Server is not allowed.", (Object)"Available in OS X v10.2 and later."));
            macMessages.put(-25309, (Trinity<String, String, String>)new Trinity((Object)"errSecReadOnlyAttr", (Object)"The attribute is read only.", (Object)"Available in OS X v10.2 and later."));
            macMessages.put(-25310, (Trinity<String, String, String>)new Trinity((Object)"errSecWrongSecVersion", (Object)"The version is incorrect.", (Object)"Available in OS X v10.2 and later."));
            macMessages.put(-25311, (Trinity<String, String, String>)new Trinity((Object)"errSecKeySizeNotAllowed", (Object)"The key size is not allowed.", (Object)"Available in OS X v10.2 and later."));
            macMessages.put(-25312, (Trinity<String, String, String>)new Trinity((Object)"errSecNoStorageModule", (Object)"There is no storage module available.", (Object)"Available in OS X v10.2 and later."));
            macMessages.put(-25313, (Trinity<String, String, String>)new Trinity((Object)"errSecNoCertificateModule", (Object)"There is no certificate module available.", (Object)"Available in OS X v10.2 and later."));
            macMessages.put(-25314, (Trinity<String, String, String>)new Trinity((Object)"errSecNoPolicyModule", (Object)"There is no policy module available.", (Object)"Available in OS X v10.2 and later."));
            macMessages.put(-25315, (Trinity<String, String, String>)new Trinity((Object)"errSecInteractionRequired", (Object)"User interaction is required.", (Object)"Available in OS X v10.2 and later."));
            macMessages.put(-25316, (Trinity<String, String, String>)new Trinity((Object)"errSecDataNotAvailable", (Object)"The data is not available.", (Object)"Available in OS X v10.2 and later."));
            macMessages.put(-25317, (Trinity<String, String, String>)new Trinity((Object)"errSecDataNotModifiable", (Object)"The data is not modifiable.", (Object)"Available in OS X v10.2 and later."));
            macMessages.put(-25318, (Trinity<String, String, String>)new Trinity((Object)"errSecCreateChainFailed", (Object)"The attempt to create a certificate chain failed.", (Object)"Available in OS X v10.2 and later."));
            macMessages.put(-25319, (Trinity<String, String, String>)new Trinity((Object)"errSecInvalidPrefsDomain", (Object)"The preference domain specified is invalid. This error is available in OS X v10.3 and later.", (Object)"Available in OS X v10.3 and later."));
            macMessages.put(-25320, (Trinity<String, String, String>)new Trinity((Object)"errSecInDarkWake", (Object)"The user interface could not be displayed because the system is in a dark wake state.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-25240, (Trinity<String, String, String>)new Trinity((Object)"errSecACLNotSimple", (Object)"The access control list is not in standard simple form.", (Object)"Available in OS X v10.2 and later."));
            macMessages.put(-25241, (Trinity<String, String, String>)new Trinity((Object)"errSecPolicyNotFound", (Object)"The policy specified cannot be found.", (Object)"Available in OS X v10.2 and later."));
            macMessages.put(-25262, (Trinity<String, String, String>)new Trinity((Object)"errSecInvalidTrustSetting", (Object)"The trust setting is invalid.", (Object)"Available in OS X v10.2 and later."));
            macMessages.put(-25243, (Trinity<String, String, String>)new Trinity((Object)"errSecNoAccessForItem", (Object)"The specified item has no access control.", (Object)"Available in OS X v10.2 and later."));
            macMessages.put(-25244, (Trinity<String, String, String>)new Trinity((Object)"errSecInvalidOwnerEdit", (Object)"An invalid attempt to change the owner of an item.", (Object)"Available in OS X v10.2 and later."));
            macMessages.put(-25245, (Trinity<String, String, String>)new Trinity((Object)"errSecTrustNotAvailable", (Object)"No trust results are available.", (Object)"Available in OS X v10.3 and later."));
            macMessages.put(-25256, (Trinity<String, String, String>)new Trinity((Object)"errSecUnsupportedFormat", (Object)"The specified import or export format is not supported.", (Object)"Available in OS X v10.4 and later."));
            macMessages.put(-25257, (Trinity<String, String, String>)new Trinity((Object)"errSecUnknownFormat", (Object)"The item you are trying to import has an unknown format.", (Object)"Available in OS X v10.4 and later."));
            macMessages.put(-25258, (Trinity<String, String, String>)new Trinity((Object)"errSecKeyIsSensitive", (Object)"The key must be wrapped to be exported.", (Object)"Available in OS X v10.4 and later."));
            macMessages.put(-25259, (Trinity<String, String, String>)new Trinity((Object)"errSecMultiplePrivKeys", (Object)"An attempt was made to import multiple private keys.", (Object)"Available in OS X v10.4 and later."));
            macMessages.put(-25260, (Trinity<String, String, String>)new Trinity((Object)"errSecPassphraseRequired", (Object)"A password is required for import or export.", (Object)"Available in OS X v10.4 and later."));
            macMessages.put(-25261, (Trinity<String, String, String>)new Trinity((Object)"errSecInvalidPasswordRef", (Object)"The password reference was invalid.", (Object)"Available in OS X v10.4 and later."));
            macMessages.put(-25262, (Trinity<String, String, String>)new Trinity((Object)"errSecInvalidTrustSettings", (Object)"The trust settings record was corrupted.", (Object)"Available in OS X v10.5 and later."));
            macMessages.put(-25263, (Trinity<String, String, String>)new Trinity((Object)"errSecNoTrustSettings", (Object)"No trust settings were found.", (Object)"Available in OS X v10.5 and later."));
            macMessages.put(-25264, (Trinity<String, String, String>)new Trinity((Object)"errSecPkcs12VerifyFailure", (Object)"MAC verification failed during PKCS12 Import.", (Object)"Available in OS X v10.5 and later."));
            macMessages.put(-26267, (Trinity<String, String, String>)new Trinity((Object)"errSecNotSigner", (Object)"The certificate was not signed by its proposed parent.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-26275, (Trinity<String, String, String>)new Trinity((Object)"errSecDecode", (Object)"Unable to decode the provided data.", (Object)"Available in OS X v10.6 and later."));
            macMessages.put(-67585, (Trinity<String, String, String>)new Trinity((Object)"errSecServiceNotAvailable", (Object)"The required service is not available.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67586, (Trinity<String, String, String>)new Trinity((Object)"errSecInsufficientClientID", (Object)"The client ID is not correct.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67587, (Trinity<String, String, String>)new Trinity((Object)"errSecDeviceReset", (Object)"A device reset has occurred.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67588, (Trinity<String, String, String>)new Trinity((Object)"errSecDeviceFailed", (Object)"A device failure has occurred.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67589, (Trinity<String, String, String>)new Trinity((Object)"errSecAppleAddAppACLSubject", (Object)"Adding an application ACL subject failed.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67590, (Trinity<String, String, String>)new Trinity((Object)"errSecApplePublicKeyIncomplete", (Object)"The public key is incomplete.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67591, (Trinity<String, String, String>)new Trinity((Object)"errSecAppleSignatureMismatch", (Object)"A signature mismatch has occurred.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67592, (Trinity<String, String, String>)new Trinity((Object)"errSecAppleInvalidKeyStartDate", (Object)"The specified key has an invalid start date.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67593, (Trinity<String, String, String>)new Trinity((Object)"errSecAppleInvalidKeyEndDate", (Object)"The specified key has an invalid end date.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67594, (Trinity<String, String, String>)new Trinity((Object)"errSecConversionError", (Object)"A conversion error has occurred.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67595, (Trinity<String, String, String>)new Trinity((Object)"errSecAppleSSLv2Rollback", (Object)"A SSLv2 rollback error has occurred.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-34, (Trinity<String, String, String>)new Trinity((Object)"errSecDiskFull", (Object)"The disk is full.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67596, (Trinity<String, String, String>)new Trinity((Object)"errSecQuotaExceeded", (Object)"The quota was exceeded.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67597, (Trinity<String, String, String>)new Trinity((Object)"errSecFileTooBig", (Object)"The file is too big.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67598, (Trinity<String, String, String>)new Trinity((Object)"errSecInvalidDatabaseBlob", (Object)"The specified database has an invalid blob.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67599, (Trinity<String, String, String>)new Trinity((Object)"errSecInvalidKeyBlob", (Object)"The specified database has an invalid key blob.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67600, (Trinity<String, String, String>)new Trinity((Object)"errSecIncompatibleDatabaseBlob", (Object)"The specified database has an incompatible blob.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67601, (Trinity<String, String, String>)new Trinity((Object)"errSecIncompatibleKeyBlob", (Object)"The specified database has an incompatible key blob.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67602, (Trinity<String, String, String>)new Trinity((Object)"errSecHostNameMismatch", (Object)"A host name mismatch has occurred.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67603, (Trinity<String, String, String>)new Trinity((Object)"errSecUnknownCriticalExtensionFlag", (Object)"There is an unknown critical extension flag.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67604, (Trinity<String, String, String>)new Trinity((Object)"errSecNoBasicConstraints", (Object)"No basic constraints were found.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67605, (Trinity<String, String, String>)new Trinity((Object)"errSecNoBasicConstraintsCA", (Object)"No basic CA constraints were found.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67606, (Trinity<String, String, String>)new Trinity((Object)"errSecInvalidAuthorityKeyID", (Object)"The authority key ID is not valid.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67607, (Trinity<String, String, String>)new Trinity((Object)"errSecInvalidSubjectKeyID", (Object)"The subject key ID is not valid.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67608, (Trinity<String, String, String>)new Trinity((Object)"errSecInvalidKeyUsageForPolicy", (Object)"The key usage is not valid for the specified policy.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67609, (Trinity<String, String, String>)new Trinity((Object)"errSecInvalidExtendedKeyUsage", (Object)"The extended key usage is not valid.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67610, (Trinity<String, String, String>)new Trinity((Object)"errSecInvalidIDLinkage", (Object)"The ID linkage is not valid.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67611, (Trinity<String, String, String>)new Trinity((Object)"errSecPathLengthConstraintExceeded", (Object)"The path length constraint was exceeded.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67612, (Trinity<String, String, String>)new Trinity((Object)"errSecInvalidRoot", (Object)"The root or anchor certificate is not valid.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67613, (Trinity<String, String, String>)new Trinity((Object)"errSecCRLExpired", (Object)"The CRL has expired.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67614, (Trinity<String, String, String>)new Trinity((Object)"errSecCRLNotValidYet", (Object)"The CRL is not yet valid.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67615, (Trinity<String, String, String>)new Trinity((Object)"errSecCRLNotFound", (Object)"The CRL was not found.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67616, (Trinity<String, String, String>)new Trinity((Object)"errSecCRLServerDown", (Object)"The CRL server is down.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67617, (Trinity<String, String, String>)new Trinity((Object)"errSecCRLBadURI", (Object)"The CRL has a bad Uniform Resource Identifier.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67618, (Trinity<String, String, String>)new Trinity((Object)"errSecUnknownCertExtension", (Object)"An unknown certificate extension was encountered.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67619, (Trinity<String, String, String>)new Trinity((Object)"errSecUnknownCRLExtension", (Object)"An unknown CRL extension was encountered.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67620, (Trinity<String, String, String>)new Trinity((Object)"errSecCRLNotTrusted", (Object)"The CRL is not trusted.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67621, (Trinity<String, String, String>)new Trinity((Object)"errSecCRLPolicyFailed", (Object)"The CRL policy failed.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67622, (Trinity<String, String, String>)new Trinity((Object)"errSecIDPFailure", (Object)"The issuing distribution point was not valid.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67623, (Trinity<String, String, String>)new Trinity((Object)"errSecSMIMEEmailAddressesNotFound", (Object)"An email address mismatch was encountered.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67624, (Trinity<String, String, String>)new Trinity((Object)"errSecSMIMEBadExtendedKeyUsage", (Object)"The appropriate extended key usage for SMIME was not found.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67625, (Trinity<String, String, String>)new Trinity((Object)"errSecSMIMEBadKeyUsage", (Object)"The key usage is not compatible with SMIME.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67626, (Trinity<String, String, String>)new Trinity((Object)"errSecSMIMEKeyUsageNotCritical", (Object)"The key usage extension is not marked as critical.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67627, (Trinity<String, String, String>)new Trinity((Object)"errSecSMIMENoEmailAddress", (Object)"No email address was found in the certificate.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67628, (Trinity<String, String, String>)new Trinity((Object)"errSecSMIMESubjAltNameNotCritical", (Object)"The subject alternative name extension is not marked as critical.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67629, (Trinity<String, String, String>)new Trinity((Object)"errSecSSLBadExtendedKeyUsage", (Object)"The appropriate extended key usage for SSL was not found.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67630, (Trinity<String, String, String>)new Trinity((Object)"errSecOCSPBadResponse", (Object)"The OCSP response was incorrect or could not be parsed.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67631, (Trinity<String, String, String>)new Trinity((Object)"errSecOCSPBadRequest", (Object)"The OCSP request was incorrect or could not be parsed.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67632, (Trinity<String, String, String>)new Trinity((Object)"errSecOCSPUnavailable", (Object)"OCSP service is unavailable.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67633, (Trinity<String, String, String>)new Trinity((Object)"errSecOCSPStatusUnrecognized", (Object)"The OCSP server did not recognize this certificate.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67634, (Trinity<String, String, String>)new Trinity((Object)"errSecEndOfData", (Object)"An end-of-data was detected.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67635, (Trinity<String, String, String>)new Trinity((Object)"errSecIncompleteCertRevocationCheck", (Object)"An incomplete certificate revocation check occurred.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67636, (Trinity<String, String, String>)new Trinity((Object)"errSecNetworkFailure", (Object)"A network failure occurred.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67637, (Trinity<String, String, String>)new Trinity((Object)"errSecOCSPNotTrustedToAnchor", (Object)"The OCSP response was not trusted to a root or anchor certificate.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67638, (Trinity<String, String, String>)new Trinity((Object)"errSecRecordModified", (Object)"The record was modified.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67639, (Trinity<String, String, String>)new Trinity((Object)"errSecOCSPSignatureError", (Object)"The OCSP response had an invalid signature.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67640, (Trinity<String, String, String>)new Trinity((Object)"errSecOCSPNoSigner", (Object)"The OCSP response had no signer.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67641, (Trinity<String, String, String>)new Trinity((Object)"errSecOCSPResponderMalformedReq", (Object)"The OCSP responder was given a malformed request.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67642, (Trinity<String, String, String>)new Trinity((Object)"errSecOCSPResponderInternalError", (Object)"The OCSP responder encountered an internal error.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67643, (Trinity<String, String, String>)new Trinity((Object)"errSecOCSPResponderTryLater", (Object)"The OCSP responder is busy, try again later.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67644, (Trinity<String, String, String>)new Trinity((Object)"errSecOCSPResponderSignatureRequired", (Object)"The OCSP responder requires a signature.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67645, (Trinity<String, String, String>)new Trinity((Object)"errSecOCSPResponderUnauthorized", (Object)"The OCSP responder rejected this request as unauthorized.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67646, (Trinity<String, String, String>)new Trinity((Object)"errSecOCSPResponseNonceMismatch", (Object)"The OCSP response nonce did not match the request.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67647, (Trinity<String, String, String>)new Trinity((Object)"errSecCodeSigningBadCertChainLength", (Object)"Code signing encountered an incorrect certificate chain length.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67648, (Trinity<String, String, String>)new Trinity((Object)"errSecCodeSigningNoBasicConstraints", (Object)"Code signing found no basic constraints.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67649, (Trinity<String, String, String>)new Trinity((Object)"errSecCodeSigningBadPathLengthConstraint", (Object)"Code signing encountered an incorrect path length constraint.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67650, (Trinity<String, String, String>)new Trinity((Object)"errSecCodeSigningNoExtendedKeyUsage", (Object)"Code signing found no extended key usage.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67651, (Trinity<String, String, String>)new Trinity((Object)"errSecCodeSigningDevelopment", (Object)"Code signing indicated use of a development-only certificate.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67652, (Trinity<String, String, String>)new Trinity((Object)"errSecResourceSignBadCertChainLength", (Object)"Resource signing has encountered an incorrect certificate chain length.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67653, (Trinity<String, String, String>)new Trinity((Object)"errSecResourceSignBadExtKeyUsage", (Object)"Resource signing has encountered an error in the extended key usage.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67654, (Trinity<String, String, String>)new Trinity((Object)"errSecTrustSettingDeny", (Object)"The trust setting for this policy was set to Deny.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67655, (Trinity<String, String, String>)new Trinity((Object)"errSecInvalidSubjectName", (Object)"An invalid certificate subject name was encountered.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67656, (Trinity<String, String, String>)new Trinity((Object)"errSecUnknownQualifiedCertStatement", (Object)"An unknown qualified certificate statement was encountered.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67657, (Trinity<String, String, String>)new Trinity((Object)"errSecMobileMeRequestQueued", (Object)"The MobileMe request will be sent during the next connection.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67658, (Trinity<String, String, String>)new Trinity((Object)"errSecMobileMeRequestRedirected", (Object)"The MobileMe request was redirected.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67659, (Trinity<String, String, String>)new Trinity((Object)"errSecMobileMeServerError", (Object)"A MobileMe server error occurred.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67660, (Trinity<String, String, String>)new Trinity((Object)"errSecMobileMeServerNotAvailable", (Object)"The MobileMe server is not available.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67661, (Trinity<String, String, String>)new Trinity((Object)"errSecMobileMeServerAlreadyExists", (Object)"The MobileMe server reported that the item already exists.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67662, (Trinity<String, String, String>)new Trinity((Object)"errSecMobileMeServerServiceErr", (Object)"A MobileMe service error has occurred.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67663, (Trinity<String, String, String>)new Trinity((Object)"errSecMobileMeRequestAlreadyPending", (Object)"A MobileMe request is already pending.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67664, (Trinity<String, String, String>)new Trinity((Object)"errSecMobileMeNoRequestPending", (Object)"MobileMe has no request pending.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67665, (Trinity<String, String, String>)new Trinity((Object)"errSecMobileMeCSRVerifyFailure", (Object)"A MobileMe CSR verification failure has occurred.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67666, (Trinity<String, String, String>)new Trinity((Object)"errSecMobileMeFailedConsistencyCheck", (Object)"MobileMe has found a failed consistency check.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67667, (Trinity<String, String, String>)new Trinity((Object)"errSecNotInitialized", (Object)"A function was called without initializing CSSM.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67668, (Trinity<String, String, String>)new Trinity((Object)"errSecInvalidHandleUsage", (Object)"The CSSM handle does not match with the service type.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67669, (Trinity<String, String, String>)new Trinity((Object)"errSecPVCReferentNotFound", (Object)"A reference to the calling module was not found in the list of authorized callers.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67670, (Trinity<String, String, String>)new Trinity((Object)"errSecFunctionIntegrityFail", (Object)"A function address was not within the verified module.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67671, (Trinity<String, String, String>)new Trinity((Object)"errSecInternalError", (Object)"An internal error has occurred.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67672, (Trinity<String, String, String>)new Trinity((Object)"errSecMemoryError", (Object)"A memory error has occurred.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67673, (Trinity<String, String, String>)new Trinity((Object)"errSecInvalidData", (Object)"Invalid data was encountered.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67674, (Trinity<String, String, String>)new Trinity((Object)"errSecMDSError", (Object)"A Module Directory Service error has occurred.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67675, (Trinity<String, String, String>)new Trinity((Object)"errSecInvalidPointer", (Object)"An invalid pointer was encountered.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67676, (Trinity<String, String, String>)new Trinity((Object)"errSecSelfCheckFailed", (Object)"Self-check has failed.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67677, (Trinity<String, String, String>)new Trinity((Object)"errSecFunctionFailed", (Object)"A function has failed.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67678, (Trinity<String, String, String>)new Trinity((Object)"errSecModuleManifestVerifyFailed", (Object)"A module manifest verification failure has occurred.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67679, (Trinity<String, String, String>)new Trinity((Object)"errSecInvalidGUID", (Object)"An invalid GUID was encountered.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67680, (Trinity<String, String, String>)new Trinity((Object)"errSecInvalidHandle", (Object)"An invalid handle was encountered.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67681, (Trinity<String, String, String>)new Trinity((Object)"errSecInvalidDBList", (Object)"An invalid DB list was encountered.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67682, (Trinity<String, String, String>)new Trinity((Object)"errSecInvalidPassthroughID", (Object)"An invalid passthrough ID was encountered.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67683, (Trinity<String, String, String>)new Trinity((Object)"errSecInvalidNetworkAddress", (Object)"An invalid network address was encountered.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67684, (Trinity<String, String, String>)new Trinity((Object)"errSecCRLAlreadySigned", (Object)"The certificate revocation list is already signed.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67685, (Trinity<String, String, String>)new Trinity((Object)"errSecInvalidNumberOfFields", (Object)"An invalid number of fields were encountered.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67686, (Trinity<String, String, String>)new Trinity((Object)"errSecVerificationFailure", (Object)"A verification failure occurred.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67687, (Trinity<String, String, String>)new Trinity((Object)"errSecUnknownTag", (Object)"An unknown tag was encountered.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67688, (Trinity<String, String, String>)new Trinity((Object)"errSecInvalidSignature", (Object)"An invalid signature was encountered.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67689, (Trinity<String, String, String>)new Trinity((Object)"errSecInvalidName", (Object)"An invalid name was encountered.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67690, (Trinity<String, String, String>)new Trinity((Object)"errSecInvalidCertificateRef", (Object)"An invalid certificate reference was encountered.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67691, (Trinity<String, String, String>)new Trinity((Object)"errSecInvalidCertificateGroup", (Object)"An invalid certificate group was encountered.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67692, (Trinity<String, String, String>)new Trinity((Object)"errSecTagNotFound", (Object)"The specified tag was not found.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67693, (Trinity<String, String, String>)new Trinity((Object)"errSecInvalidQuery", (Object)"The specified query was not valid.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67694, (Trinity<String, String, String>)new Trinity((Object)"errSecInvalidValue", (Object)"An invalid value was detected.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67695, (Trinity<String, String, String>)new Trinity((Object)"errSecCallbackFailed", (Object)"A callback has failed.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67696, (Trinity<String, String, String>)new Trinity((Object)"errSecACLDeleteFailed", (Object)"An ACL delete operation has failed.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67697, (Trinity<String, String, String>)new Trinity((Object)"errSecACLReplaceFailed", (Object)"An ACL replace operation has failed.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67698, (Trinity<String, String, String>)new Trinity((Object)"errSecACLAddFailed", (Object)"An ACL add operation has failed.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67699, (Trinity<String, String, String>)new Trinity((Object)"errSecACLChangeFailed", (Object)"An ACL change operation has failed.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67700, (Trinity<String, String, String>)new Trinity((Object)"errSecInvalidAccessCredentials", (Object)"Invalid access credentials were encountered.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67701, (Trinity<String, String, String>)new Trinity((Object)"errSecInvalidRecord", (Object)"An invalid record was encountered.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67702, (Trinity<String, String, String>)new Trinity((Object)"errSecInvalidACL", (Object)"An invalid ACL was encountered.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67703, (Trinity<String, String, String>)new Trinity((Object)"errSecInvalidSampleValue", (Object)"An invalid sample value was encountered.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67704, (Trinity<String, String, String>)new Trinity((Object)"errSecIncompatibleVersion", (Object)"An incompatible version was encountered.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67705, (Trinity<String, String, String>)new Trinity((Object)"errSecPrivilegeNotGranted", (Object)"The privilege was not granted.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67706, (Trinity<String, String, String>)new Trinity((Object)"errSecInvalidScope", (Object)"An invalid scope was encountered.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67707, (Trinity<String, String, String>)new Trinity((Object)"errSecPVCAlreadyConfigured", (Object)"The PVC is already configured.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67708, (Trinity<String, String, String>)new Trinity((Object)"errSecInvalidPVC", (Object)"An invalid PVC was encountered.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67709, (Trinity<String, String, String>)new Trinity((Object)"errSecEMMLoadFailed", (Object)"The EMM load has failed.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67710, (Trinity<String, String, String>)new Trinity((Object)"errSecEMMUnloadFailed", (Object)"The EMM unload has failed.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67711, (Trinity<String, String, String>)new Trinity((Object)"errSecAddinLoadFailed", (Object)"The add-in load operation has failed.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67712, (Trinity<String, String, String>)new Trinity((Object)"errSecInvalidKeyRef", (Object)"An invalid key was encountered.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67713, (Trinity<String, String, String>)new Trinity((Object)"errSecInvalidKeyHierarchy", (Object)"An invalid key hierarchy was encountered.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67714, (Trinity<String, String, String>)new Trinity((Object)"errSecAddinUnloadFailed", (Object)"The add-in unload operation has failed.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67715, (Trinity<String, String, String>)new Trinity((Object)"errSecLibraryReferenceNotFound", (Object)"A library reference was not found.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67716, (Trinity<String, String, String>)new Trinity((Object)"errSecInvalidAddinFunctionTable", (Object)"An invalid add-in function table was encountered.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67717, (Trinity<String, String, String>)new Trinity((Object)"errSecInvalidServiceMask", (Object)"An invalid service mask was encountered.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67718, (Trinity<String, String, String>)new Trinity((Object)"errSecModuleNotLoaded", (Object)"A module was not loaded.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67719, (Trinity<String, String, String>)new Trinity((Object)"errSecInvalidSubServiceID", (Object)"An invalid subservice ID was encountered.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67720, (Trinity<String, String, String>)new Trinity((Object)"errSecAttributeNotInContext", (Object)"An attribute was not in the context.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67721, (Trinity<String, String, String>)new Trinity((Object)"errSecModuleManagerInitializeFailed", (Object)"A module failed to initialize.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67722, (Trinity<String, String, String>)new Trinity((Object)"errSecModuleManagerNotFound", (Object)"A module was not found.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67723, (Trinity<String, String, String>)new Trinity((Object)"errSecEventNotificationCallbackNotFound", (Object)"An event notification callback was not found.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67724, (Trinity<String, String, String>)new Trinity((Object)"errSecInputLengthError", (Object)"An input length error was encountered.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67725, (Trinity<String, String, String>)new Trinity((Object)"errSecOutputLengthError", (Object)"An output length error was encountered.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67726, (Trinity<String, String, String>)new Trinity((Object)"errSecPrivilegeNotSupported", (Object)"The privilege is not supported.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67727, (Trinity<String, String, String>)new Trinity((Object)"errSecDeviceError", (Object)"A device error was encountered.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67728, (Trinity<String, String, String>)new Trinity((Object)"errSecAttachHandleBusy", (Object)"The CSP handle was busy.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67729, (Trinity<String, String, String>)new Trinity((Object)"errSecNotLoggedIn", (Object)"You are not logged in.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67730, (Trinity<String, String, String>)new Trinity((Object)"errSecAlgorithmMismatch", (Object)"An algorithm mismatch was encountered.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67731, (Trinity<String, String, String>)new Trinity((Object)"errSecKeyUsageIncorrect", (Object)"The key usage is incorrect.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67732, (Trinity<String, String, String>)new Trinity((Object)"errSecKeyBlobTypeIncorrect", (Object)"The key blob type is incorrect.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67733, (Trinity<String, String, String>)new Trinity((Object)"errSecKeyHeaderInconsistent", (Object)"The key header is inconsistent.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67734, (Trinity<String, String, String>)new Trinity((Object)"errSecUnsupportedKeyFormat", (Object)"The key header format is not supported.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67735, (Trinity<String, String, String>)new Trinity((Object)"errSecUnsupportedKeySize", (Object)"The key size is not supported.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67736, (Trinity<String, String, String>)new Trinity((Object)"errSecInvalidKeyUsageMask", (Object)"The key usage mask is not valid.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67737, (Trinity<String, String, String>)new Trinity((Object)"errSecUnsupportedKeyUsageMask", (Object)"The key usage mask is not supported.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67738, (Trinity<String, String, String>)new Trinity((Object)"errSecInvalidKeyAttributeMask", (Object)"The key attribute mask is not valid.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67739, (Trinity<String, String, String>)new Trinity((Object)"errSecUnsupportedKeyAttributeMask", (Object)"The key attribute mask is not supported.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67740, (Trinity<String, String, String>)new Trinity((Object)"errSecInvalidKeyLabel", (Object)"The key label is not valid.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67741, (Trinity<String, String, String>)new Trinity((Object)"errSecUnsupportedKeyLabel", (Object)"The key label is not supported.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67742, (Trinity<String, String, String>)new Trinity((Object)"errSecInvalidKeyFormat", (Object)"The key format is not valid.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67743, (Trinity<String, String, String>)new Trinity((Object)"errSecUnsupportedVectorOfBuffers", (Object)"The vector of buffers is not supported.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67744, (Trinity<String, String, String>)new Trinity((Object)"errSecInvalidInputVector", (Object)"The input vector is not valid.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67745, (Trinity<String, String, String>)new Trinity((Object)"errSecInvalidOutputVector", (Object)"The output vector is not valid.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67746, (Trinity<String, String, String>)new Trinity((Object)"errSecInvalidContext", (Object)"An invalid context was encountered.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67747, (Trinity<String, String, String>)new Trinity((Object)"errSecInvalidAlgorithm", (Object)"An invalid algorithm was encountered.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67748, (Trinity<String, String, String>)new Trinity((Object)"errSecInvalidAttributeKey", (Object)"A key attribute was not valid.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67749, (Trinity<String, String, String>)new Trinity((Object)"errSecMissingAttributeKey", (Object)"A key attribute was missing.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67750, (Trinity<String, String, String>)new Trinity((Object)"errSecInvalidAttributeInitVector", (Object)"An init vector attribute was not valid.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67751, (Trinity<String, String, String>)new Trinity((Object)"errSecMissingAttributeInitVector", (Object)"An init vector attribute was missing.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67752, (Trinity<String, String, String>)new Trinity((Object)"errSecInvalidAttributeSalt", (Object)"A salt attribute was not valid.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67753, (Trinity<String, String, String>)new Trinity((Object)"errSecMissingAttributeSalt", (Object)"A salt attribute was missing.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67754, (Trinity<String, String, String>)new Trinity((Object)"errSecInvalidAttributePadding", (Object)"A padding attribute was not valid.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67755, (Trinity<String, String, String>)new Trinity((Object)"errSecMissingAttributePadding", (Object)"A padding attribute was missing.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67756, (Trinity<String, String, String>)new Trinity((Object)"errSecInvalidAttributeRandom", (Object)"A random number attribute was not valid.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67757, (Trinity<String, String, String>)new Trinity((Object)"errSecMissingAttributeRandom", (Object)"A random number attribute was missing.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67758, (Trinity<String, String, String>)new Trinity((Object)"errSecInvalidAttributeSeed", (Object)"A seed attribute was not valid.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67759, (Trinity<String, String, String>)new Trinity((Object)"errSecMissingAttributeSeed", (Object)"A seed attribute was missing.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67760, (Trinity<String, String, String>)new Trinity((Object)"errSecInvalidAttributePassphrase", (Object)"A passphrase attribute was not valid.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67761, (Trinity<String, String, String>)new Trinity((Object)"errSecMissingAttributePassphrase", (Object)"A passphrase attribute was missing.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67762, (Trinity<String, String, String>)new Trinity((Object)"errSecInvalidAttributeKeyLength", (Object)"A key length attribute was not valid.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67763, (Trinity<String, String, String>)new Trinity((Object)"errSecMissingAttributeKeyLength", (Object)"A key length attribute was missing.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67764, (Trinity<String, String, String>)new Trinity((Object)"errSecInvalidAttributeBlockSize", (Object)"A block size attribute was not valid.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67765, (Trinity<String, String, String>)new Trinity((Object)"errSecMissingAttributeBlockSize", (Object)"A block size attribute was missing.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67766, (Trinity<String, String, String>)new Trinity((Object)"errSecInvalidAttributeOutputSize", (Object)"An output size attribute was not valid.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67767, (Trinity<String, String, String>)new Trinity((Object)"errSecMissingAttributeOutputSize", (Object)"An output size attribute was missing.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67768, (Trinity<String, String, String>)new Trinity((Object)"errSecInvalidAttributeRounds", (Object)"The number of rounds attribute was not valid.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67769, (Trinity<String, String, String>)new Trinity((Object)"errSecMissingAttributeRounds", (Object)"The number of rounds attribute was missing.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67770, (Trinity<String, String, String>)new Trinity((Object)"errSecInvalidAlgorithmParms", (Object)"An algorithm parameters attribute was not valid.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67771, (Trinity<String, String, String>)new Trinity((Object)"errSecMissingAlgorithmParms", (Object)"An algorithm parameters attribute was missing.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67772, (Trinity<String, String, String>)new Trinity((Object)"errSecInvalidAttributeLabel", (Object)"A label attribute was not valid.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67773, (Trinity<String, String, String>)new Trinity((Object)"errSecMissingAttributeLabel", (Object)"A label attribute was missing.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67774, (Trinity<String, String, String>)new Trinity((Object)"errSecInvalidAttributeKeyType", (Object)"A key type attribute was not valid.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67775, (Trinity<String, String, String>)new Trinity((Object)"errSecMissingAttributeKeyType", (Object)"A key type attribute was missing.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67776, (Trinity<String, String, String>)new Trinity((Object)"errSecInvalidAttributeMode", (Object)"A mode attribute was not valid.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67777, (Trinity<String, String, String>)new Trinity((Object)"errSecMissingAttributeMode", (Object)"A mode attribute was missing.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67778, (Trinity<String, String, String>)new Trinity((Object)"errSecInvalidAttributeEffectiveBits", (Object)"An effective bits attribute was not valid.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67779, (Trinity<String, String, String>)new Trinity((Object)"errSecMissingAttributeEffectiveBits", (Object)"An effective bits attribute was missing.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67780, (Trinity<String, String, String>)new Trinity((Object)"errSecInvalidAttributeStartDate", (Object)"A start date attribute was not valid.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67781, (Trinity<String, String, String>)new Trinity((Object)"errSecMissingAttributeStartDate", (Object)"A start date attribute was missing.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67782, (Trinity<String, String, String>)new Trinity((Object)"errSecInvalidAttributeEndDate", (Object)"An end date attribute was not valid.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67783, (Trinity<String, String, String>)new Trinity((Object)"errSecMissingAttributeEndDate", (Object)"An end date attribute was missing.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67784, (Trinity<String, String, String>)new Trinity((Object)"errSecInvalidAttributeVersion", (Object)"A version attribute was not valid.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67785, (Trinity<String, String, String>)new Trinity((Object)"errSecMissingAttributeVersion", (Object)"A version attribute was missing.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67786, (Trinity<String, String, String>)new Trinity((Object)"errSecInvalidAttributePrime", (Object)"A prime attribute was not valid.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67787, (Trinity<String, String, String>)new Trinity((Object)"errSecMissingAttributePrime", (Object)"A prime attribute was missing.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67788, (Trinity<String, String, String>)new Trinity((Object)"errSecInvalidAttributeBase", (Object)"A base attribute was not valid.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67789, (Trinity<String, String, String>)new Trinity((Object)"errSecMissingAttributeBase", (Object)"A base attribute was missing.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67790, (Trinity<String, String, String>)new Trinity((Object)"errSecInvalidAttributeSubprime", (Object)"A subprime attribute was not valid.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67791, (Trinity<String, String, String>)new Trinity((Object)"errSecMissingAttributeSubprime", (Object)"A subprime attribute was missing.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67792, (Trinity<String, String, String>)new Trinity((Object)"errSecInvalidAttributeIterationCount", (Object)"An iteration count attribute was not valid.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67793, (Trinity<String, String, String>)new Trinity((Object)"errSecMissingAttributeIterationCount", (Object)"An iteration count attribute was missing.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67794, (Trinity<String, String, String>)new Trinity((Object)"errSecInvalidAttributeDLDBHandle", (Object)"A database handle attribute was not valid.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67795, (Trinity<String, String, String>)new Trinity((Object)"errSecMissingAttributeDLDBHandle", (Object)"A database handle attribute was missing.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67796, (Trinity<String, String, String>)new Trinity((Object)"errSecInvalidAttributeAccessCredentials", (Object)"An access credentials attribute was not valid.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67797, (Trinity<String, String, String>)new Trinity((Object)"errSecMissingAttributeAccessCredentials", (Object)"An access credentials attribute was missing.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67798, (Trinity<String, String, String>)new Trinity((Object)"errSecInvalidAttributePublicKeyFormat", (Object)"A public key format attribute was not valid.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67799, (Trinity<String, String, String>)new Trinity((Object)"errSecMissingAttributePublicKeyFormat", (Object)"A public key format attribute was missing.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67800, (Trinity<String, String, String>)new Trinity((Object)"errSecInvalidAttributePrivateKeyFormat", (Object)"A private key format attribute was not valid.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67801, (Trinity<String, String, String>)new Trinity((Object)"errSecMissingAttributePrivateKeyFormat", (Object)"A private key format attribute was missing.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67802, (Trinity<String, String, String>)new Trinity((Object)"errSecInvalidAttributeSymmetricKeyFormat", (Object)"A symmetric key format attribute was not valid.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67803, (Trinity<String, String, String>)new Trinity((Object)"errSecMissingAttributeSymmetricKeyFormat", (Object)"A symmetric key format attribute was missing.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67804, (Trinity<String, String, String>)new Trinity((Object)"errSecInvalidAttributeWrappedKeyFormat", (Object)"A wrapped key format attribute was not valid.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67805, (Trinity<String, String, String>)new Trinity((Object)"errSecMissingAttributeWrappedKeyFormat", (Object)"A wrapped key format attribute was missing.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67806, (Trinity<String, String, String>)new Trinity((Object)"errSecStagedOperationInProgress", (Object)"A staged operation is in progress.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67807, (Trinity<String, String, String>)new Trinity((Object)"errSecStagedOperationNotStarted", (Object)"A staged operation was not started.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67808, (Trinity<String, String, String>)new Trinity((Object)"errSecVerifyFailed", (Object)"A cryptographic verification failure has occurred.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67809, (Trinity<String, String, String>)new Trinity((Object)"errSecQuerySizeUnknown", (Object)"The query size is unknown.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67810, (Trinity<String, String, String>)new Trinity((Object)"errSecBlockSizeMismatch", (Object)"A block size mismatch occurred.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67811, (Trinity<String, String, String>)new Trinity((Object)"errSecPublicKeyInconsistent", (Object)"The public key was inconsistent.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67812, (Trinity<String, String, String>)new Trinity((Object)"errSecDeviceVerifyFailed", (Object)"A device verification failure has occurred.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67813, (Trinity<String, String, String>)new Trinity((Object)"errSecInvalidLoginName", (Object)"An invalid login name was detected.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67814, (Trinity<String, String, String>)new Trinity((Object)"errSecAlreadyLoggedIn", (Object)"The user is already logged in.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67815, (Trinity<String, String, String>)new Trinity((Object)"errSecInvalidDigestAlgorithm", (Object)"An invalid digest algorithm was detected.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67816, (Trinity<String, String, String>)new Trinity((Object)"errSecInvalidCRLGroup", (Object)"An invalid CRL group was detected.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67817, (Trinity<String, String, String>)new Trinity((Object)"errSecCertificateCannotOperate", (Object)"The certificate cannot operate.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67818, (Trinity<String, String, String>)new Trinity((Object)"errSecCertificateExpired", (Object)"An expired certificate was detected.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67819, (Trinity<String, String, String>)new Trinity((Object)"errSecCertificateNotValidYet", (Object)"The certificate is not yet valid.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67820, (Trinity<String, String, String>)new Trinity((Object)"errSecCertificateRevoked", (Object)"The certificate was revoked.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67821, (Trinity<String, String, String>)new Trinity((Object)"errSecCertificateSuspended", (Object)"The certificate was suspended.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67822, (Trinity<String, String, String>)new Trinity((Object)"errSecInsufficientCredentials", (Object)"Insufficient credentials were detected.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67823, (Trinity<String, String, String>)new Trinity((Object)"errSecInvalidAction", (Object)"The action was not valid.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67824, (Trinity<String, String, String>)new Trinity((Object)"errSecInvalidAuthority", (Object)"The authority was not valid.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67825, (Trinity<String, String, String>)new Trinity((Object)"errSecVerifyActionFailed", (Object)"A verify action has failed.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67826, (Trinity<String, String, String>)new Trinity((Object)"errSecInvalidCertAuthority", (Object)"The certificate authority was not valid.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67827, (Trinity<String, String, String>)new Trinity((Object)"errSecInvaldCRLAuthority", (Object)"The CRL authority was not valid.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67828, (Trinity<String, String, String>)new Trinity((Object)"errSecInvalidCRLEncoding", (Object)"The CRL encoding was not valid.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67829, (Trinity<String, String, String>)new Trinity((Object)"errSecInvalidCRLType", (Object)"The CRL type was not valid.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67830, (Trinity<String, String, String>)new Trinity((Object)"errSecInvalidCRL", (Object)"The CRL was not valid.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67831, (Trinity<String, String, String>)new Trinity((Object)"errSecInvalidFormType", (Object)"The form type was not valid.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67832, (Trinity<String, String, String>)new Trinity((Object)"errSecInvalidID", (Object)"The ID was not valid.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67833, (Trinity<String, String, String>)new Trinity((Object)"errSecInvalidIdentifier", (Object)"The identifier was not valid.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67834, (Trinity<String, String, String>)new Trinity((Object)"errSecInvalidIndex", (Object)"The index was not valid.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67835, (Trinity<String, String, String>)new Trinity((Object)"errSecInvalidPolicyIdentifiers", (Object)"The policy identifiers are not valid.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67836, (Trinity<String, String, String>)new Trinity((Object)"errSecInvalidTimeString", (Object)"The time specified was not valid.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67837, (Trinity<String, String, String>)new Trinity((Object)"errSecInvalidReason", (Object)"The trust policy reason was not valid.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67838, (Trinity<String, String, String>)new Trinity((Object)"errSecInvalidRequestInputs", (Object)"The request inputs are not valid.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67839, (Trinity<String, String, String>)new Trinity((Object)"errSecInvalidResponseVector", (Object)"The response vector was not valid.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67840, (Trinity<String, String, String>)new Trinity((Object)"errSecInvalidStopOnPolicy", (Object)"The stop-on policy was not valid.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67841, (Trinity<String, String, String>)new Trinity((Object)"errSecInvalidTuple", (Object)"The tuple was not valid.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67842, (Trinity<String, String, String>)new Trinity((Object)"errSecMultipleValuesUnsupported", (Object)"Multiple values are not supported.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67843, (Trinity<String, String, String>)new Trinity((Object)"errSecNotTrusted", (Object)"The trust policy was not trusted.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67844, (Trinity<String, String, String>)new Trinity((Object)"errSecNoDefaultAuthority", (Object)"No default authority was detected.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67845, (Trinity<String, String, String>)new Trinity((Object)"errSecRejectedForm", (Object)"The trust policy had a rejected form.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67846, (Trinity<String, String, String>)new Trinity((Object)"errSecRequestLost", (Object)"The request was lost.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67847, (Trinity<String, String, String>)new Trinity((Object)"errSecRequestRejected", (Object)"The request was rejected.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67848, (Trinity<String, String, String>)new Trinity((Object)"errSecUnsupportedAddressType", (Object)"The address type is not supported.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67849, (Trinity<String, String, String>)new Trinity((Object)"errSecUnsupportedService", (Object)"The service is not supported.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67850, (Trinity<String, String, String>)new Trinity((Object)"errSecInvalidTupleGroup", (Object)"The tuple group was not valid.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67851, (Trinity<String, String, String>)new Trinity((Object)"errSecInvalidBaseACLs", (Object)"The base ACLs are not valid.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67852, (Trinity<String, String, String>)new Trinity((Object)"errSecInvalidTupleCredendtials", (Object)"The tuple credentials are not valid.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67853, (Trinity<String, String, String>)new Trinity((Object)"errSecInvalidEncoding", (Object)"The encoding was not valid.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67854, (Trinity<String, String, String>)new Trinity((Object)"errSecInvalidValidityPeriod", (Object)"The validity period was not valid.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67855, (Trinity<String, String, String>)new Trinity((Object)"errSecInvalidRequestor", (Object)"The requestor was not valid.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67856, (Trinity<String, String, String>)new Trinity((Object)"errSecRequestDescriptor", (Object)"The request descriptor was not valid.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67857, (Trinity<String, String, String>)new Trinity((Object)"errSecInvalidBundleInfo", (Object)"The bundle information was not valid.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67858, (Trinity<String, String, String>)new Trinity((Object)"errSecInvalidCRLIndex", (Object)"The CRL index was not valid.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67859, (Trinity<String, String, String>)new Trinity((Object)"errSecNoFieldValues", (Object)"No field values were detected.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67860, (Trinity<String, String, String>)new Trinity((Object)"errSecUnsupportedFieldFormat", (Object)"The field format is not supported.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67861, (Trinity<String, String, String>)new Trinity((Object)"errSecUnsupportedIndexInfo", (Object)"The index information is not supported.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67862, (Trinity<String, String, String>)new Trinity((Object)"errSecUnsupportedLocality", (Object)"The locality is not supported.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67863, (Trinity<String, String, String>)new Trinity((Object)"errSecUnsupportedNumAttributes", (Object)"The number of attributes is not supported.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67864, (Trinity<String, String, String>)new Trinity((Object)"errSecUnsupportedNumIndexes", (Object)"The number of indexes is not supported.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67865, (Trinity<String, String, String>)new Trinity((Object)"errSecUnsupportedNumRecordTypes", (Object)"The number of record types is not supported.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67866, (Trinity<String, String, String>)new Trinity((Object)"errSecFieldSpecifiedMultiple", (Object)"Too many fields were specified.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67867, (Trinity<String, String, String>)new Trinity((Object)"errSecIncompatibleFieldFormat", (Object)"The field format was incompatible.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67868, (Trinity<String, String, String>)new Trinity((Object)"errSecInvalidParsingModule", (Object)"The parsing module was not valid.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67869, (Trinity<String, String, String>)new Trinity((Object)"errSecDatabaseLocked", (Object)"The database is locked.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67870, (Trinity<String, String, String>)new Trinity((Object)"errSecDatastoreIsOpen", (Object)"The data store is open.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67871, (Trinity<String, String, String>)new Trinity((Object)"errSecMissingValue", (Object)"A missing value was detected.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67872, (Trinity<String, String, String>)new Trinity((Object)"errSecUnsupportedQueryLimits", (Object)"The query limits are not supported.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67873, (Trinity<String, String, String>)new Trinity((Object)"errSecUnsupportedNumSelectionPreds", (Object)"The number of selection predicates is not supported.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67874, (Trinity<String, String, String>)new Trinity((Object)"errSecUnsupportedOperator", (Object)"The operator is not supported.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67875, (Trinity<String, String, String>)new Trinity((Object)"errSecInvalidDBLocation", (Object)"The database location is not valid.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67876, (Trinity<String, String, String>)new Trinity((Object)"errSecInvalidAccessRequest", (Object)"The access request is not valid.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67877, (Trinity<String, String, String>)new Trinity((Object)"errSecInvalidIndexInfo", (Object)"The index information is not valid.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67878, (Trinity<String, String, String>)new Trinity((Object)"errSecInvalidNewOwner", (Object)"The new owner is not valid.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67879, (Trinity<String, String, String>)new Trinity((Object)"errSecInvalidModifyMode", (Object)"The modify mode is not valid.", (Object)"Available in OS X v10.7 and later."));
            macMessages.put(-67880, (Trinity<String, String, String>)new Trinity((Object)"errSecMissingRequiredExtension", (Object)"A required certificate extension is missing.", (Object)"Available in OS X v10.8 and later."));
            macMessages.put(-67881, (Trinity<String, String, String>)new Trinity((Object)"errSecExtendedKeyUsageNotCritical", (Object)"The extended key usage extension was not marked critical.", (Object)"Available in OS X v10.8 and later."));
            macMessages.put(-67882, (Trinity<String, String, String>)new Trinity((Object)"errSecTimestampMissing", (Object)"A timestamp was expected but was not found.", (Object)"Available in OS X v10.8 and later."));
            macMessages.put(-67883, (Trinity<String, String, String>)new Trinity((Object)"errSecTimestampInvalid", (Object)"The timestamp was not valid.", (Object)"Available in OS X v10.8 and later."));
            macMessages.put(-67884, (Trinity<String, String, String>)new Trinity((Object)"errSecTimestampNotTrusted", (Object)"The timestamp was not trusted.", (Object)"Available in OS X v10.8 and later."));
            macMessages.put(-67885, (Trinity<String, String, String>)new Trinity((Object)"errSecTimestampServiceNotAvailable", (Object)"The timestamp service is not available.", (Object)"Available in OS X v10.8 and later."));
            macMessages.put(-67886, (Trinity<String, String, String>)new Trinity((Object)"errSecTimestampBadAlg", (Object)"Found an unrecognized or unsupported algorithm identifier (AI) in timestamp.", (Object)"Available in OS X v10.8 and later."));
            macMessages.put(-67887, (Trinity<String, String, String>)new Trinity((Object)"errSecTimestampBadRequest", (Object)"The timestamp transaction is not permitted or supported.", (Object)"Available in OS X v10.8 and later."));
            macMessages.put(-67888, (Trinity<String, String, String>)new Trinity((Object)"errSecTimestampBadDataFormat", (Object)"The timestamp data submitted has the wrong format.", (Object)"Available in OS X v10.8 and later."));
            macMessages.put(-67889, (Trinity<String, String, String>)new Trinity((Object)"errSecTimestampTimeNotAvailable", (Object)"The time source for the timestamp authority is not available.", (Object)"Available in OS X v10.8 and later."));
            macMessages.put(-67890, (Trinity<String, String, String>)new Trinity((Object)"errSecTimestampUnacceptedPolicy", (Object)"The requested policy is not supported by the timestamp authority.", (Object)"Available in OS X v10.8 and later."));
            macMessages.put(-67891, (Trinity<String, String, String>)new Trinity((Object)"errSecTimestampUnacceptedExtension", (Object)"The requested extension is not supported by the timestamp authority.", (Object)"Available in OS X v10.8 and later."));
            macMessages.put(-67892, (Trinity<String, String, String>)new Trinity((Object)"errSecTimestampAddInfoNotAvailable", (Object)"The additional information requested is not available.", (Object)"Available in OS X v10.8 and later."));
            macMessages.put(-67893, (Trinity<String, String, String>)new Trinity((Object)"errSecTimestampSystemFailure", (Object)"The timestamp request cannot be handled due to a system failure .", (Object)"Available in OS X v10.8 and later."));
            macMessages.put(-67894, (Trinity<String, String, String>)new Trinity((Object)"errSecSigningTimeMissing", (Object)"A signing time was expected but was not found.", (Object)"Available in OS X v10.8 and later."));
            macMessages.put(-67895, (Trinity<String, String, String>)new Trinity((Object)"errSecTimestampRejection", (Object)"A timestamp transaction was rejected.", (Object)"Available in OS X v10.8 and later."));
            macMessages.put(-67896, (Trinity<String, String, String>)new Trinity((Object)"errSecTimestampWaiting", (Object)"A timestamp transaction is waiting.", (Object)"Available in OS X v10.8 and later."));
            macMessages.put(-67897, (Trinity<String, String, String>)new Trinity((Object)"errSecTimestampRevocationWarning", (Object)"A timestamp authority revocation warning was issued.", (Object)"Available in OS X v10.8 and later."));
            macMessages.put(-67898, (Trinity<String, String, String>)new Trinity((Object)"errSecTimestampRevocationNotification", (Object)"A timestamp authority revocation notification was issued.", (Object)"Available in OS X v10.8 and later."));
        }
    }

    private static class LinuxParser {
        private static final Map<Integer, Couple<String>> gnomeMessages = new HashMap<Integer, Couple<String>>();

        private LinuxParser() {
        }

        public static String translate(NativeLogReader.CallInfo callInfo) {
            if (!callInfo.getFunctionName().contains("ISVNGnomeKeyringLibrary")) {
                return null;
            }
            if (callInfo.getFunctionName().contains("gnome_keyring_is_available")) {
                if (callInfo.getStrResultCode().contains("false")) {
                    return MessageFormat.format(ourGenericAdvice, callInfo.getFunctionName(), callInfo.getStrResultCode() + " (You can't communicate with the daemon (so you can't load and save passwords)).");
                }
                return null;
            }
            if (!("" + callInfo.getResultCode()).equals(callInfo.getStrResultCode())) {
                return null;
            }
            if (callInfo.getResultCode() == 0) {
                return null;
            }
            Couple<String> pair = gnomeMessages.get(callInfo.getResultCode());
            if (pair == null) {
                return null;
            }
            return MessageFormat.format(ourGenericAdvice, callInfo.getFunctionName(), callInfo.getResultCode() + " ( " + (String)pair.getFirst() + " - " + (String)pair.getSecond() + ")");
        }

        static {
            gnomeMessages.put(0, (Couple<String>)Couple.of((Object)"GNOME_KEYRING_RESULT_OK", (Object)"The operation completed successfully."));
            gnomeMessages.put(1, (Couple<String>)Couple.of((Object)"GNOME_KEYRING_RESULT_DENIED", (Object)"Either the user or daemon denied access."));
            gnomeMessages.put(2, (Couple<String>)Couple.of((Object)"GNOME_KEYRING_RESULT_NO_KEYRING_DAEMON", (Object)"Keyring daemon is not available."));
            gnomeMessages.put(3, (Couple<String>)Couple.of((Object)"GNOME_KEYRING_RESULT_ALREADY_UNLOCKED", (Object)"Keyring was already unlocked."));
            gnomeMessages.put(4, (Couple<String>)Couple.of((Object)"GNOME_KEYRING_RESULT_NO_SUCH_KEYRING", (Object)"No such keyring exists."));
            gnomeMessages.put(5, (Couple<String>)Couple.of((Object)"GNOME_KEYRING_RESULT_BAD_ARGUMENTS", (Object)"Bad arguments to function."));
            gnomeMessages.put(6, (Couple<String>)Couple.of((Object)"GNOME_KEYRING_RESULT_IO_ERROR", (Object)"Problem communicating with daemon."));
            gnomeMessages.put(7, (Couple<String>)Couple.of((Object)"GNOME_KEYRING_RESULT_CANCELLED", (Object)"Operation was cancelled."));
            gnomeMessages.put(8, (Couple<String>)Couple.of((Object)"GNOME_KEYRING_RESULT_KEYRING_ALREADY_EXISTS", (Object)"The keyring already exists."));
            gnomeMessages.put(9, (Couple<String>)Couple.of((Object)"GNOME_KEYRING_RESULT_NO_MATCH", (Object)"No such match found."));
        }
    }

    private static class WindowsParser {
        private WindowsParser() {
        }

        public static String translate(NativeLogReader.CallInfo callInfo) {
            if (callInfo.getFunctionName().contains("ISVNSecurityLibrary")) {
                if (!("" + callInfo.getResultCode()).equals(callInfo.getStrResultCode())) {
                    return null;
                }
                if (callInfo.getResultCode() == 0) {
                    return null;
                }
                return SvnNativeCallsTranslator.defaultMessage(callInfo);
            }
            if (callInfo.getFunctionName().contains("ISVNWinCryptLibrary") && callInfo.getStrResultCode().contains("false")) {
                return SvnNativeCallsTranslator.defaultMessageStr(callInfo);
            }
            return null;
        }
    }
}

