/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.branchConfig;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.idea.svn.branchConfig.SvnBranchConfigurationNew;

@State(name="SvnBranchMapperManager", storages={@Storage(value="other.xml")})
public class SvnBranchMapperManager
implements PersistentStateComponent<SvnBranchMapperHolder> {
    private SvnBranchMapperHolder myStateHolder = new SvnBranchMapperHolder();

    public static SvnBranchMapperManager getInstance() {
        return (SvnBranchMapperManager)ServiceManager.getService(SvnBranchMapperManager.class);
    }

    public SvnBranchMapperHolder getState() {
        return this.myStateHolder;
    }

    public void loadState(SvnBranchMapperHolder state) {
        this.myStateHolder = state;
    }

    public void put(String url, String value) {
        this.myStateHolder.put(url, value);
    }

    public void remove(String url, File value) {
        Set<String> set = this.myStateHolder.get(url);
        if (set != null) {
            set.remove(value.getAbsolutePath());
        }
    }

    public void notifyBranchesChanged(Project project, VirtualFile vcsRoot, SvnBranchConfigurationNew configuration) {
        Map<String, String> map = configuration.getUrl2FileMappings(project, vcsRoot);
        if (map != null) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
        }
    }

    public Set<String> get(String key) {
        return this.myStateHolder.get(key);
    }

    public static class SvnBranchMapperHolder {
        public Map<String, Set<String>> myMapping = new HashMap<String, Set<String>>();

        public void put(String key, String value) {
            Set<String> files = this.myMapping.get(key);
            if (files == null) {
                files = new HashSet<String>();
                this.myMapping.put(key, files);
            }
            files.add(value);
        }

        public Set<String> get(String key) {
            return this.myMapping.get(key);
        }
    }
}

