/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.ui.ScrollPaneFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.jetbrains.idea.svn.dialogs.PageEngine;

public class PagedListWithActions<T> {
    private final JPanel myPanel;
    private final PageEngine<List<T>> myEngine;
    private final InnerComponentManager<T> myComponentManager;
    private final AnAction[] myOtherActions;

    public PagedListWithActions(PageEngine<List<T>> engine, InnerComponentManager<T> componentManager, AnAction ... otherActions) {
        this.myEngine = engine;
        this.myComponentManager = componentManager;
        this.myOtherActions = otherActions;
        this.myPanel = new JPanel(new BorderLayout());
        this.createView();
    }

    private void createView() {
        this.myComponentManager.setData(this.myEngine.getCurrent());
        this.myPanel.add((Component)ActionManager.getInstance().createActionToolbar("merge all", this.createListActions(), true).getComponent(), "North");
        JScrollPane scroll = ScrollPaneFactory.createScrollPane((Component)this.myComponentManager.getComponent(), (int)20, (int)31);
        this.myPanel.add((Component)scroll, "Center");
    }

    public JComponent getComponent() {
        return this.myPanel;
    }

    private ActionGroup createListActions() {
        DefaultActionGroup group = new DefaultActionGroup();
        group.add((AnAction)new MyPrevious());
        group.add((AnAction)new MyNext());
        group.addAll(this.myOtherActions);
        return group;
    }

    public static interface InnerComponentManager<T> {
        public Component getComponent();

        public void setData(List<T> var1);

        public void refresh();
    }

    private class MyPrevious
    extends AnAction {
        private MyPrevious() {
            super("Previous Page", "Previous Page", AllIcons.Actions.Prevfile);
        }

        public void actionPerformed(AnActionEvent e) {
            List data = (List)PagedListWithActions.this.myEngine.previous();
            PagedListWithActions.this.myComponentManager.setData(data);
            PagedListWithActions.this.myComponentManager.refresh();
        }

        public void update(AnActionEvent e) {
            super.update(e);
            e.getPresentation().setEnabled(PagedListWithActions.this.myEngine.hasPrevious());
            e.getPresentation().setVisible(PagedListWithActions.this.myEngine.hasPrevious());
        }
    }

    private class MyNext
    extends AnAction {
        private MyNext() {
            super("Next Page", "Next Page", AllIcons.Actions.Nextfile);
        }

        public void actionPerformed(AnActionEvent e) {
            List data = (List)PagedListWithActions.this.myEngine.next();
            PagedListWithActions.this.myComponentManager.setData(data);
            PagedListWithActions.this.myComponentManager.refresh();
        }

        public void update(AnActionEvent e) {
            super.update(e);
            e.getPresentation().setEnabled(PagedListWithActions.this.myEngine.hasNext());
            e.getPresentation().setVisible(PagedListWithActions.this.myEngine.hasNext());
        }
    }
}

