/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.integrate;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.TransparentlyFailedValue;
import com.intellij.openapi.vcs.changes.TransparentlyFailedValueI;
import com.intellij.openapi.vcs.persistent.SmallMapSerializer;
import com.intellij.util.Consumer;
import com.intellij.util.ThrowableConvertor;
import com.intellij.util.ValueHolder;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.continuation.TaskDescriptor;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.dialogs.FactsCalculator;
import org.jetbrains.idea.svn.history.CopyData;
import org.jetbrains.idea.svn.history.FirstInBranch;

public class SvnBranchPointsCalculator {
    private static final Logger LOG = Logger.getInstance(SvnBranchPointsCalculator.class);
    private FactsCalculator<KeyData, WrapperInvertor, VcsException> myCalculator;
    private PersistentHolder myPersistentHolder;
    private File myFile;
    private final Project myProject;

    public SvnBranchPointsCalculator(Project project) {
        this.myProject = project;
        File vcs = new File(PathManager.getSystemPath(), "vcs");
        File file = new File(vcs, "svn_copy_sources");
        file.mkdirs();
        this.myFile = file;
        this.myFile = new File(file, project.getLocationHash());
    }

    public void activate() {
        ValueHolder<WrapperInvertor, KeyData> cache = null;
        this.myPersistentHolder = new PersistentHolder(this.myFile);
        cache = new ValueHolder<WrapperInvertor, KeyData>(){

            public WrapperInvertor getValue(KeyData dataHolder) {
                WrapperInvertor result = SvnBranchPointsCalculator.this.myPersistentHolder.getBestHit(dataHolder.getRepoUrl(), dataHolder.getSourceUrl(), dataHolder.getTargetUrl());
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Persistent for: " + dataHolder.toString() + " returned: " + (result == null ? null : result.toString()));
                }
                return result;
            }

            public void setValue(WrapperInvertor value, KeyData dataHolder) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Put into persistent: key: " + dataHolder.toString() + " value: " + value.toString());
                }
                SvnBranchPointsCalculator.this.myPersistentHolder.put(dataHolder.getRepoUrl(), value.getWrapped().getTarget(), value.getWrapped());
            }
        };
        this.myCalculator = new FactsCalculator<KeyData, WrapperInvertor, VcsException>(this.myProject, "Looking for branch origin", cache, new Loader(this.myProject));
    }

    public void deactivate() {
        this.myPersistentHolder.close();
        this.myCalculator = null;
        this.myPersistentHolder = null;
    }

    public TaskDescriptor getFirstCopyPointTask(String repoUID, String sourceUrl, String targetUrl, Consumer<TransparentlyFailedValueI<WrapperInvertor, VcsException>> consumer) {
        return this.myCalculator.getTask(new KeyData(repoUID, sourceUrl, targetUrl), consumer, VcsException.class);
    }

    public static class BranchCopyData {
        private final String mySource;
        private final String myTarget;
        private final long mySourceRevision;
        private final long myTargetRevision;

        public BranchCopyData(String source, long sourceRevision, String target, long targetRevision) {
            this.mySource = source;
            this.mySourceRevision = sourceRevision;
            this.myTarget = target;
            this.myTargetRevision = targetRevision;
        }

        public String toString() {
            return "source: " + this.mySource + "@" + this.mySourceRevision + " target: " + this.myTarget + "@" + this.myTargetRevision;
        }

        public String getSource() {
            return this.mySource;
        }

        public long getSourceRevision() {
            return this.mySourceRevision;
        }

        public String getTarget() {
            return this.myTarget;
        }

        public long getTargetRevision() {
            return this.myTargetRevision;
        }

        public BranchCopyData invertSelf() {
            return new BranchCopyData(this.myTarget, this.myTargetRevision, this.mySource, this.mySourceRevision);
        }
    }

    private static class KeyData {
        private final String myRepoUrl;
        private final String mySourceUrl;
        private final String myTargetUrl;

        public KeyData(String repoUID, String sourceUrl, String targetUrl) {
            this.myRepoUrl = repoUID;
            this.mySourceUrl = sourceUrl;
            this.myTargetUrl = targetUrl;
        }

        public String getRepoUrl() {
            return this.myRepoUrl;
        }

        public String getSourceUrl() {
            return this.mySourceUrl;
        }

        public String getTargetUrl() {
            return this.myTargetUrl;
        }

        public String toString() {
            return "repoURL: " + this.myRepoUrl + " sourceUrl:" + this.mySourceUrl + " targetUrl: " + this.myTargetUrl;
        }
    }

    private static class Loader
    implements ThrowableConvertor<KeyData, WrapperInvertor, VcsException> {
        private SvnVcs myVcs;

        private Loader(Project project) {
            this.myVcs = SvnVcs.getInstance(project);
        }

        public WrapperInvertor convert(KeyData keyData) throws VcsException {
            TransparentlyFailedValue consumer = new TransparentlyFailedValue();
            new FirstInBranch(this.myVcs, keyData.getRepoUrl(), keyData.getTargetUrl(), keyData.getSourceUrl(), (TransparentlyFailedValueI<CopyData, VcsException>)consumer).run();
            CopyData copyData = (CopyData)consumer.get();
            if (copyData != null) {
                boolean correct = copyData.isTrunkSupposedCorrect();
                BranchCopyData branchCopyData = correct ? new BranchCopyData(keyData.getSourceUrl(), copyData.getCopySourceRevision(), keyData.getTargetUrl(), copyData.getCopyTargetRevision()) : new BranchCopyData(keyData.getTargetUrl(), copyData.getCopySourceRevision(), keyData.getSourceUrl(), copyData.getCopyTargetRevision());
                WrapperInvertor invertor = new WrapperInvertor(!correct, branchCopyData);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Loader17 returned: for key: " + keyData.toString() + " result: " + invertor.toString());
                }
                return invertor;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Loader17 returned: for key: " + keyData.toString() + " result: null");
            }
            return null;
        }
    }

    private static class PersistentHolder {
        private final SmallMapSerializer<String, TreeMap<String, BranchCopyData>> myPersistentMap;
        private final MultiMap<String, String> myForSearchMap;
        private final Object myLock = new Object();

        PersistentHolder(File file) {
            this.myPersistentMap = new SmallMapSerializer(file, (KeyDescriptor)new EnumeratorStringDescriptor(), (DataExternalizer)new BranchDataExternalizer());
            this.myForSearchMap = new MultiMap();
            for (String s : this.myPersistentMap.keySet()) {
                TreeMap map = (TreeMap)this.myPersistentMap.get((Object)s);
                if (map == null) continue;
                this.myForSearchMap.put((Object)s, new ArrayList(map.keySet()));
            }
            for (String key : this.myForSearchMap.keySet()) {
                Collections.sort((List)this.myForSearchMap.get((Object)key));
            }
        }

        public void close() {
            this.myPersistentMap.force();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void put(String uid, String target, BranchCopyData data) {
            Object object = this.myLock;
            synchronized (object) {
                TreeMap<String, BranchCopyData> map = (TreeMap<String, BranchCopyData>)this.myPersistentMap.get((Object)uid);
                if (map == null) {
                    map = new TreeMap<String, BranchCopyData>();
                }
                map.put(target, data);
                this.myPersistentMap.put((Object)uid, map);
                if (this.myForSearchMap.containsKey((Object)uid)) {
                    List list = (List)this.myForSearchMap.get((Object)uid);
                    int idx = Collections.binarySearch(list, target);
                    if (idx < 0) {
                        int insertionIdx = -idx - 1;
                        list.add(insertionIdx, target);
                    }
                } else {
                    this.myForSearchMap.putValue((Object)uid, (Object)target);
                }
            }
            this.myPersistentMap.force();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public WrapperInvertor getBestHit(String repoUrl, String source, String target) {
            List keys;
            Object object = this.myLock;
            synchronized (object) {
                keys = (List)this.myForSearchMap.get((Object)repoUrl);
            }
            String sourceMatching = this.getMatchingUrl(keys, source);
            String targetMatching = this.getMatchingUrl(keys, target);
            if (sourceMatching == null && targetMatching == null) {
                return null;
            }
            Object object2 = this.myLock;
            synchronized (object2) {
                boolean sourceIsOut;
                TreeMap map = (TreeMap)this.myPersistentMap.get((Object)repoUrl);
                boolean bl = sourceIsOut = sourceMatching == null;
                if (sourceIsOut || targetMatching == null) {
                    return sourceIsOut ? new WrapperInvertor(false, (BranchCopyData)map.get(targetMatching)) : new WrapperInvertor(true, (BranchCopyData)map.get(sourceMatching));
                }
                BranchCopyData sourceData = (BranchCopyData)map.get(sourceMatching);
                BranchCopyData targetData = (BranchCopyData)map.get(targetMatching);
                boolean inverted = sourceData.getTargetRevision() > targetData.getTargetRevision();
                return new WrapperInvertor(inverted, inverted ? sourceData : targetData);
            }
        }

        @Nullable
        private String getMatchingUrl(List<String> keys, String source) {
            int idx = Collections.binarySearch(keys, source);
            if (idx >= 0) {
                return keys.get(idx);
            }
            int beforeInsertionIdx = -idx - 2;
            if (beforeInsertionIdx < 0) {
                return null;
            }
            String candidate = keys.get(beforeInsertionIdx);
            if (source.startsWith(candidate)) {
                return candidate;
            }
            return null;
        }
    }

    public static class WrapperInvertor {
        private final BranchCopyData myWrapped;
        private final boolean myInvertedSense;

        public WrapperInvertor(boolean invertedSense, BranchCopyData wrapped) {
            this.myInvertedSense = invertedSense;
            this.myWrapped = wrapped;
        }

        public boolean isInvertedSense() {
            return this.myInvertedSense;
        }

        public BranchCopyData getWrapped() {
            return this.myWrapped;
        }

        public BranchCopyData getTrue() {
            return this.myInvertedSense ? this.myWrapped.invertSelf() : this.myWrapped;
        }

        public BranchCopyData inverted() {
            return this.myWrapped.invertSelf();
        }

        public String toString() {
            return "inverted: " + this.myInvertedSense + " wrapped: " + this.myWrapped.toString();
        }
    }

    private static class BranchDataExternalizer
    implements DataExternalizer<TreeMap<String, BranchCopyData>> {
        private BranchDataExternalizer() {
        }

        public void save(@NotNull DataOutput out, TreeMap<String, BranchCopyData> value) throws IOException {
            if (out == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "org/jetbrains/idea/svn/integrate/SvnBranchPointsCalculator$BranchDataExternalizer", "save"));
            }
            out.writeInt(value.size());
            for (Map.Entry<String, BranchCopyData> entry : value.entrySet()) {
                out.writeUTF(entry.getKey());
                BranchCopyData entryValue = entry.getValue();
                out.writeUTF(entryValue.getSource());
                out.writeUTF(entryValue.getTarget());
                out.writeLong(entryValue.getSourceRevision());
                out.writeLong(entryValue.getTargetRevision());
            }
        }

        public TreeMap<String, BranchCopyData> read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "org/jetbrains/idea/svn/integrate/SvnBranchPointsCalculator$BranchDataExternalizer", "read"));
            }
            TreeMap<String, BranchCopyData> result = new TreeMap<String, BranchCopyData>();
            int num = in.readInt();
            for (int i = 0; i < num; ++i) {
                String key = in.readUTF();
                String source = in.readUTF();
                String target = in.readUTF();
                long sourceRevision = in.readLong();
                long targetRevision = in.readLong();
                result.put(key, new BranchCopyData(source, sourceRevision, target, targetRevision));
            }
            return result;
        }
    }
}

