/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.cmdline;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ParameterizedRunnable;
import java.io.IOException;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.cmdline.JpsModelLoader;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.serialization.JpsSerializationManager;

public class JpsModelLoaderImpl
implements JpsModelLoader {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.jps.cmdline.JpsModelLoaderImpl");
    private final String myProjectPath;
    private final String myGlobalOptionsPath;
    private final ParameterizedRunnable<JpsModel> myModelInitializer;

    public JpsModelLoaderImpl(String projectPath, String globalOptionsPath, @Nullable ParameterizedRunnable<JpsModel> initializer) {
        this.myProjectPath = projectPath;
        this.myGlobalOptionsPath = globalOptionsPath;
        this.myModelInitializer = initializer;
    }

    @Override
    public JpsModel loadModel() throws IOException {
        long start = System.currentTimeMillis();
        LOG.info("Loading model: project path = " + this.myProjectPath + ", global options path = " + this.myGlobalOptionsPath);
        JpsModel model = JpsSerializationManager.getInstance().loadModel(this.myProjectPath, this.myGlobalOptionsPath);
        if (this.myModelInitializer != null) {
            this.myModelInitializer.run((Object)model);
        }
        long loadTime = System.currentTimeMillis() - start;
        LOG.info("Model loaded in " + loadTime + " ms");
        LOG.info("Project has " + model.getProject().getModules().size() + " modules, " + model.getProject().getLibraryCollection().getLibraries().size() + " libraries");
        return model;
    }
}

