/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.asJava;

import com.intellij.lang.Language;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.ItemPresentationProviders;
import com.intellij.navigation.NavigationItem;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.PsiClassImplUtil;
import com.intellij.psi.impl.light.AbstractLightClass;
import com.intellij.psi.impl.source.ClassInnerStuffCache;
import com.intellij.psi.impl.source.PsiExtensibleClass;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.ClsWrapperStubPsiFactory;
import org.jetbrains.kotlin.asJava.KtLightClass;
import org.jetbrains.kotlin.asJava.KtLightFieldImpl;
import org.jetbrains.kotlin.asJava.KtLightMethodImpl;
import org.jetbrains.kotlin.asJava.LightMemberOrigin;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;

public abstract class KtWrappingLightClass
extends AbstractLightClass
implements KtLightClass,
PsiExtensibleClass {
    private final ClassInnerStuffCache myInnersCache = new ClassInnerStuffCache((PsiExtensibleClass)this);

    protected KtWrappingLightClass(PsiManager manager) {
        super(manager, (Language)KotlinLanguage.INSTANCE);
    }

    @Override
    @Nullable
    public abstract KtClassOrObject getOrigin();

    @Override
    @NotNull
    public abstract PsiClass getDelegate();

    @NotNull
    public PsiField[] getFields() {
        PsiField[] psiFieldArray = this.myInnersCache.getFields();
        if (psiFieldArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/KtWrappingLightClass", "getFields"));
        }
        return psiFieldArray;
    }

    @NotNull
    public PsiMethod[] getMethods() {
        PsiMethod[] psiMethodArray = this.myInnersCache.getMethods();
        if (psiMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/KtWrappingLightClass", "getMethods"));
        }
        return psiMethodArray;
    }

    @NotNull
    public PsiMethod[] getConstructors() {
        PsiMethod[] psiMethodArray = this.myInnersCache.getConstructors();
        if (psiMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/KtWrappingLightClass", "getConstructors"));
        }
        return psiMethodArray;
    }

    @NotNull
    public PsiClass[] getInnerClasses() {
        PsiClass[] psiClassArray = this.myInnersCache.getInnerClasses();
        if (psiClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/KtWrappingLightClass", "getInnerClasses"));
        }
        return psiClassArray;
    }

    @NotNull
    public PsiField[] getAllFields() {
        PsiField[] psiFieldArray = PsiClassImplUtil.getAllFields((PsiClass)this);
        if (psiFieldArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/KtWrappingLightClass", "getAllFields"));
        }
        return psiFieldArray;
    }

    @NotNull
    public PsiMethod[] getAllMethods() {
        PsiMethod[] psiMethodArray = PsiClassImplUtil.getAllMethods((PsiClass)this);
        if (psiMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/KtWrappingLightClass", "getAllMethods"));
        }
        return psiMethodArray;
    }

    @NotNull
    public PsiClass[] getAllInnerClasses() {
        PsiClass[] psiClassArray = PsiClassImplUtil.getAllInnerClasses((PsiClass)this);
        if (psiClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/KtWrappingLightClass", "getAllInnerClasses"));
        }
        return psiClassArray;
    }

    public PsiField findFieldByName(String name2, boolean checkBases) {
        return this.myInnersCache.findFieldByName(name2, checkBases);
    }

    @NotNull
    public PsiMethod[] findMethodsByName(String name2, boolean checkBases) {
        PsiMethod[] psiMethodArray = this.myInnersCache.findMethodsByName(name2, checkBases);
        if (psiMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/KtWrappingLightClass", "findMethodsByName"));
        }
        return psiMethodArray;
    }

    public PsiClass findInnerClassByName(String name2, boolean checkBases) {
        return this.myInnersCache.findInnerClassByName(name2, checkBases);
    }

    @NotNull
    public List<PsiField> getOwnFields() {
        List list2 = ContainerUtil.map((Object[])this.getDelegate().getFields(), (Function)new Function<PsiField, PsiField>(){

            public PsiField fun(PsiField field2) {
                LightMemberOrigin origin = ClsWrapperStubPsiFactory.getMemberOrigin((PsiMember)field2);
                return KtLightFieldImpl.Factory.create(origin != null ? origin.getOriginalElement() : null, field2, KtWrappingLightClass.this);
            }
        });
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/KtWrappingLightClass", "getOwnFields"));
        }
        return list2;
    }

    @NotNull
    public List<PsiMethod> getOwnMethods() {
        List list2 = ArraysKt.map((Object[])this.getDelegate().getMethods(), (Function1)new Function1<PsiMethod, PsiMethod>(){

            public PsiMethod invoke(PsiMethod method) {
                KtDeclaration originalElement;
                LightMemberOrigin origin = ClsWrapperStubPsiFactory.getMemberOrigin((PsiMember)method);
                KtDeclaration ktDeclaration = originalElement = origin != null ? origin.getOriginalElement() : null;
                if (originalElement instanceof KtPropertyAccessor) {
                    origin = origin.copy((KtDeclaration)PsiTreeUtil.getParentOfType((PsiElement)originalElement, KtProperty.class), origin.getOriginKind());
                }
                return KtLightMethodImpl.Factory.create(method, origin, KtWrappingLightClass.this);
            }
        });
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/KtWrappingLightClass", "getOwnMethods"));
        }
        return list2;
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor2, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/kotlin/asJava/KtWrappingLightClass", "processDeclarations"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/kotlin/asJava/KtWrappingLightClass", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "org/jetbrains/kotlin/asJava/KtWrappingLightClass", "processDeclarations"));
        }
        if (this.isEnum() && !PsiClassImplUtil.processDeclarationsInEnum((PsiScopeProcessor)processor2, (ResolveState)state, (ClassInnerStuffCache)this.myInnersCache)) {
            return false;
        }
        return super.processDeclarations(processor2, state, lastParent, place);
    }

    public String getText() {
        KtClassOrObject origin = this.getOrigin();
        return origin == null ? "" : origin.getText();
    }

    @NotNull
    public Language getLanguage() {
        KotlinLanguage kotlinLanguage = KotlinLanguage.INSTANCE;
        if (kotlinLanguage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/KtWrappingLightClass", "getLanguage"));
        }
        return kotlinLanguage;
    }

    public ItemPresentation getPresentation() {
        return ItemPresentationProviders.getItemPresentation((NavigationItem)this);
    }

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public PsiElement getContext() {
        return this.getParent();
    }
}

