/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.diagnostics.rendering;

import java.text.MessageFormat;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.rendering.DiagnosticRenderer;

public abstract class AbstractDiagnosticWithParametersRenderer<D extends Diagnostic>
implements DiagnosticRenderer<D> {
    @NotNull
    private final MessageFormat messageFormat;

    protected AbstractDiagnosticWithParametersRenderer(@NotNull String message2) {
        if (message2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/kotlin/diagnostics/rendering/AbstractDiagnosticWithParametersRenderer", "<init>"));
        }
        this.messageFormat = new MessageFormat(message2);
    }

    @Override
    @NotNull
    public String render(@NotNull D diagnostic) {
        if (diagnostic == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagnostic", "org/jetbrains/kotlin/diagnostics/rendering/AbstractDiagnosticWithParametersRenderer", "render"));
        }
        String string = this.messageFormat.format(this.renderParameters(diagnostic));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/diagnostics/rendering/AbstractDiagnosticWithParametersRenderer", "render"));
        }
        return string;
    }

    @NotNull
    public abstract Object[] renderParameters(@NotNull D var1);
}

