/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.render;

import com.intellij.debugger.DebuggerContext;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.ui.impl.watch.FieldDescriptorImpl;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiExpression;
import com.sun.jdi.Field;
import com.sun.jdi.Method;
import com.sun.jdi.Mirror;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Value;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.load.java.JvmAbi;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0014\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J\n\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002J\n\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J\u0014\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u0018H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/render/DelegatedPropertyFieldDescriptor;", "Lcom/intellij/debugger/ui/impl/watch/FieldDescriptorImpl;", "project", "Lcom/intellij/openapi/project/Project;", "objectRef", "Lcom/sun/jdi/ObjectReference;", "delegate", "Lcom/sun/jdi/Field;", "renderDelegatedProperty", "", "(Lcom/intellij/openapi/project/Project;Lcom/sun/jdi/ObjectReference;Lcom/sun/jdi/Field;Z)V", "getDelegate", "()Lcom/sun/jdi/Field;", "getObjectRef", "()Lcom/sun/jdi/ObjectReference;", "getRenderDelegatedProperty", "()Z", "calcValue", "Lcom/sun/jdi/Value;", "evaluationContext", "Lcom/intellij/debugger/engine/evaluation/EvaluationContextImpl;", "findGetterForDelegatedProperty", "Lcom/sun/jdi/Method;", "getDeclaredType", "", "getDescriptorEvaluation", "Lcom/intellij/psi/PsiExpression;", "context", "Lcom/intellij/debugger/DebuggerContext;", "getName", "idea"})
public final class DelegatedPropertyFieldDescriptor
extends FieldDescriptorImpl {
    @NotNull
    private final ObjectReference objectRef;
    @NotNull
    private final Field delegate;
    private final boolean renderDelegatedProperty;

    @Nullable
    public Value calcValue(@Nullable EvaluationContextImpl evaluationContext) {
        ThreadReference threadReference;
        if (evaluationContext == null) {
            return null;
        }
        if (!this.renderDelegatedProperty) {
            return super.calcValue(evaluationContext);
        }
        Method method = this.findGetterForDelegatedProperty();
        ThreadReferenceProxyImpl threadReferenceProxyImpl = evaluationContext.getSuspendContext().getThread();
        ThreadReference threadReference2 = threadReference = threadReferenceProxyImpl != null ? threadReferenceProxyImpl.getThreadReference() : null;
        if (method == null || threadReference == null) {
            return super.calcValue(evaluationContext);
        }
        try {
            Method method2 = method;
            ObjectReference objectReference = this.getObject();
            EvaluationContext evaluationContext2 = (EvaluationContext)evaluationContext;
            DebugProcessImpl debugProcessImpl = evaluationContext.getDebugProcess();
            List list2 = CollectionsKt.emptyList();
            return debugProcessImpl.invokeInstanceMethod(evaluationContext2, objectReference, method2, list2, evaluationContext.getSuspendContext().getSuspendPolicy());
        }
        catch (EvaluateException e) {
            return e.getExceptionFromTargetVM();
        }
    }

    @NotNull
    public String getName() {
        return StringsKt.removeSuffix((String)this.delegate.name(), (CharSequence)"$delegate");
    }

    @Nullable
    public PsiExpression getDescriptorEvaluation(@Nullable DebuggerContext context) {
        return null;
    }

    private final Method findGetterForDelegatedProperty() {
        String fieldName = this.getName();
        if (!Name.isValidIdentifier(fieldName)) {
            return null;
        }
        List<Method> list2 = this.getObject().referenceType().methodsByName(JvmAbi.getterName(fieldName));
        return list2 != null ? (Method)CollectionsKt.firstOrNull(list2) : null;
    }

    @Nullable
    public String getDeclaredType() {
        Mirror mirror = this.findGetterForDelegatedProperty();
        return mirror != null && (mirror = mirror.returnType()) != null ? mirror.name() : null;
    }

    @NotNull
    public final ObjectReference getObjectRef() {
        return this.objectRef;
    }

    @NotNull
    public final Field getDelegate() {
        return this.delegate;
    }

    public final boolean getRenderDelegatedProperty() {
        return this.renderDelegatedProperty;
    }

    public DelegatedPropertyFieldDescriptor(@NotNull Project project, @NotNull ObjectReference objectRef, @NotNull Field delegate2, boolean renderDelegatedProperty) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)objectRef, (String)"objectRef");
        Intrinsics.checkParameterIsNotNull((Object)delegate2, (String)"delegate");
        super(project, objectRef, delegate2);
        this.objectRef = objectRef;
        this.delegate = delegate2;
        this.renderDelegatedProperty = renderDelegatedProperty;
    }
}

