/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.idea.analysis.AnalyzerUtilKt;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.intentions.SelfTargetingRangeIntention;
import org.jetbrains.kotlin.idea.util.ScopeUtils;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtContainerNode;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSuperExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\u001a\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u00022\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\u0010\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u0002H\u0002\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/RemoveExplicitSuperQualifierIntention;", "Lorg/jetbrains/kotlin/idea/intentions/SelfTargetingRangeIntention;", "Lorg/jetbrains/kotlin/psi/KtSuperExpression;", "()V", "applicabilityRange", "Lcom/intellij/openapi/util/TextRange;", "element", "applyTo", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "toNonQualified", "superExpression", "idea"})
public final class RemoveExplicitSuperQualifierIntention
extends SelfTargetingRangeIntention<KtSuperExpression> {
    @Override
    @Nullable
    public TextRange applicabilityRange(@NotNull KtSuperExpression element2) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        if (element2.getSuperTypeQualifier() == null) {
            return null;
        }
        KtQualifiedExpression ktQualifiedExpression = KtPsiUtilKt.getQualifiedExpressionForReceiver(element2);
        if (ktQualifiedExpression == null) {
            return null;
        }
        KtQualifiedExpression qualifiedExpression = ktQualifiedExpression;
        KtExpression ktExpression = qualifiedExpression.getSelectorExpression();
        if (ktExpression == null) {
            return null;
        }
        KtExpression selector = ktExpression;
        BindingContext bindingContext2 = ResolutionUtils.analyze(selector, BodyResolveMode.PARTIAL);
        if (CallUtilKt.getResolvedCall(selector, bindingContext2) == null) {
            return null;
        }
        LexicalScope resolutionScope = ScopeUtils.getResolutionScope((PsiElement)qualifiedExpression, bindingContext2, ResolutionUtils.getResolutionFacade(selector));
        DataFlowInfo dataFlowInfo = BindingContextUtilsKt.getDataFlowInfo(bindingContext2, (PsiElement)element2);
        KotlinType kotlinType = (KotlinType)bindingContext2.get(BindingContext.EXPECTED_EXPRESSION_TYPE, qualifiedExpression);
        if (kotlinType == null) {
            kotlinType = TypeUtils.NO_EXPECTED_TYPE;
        }
        KotlinType expectedType = kotlinType;
        KtPsiFactory ktPsiFactory = KtPsiFactoryKt.KtPsiFactory((PsiElement)element2);
        Object[] objectArray = new Object[2];
        objectArray[0] = this.toNonQualified(element2);
        KtExpression ktExpression2 = selector;
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression2, (String)"selector");
        objectArray[1] = ktExpression2;
        KtExpression ktExpression3 = CreateByPatternKt.createExpressionByPattern(ktPsiFactory, "$0.$1", objectArray);
        if (ktExpression3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtQualifiedExpression");
        }
        KtQualifiedExpression newQualifiedExpression = (KtQualifiedExpression)ktExpression3;
        KtExpression ktExpression4 = newQualifiedExpression;
        KtExpression ktExpression5 = qualifiedExpression;
        KotlinType kotlinType2 = expectedType;
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType2, (String)"expectedType");
        BindingContext newBindingContext = AnalyzerUtilKt.analyzeInContext$default(ktExpression4, resolutionScope, ktExpression5, null, dataFlowInfo, kotlinType2, true, 4, null);
        ResolvedCall<? extends CallableDescriptor> resolvedCall = CallUtilKt.getResolvedCall(newQualifiedExpression.getSelectorExpression(), newBindingContext);
        if (resolvedCall == null) {
            return null;
        }
        ResolvedCall<? extends CallableDescriptor> newResolvedCall = resolvedCall;
        if (ErrorUtils.isError(newResolvedCall.getResultingDescriptor())) {
            return null;
        }
        KtContainerNode ktContainerNode = element2.getLabelQualifier();
        return new TextRange(PsiUtilsKt.getEndOffset((PsiElement)element2.getInstanceReference()), ktContainerNode != null ? PsiUtilsKt.getStartOffset((PsiElement)ktContainerNode) : PsiUtilsKt.getEndOffset((PsiElement)element2));
    }

    @Override
    public void applyTo(@NotNull KtSuperExpression element2, @Nullable Editor editor) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        element2.replace((PsiElement)this.toNonQualified(element2));
    }

    private final KtSuperExpression toNonQualified(KtSuperExpression superExpression) {
        KtPsiFactory factory2 = KtPsiFactoryKt.KtPsiFactory((PsiElement)superExpression);
        Name labelName = superExpression.getLabelNameAsName();
        KtExpression ktExpression = labelName != null ? CreateByPatternKt.createExpressionByPattern(factory2, "super@$0", labelName) : factory2.createExpression("super");
        if (ktExpression == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtSuperExpression");
        }
        return (KtSuperExpression)ktExpression;
    }

    public RemoveExplicitSuperQualifierIntention() {
        super(KtSuperExpression.class, "Remove explicit supertype qualification", null, 4, null);
    }
}

