/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.changeSignature;

import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.changeSignature.ChangeSignatureHandler;
import com.intellij.refactoring.changeSignature.ChangeSignatureProcessor;
import com.intellij.refactoring.changeSignature.ChangeSignatureUtil;
import com.intellij.refactoring.changeSignature.JavaChangeInfo;
import com.intellij.refactoring.changeSignature.JavaChangeInfoImpl;
import com.intellij.refactoring.changeSignature.JavaChangeSignatureDialog;
import com.intellij.refactoring.changeSignature.JavaMethodDescriptor;
import com.intellij.refactoring.changeSignature.ParameterInfoImpl;
import com.intellij.refactoring.changeSignature.ThrownExceptionInfo;
import com.intellij.refactoring.ui.RefactoringDialog;
import com.intellij.refactoring.util.CanonicalTypes;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.VisibilityUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.idea.codeInsight.DescriptorToSourceUtilsIde;
import org.jetbrains.kotlin.idea.refactoring.CallableRefactoring;
import org.jetbrains.kotlin.idea.refactoring.JetRefactoringUtilKt;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.KotlinAwareJavaParameterInfoImpl;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.KotlinChangeInfo;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.KotlinChangeSignatureConfiguration;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.KotlinChangeSignatureData;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.KotlinMethodDescriptor;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.KotlinParameterInfo;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.ui.KotlinChangePropertySignatureDialog;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.ui.KotlinChangeSignatureDialog;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B/\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\fJ\u0016\u0010\u0014\u001a\u0004\u0018\u00010\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00020\u0017J\b\u0010\u0018\u001a\u00020\u0019H\u0014J\u001c\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001d0\u001b2\u0006\u0010\u001e\u001a\u00020\u0015H\u0002J\u0016\u0010\u001f\u001a\u00020 2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00020\u0017H\u0014J\u0016\u0010\"\u001a\u00020\u00022\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00020\u0017H\u0002J\u0010\u0010#\u001a\u00020 2\u0006\u0010\u001e\u001a\u00020\u0015H\u0002J\u0010\u0010$\u001a\u00020 2\u0006\u0010\u001e\u001a\u00020\u0015H\u0002R\u0013\u0010\r\u001a\u00070\u000e\u00a2\u0006\u0002\b\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/changeSignature/KotlinChangeSignature;", "Lorg/jetbrains/kotlin/idea/refactoring/CallableRefactoring;", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "project", "Lcom/intellij/openapi/project/Project;", "callableDescriptor", "configuration", "Lorg/jetbrains/kotlin/idea/refactoring/changeSignature/KotlinChangeSignatureConfiguration;", "defaultValueContext", "Lcom/intellij/psi/PsiElement;", "commandName", "", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;Lorg/jetbrains/kotlin/idea/refactoring/changeSignature/KotlinChangeSignatureConfiguration;Lcom/intellij/psi/PsiElement;Ljava/lang/String;)V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getConfiguration", "()Lorg/jetbrains/kotlin/idea/refactoring/changeSignature/KotlinChangeSignatureConfiguration;", "getDefaultValueContext", "()Lcom/intellij/psi/PsiElement;", "adjustDescriptor", "Lorg/jetbrains/kotlin/idea/refactoring/changeSignature/KotlinMethodDescriptor;", "descriptorsForSignatureChange", "", "forcePerformForSelectedFunctionOnly", "", "getPreviewInfoForJavaMethod", "Lkotlin/Pair;", "Lcom/intellij/psi/PsiMethod;", "Lcom/intellij/refactoring/changeSignature/JavaChangeInfo;", "descriptor", "performRefactoring", "", "descriptorsForChange", "preferContainedInClass", "runInteractiveRefactoring", "runSilentRefactoring", "idea"})
public final class KotlinChangeSignature
extends CallableRefactoring<CallableDescriptor> {
    private final Logger LOG;
    @NotNull
    private final KotlinChangeSignatureConfiguration configuration;
    @NotNull
    private final PsiElement defaultValueContext;

    @Override
    protected boolean forcePerformForSelectedFunctionOnly() {
        return this.configuration.forcePerformForSelectedFunctionOnly();
    }

    private final void runSilentRefactoring(KotlinMethodDescriptor descriptor2) {
        BaseRefactoringProcessor baseRefactoringProcessor;
        PsiElement baseDeclaration = descriptor2.getBaseDeclaration();
        PsiElement psiElement2 = baseDeclaration;
        if (psiElement2 instanceof KtFunction || psiElement2 instanceof KtClass) {
            baseRefactoringProcessor = KotlinChangeSignatureDialog.Companion.createRefactoringProcessorForSilentChangeSignature(this.getProject(), this.getCommandName(), descriptor2, this.defaultValueContext);
        } else if (psiElement2 instanceof KtProperty || psiElement2 instanceof KtParameter) {
            baseRefactoringProcessor = KotlinChangePropertySignatureDialog.Companion.createProcessorForSilentRefactoring(this.getProject(), this.getCommandName(), descriptor2);
        } else if (psiElement2 instanceof PsiMethod) {
            if (Intrinsics.areEqual((Object)((PsiMethod)baseDeclaration).getLanguage(), (Object)JavaLanguage.INSTANCE) ^ true) {
                Messages.showErrorDialog((String)("Can't change signature of " + ((PsiMethod)baseDeclaration).getLanguage().getDisplayName() + " method"), (String)this.getCommandName());
                return;
            }
            baseRefactoringProcessor = (BaseRefactoringProcessor)new ChangeSignatureProcessor(this.getProject(), (JavaChangeInfo)this.getPreviewInfoForJavaMethod(descriptor2).getSecond());
        } else {
            throw (Throwable)((Object)new AssertionError((Object)("Unexpected declaration: " + PsiUtilsKt.getElementTextWithContext(baseDeclaration))));
        }
        BaseRefactoringProcessor processor2 = baseRefactoringProcessor;
        processor2.run();
    }

    /*
     * WARNING - void declaration
     */
    private final void runInteractiveRefactoring(KotlinMethodDescriptor descriptor2) {
        RefactoringDialog refactoringDialog;
        PsiElement baseDeclaration = descriptor2.getBaseDeclaration();
        PsiElement psiElement2 = baseDeclaration;
        if (psiElement2 instanceof KtFunction || psiElement2 instanceof KtClass) {
            refactoringDialog = (RefactoringDialog)new KotlinChangeSignatureDialog(this.getProject(), descriptor2, this.defaultValueContext, this.getCommandName());
        } else if (psiElement2 instanceof KtProperty || psiElement2 instanceof KtParameter) {
            refactoringDialog = new KotlinChangePropertySignatureDialog(this.getProject(), descriptor2, this.getCommandName());
        } else if (psiElement2 instanceof PsiMethod) {
            void preview2;
            void javaChangeInfo;
            if (descriptor2 instanceof KotlinChangeSignatureData) {
                ChangeSignatureUtil.invokeChangeSignatureOn((PsiMethod)((PsiMethod)baseDeclaration), (Project)this.getProject());
                return;
            }
            if (Intrinsics.areEqual((Object)((PsiMethod)baseDeclaration).getLanguage(), (Object)JavaLanguage.INSTANCE) ^ true) {
                Messages.showErrorDialog((String)("Can't change signature of " + ((PsiMethod)baseDeclaration).getLanguage().getDisplayName() + " method"), (String)this.getCommandName());
                return;
            }
            Pair<PsiMethod, JavaChangeInfo> pair2 = this.getPreviewInfoForJavaMethod(descriptor2);
            PsiMethod psiMethod = (PsiMethod)pair2.component1();
            JavaChangeInfo javaChangeInfo2 = (JavaChangeInfo)pair2.component2();
            pair2 = null;
            refactoringDialog = (RefactoringDialog)new JavaChangeSignatureDialog((JavaChangeInfo)javaChangeInfo, this.getProject(), new JavaMethodDescriptor((PsiMethod)preview2), false, null){
                final /* synthetic */ JavaChangeInfo $javaChangeInfo;

                @Nullable
                protected BaseRefactoringProcessor createRefactoringProcessor() {
                    Unit unit;
                    ChangeSignatureProcessor changeSignatureProcessor;
                    BaseRefactoringProcessor processor2 = super.createRefactoringProcessor();
                    BaseRefactoringProcessor baseRefactoringProcessor = processor2;
                    if (!(baseRefactoringProcessor instanceof ChangeSignatureProcessor)) {
                        baseRefactoringProcessor = null;
                    }
                    if ((changeSignatureProcessor = (ChangeSignatureProcessor)baseRefactoringProcessor) != null && (changeSignatureProcessor = changeSignatureProcessor.getChangeInfo()) != null) {
                        changeSignatureProcessor.updateMethod(this.$javaChangeInfo.getMethod());
                        unit = Unit.INSTANCE;
                    } else {
                        unit = null;
                    }
                    return processor2;
                }
                {
                    this.$javaChangeInfo = $captured_local_variable$0;
                    super($super_call_param$1, $super_call_param$2, $super_call_param$3, $super_call_param$4);
                }
            };
        } else {
            throw (Throwable)((Object)new AssertionError((Object)("Unexpected declaration: " + PsiUtilsKt.getElementTextWithContext(baseDeclaration))));
        }
        RefactoringDialog dialog2 = refactoringDialog;
        dialog2.show();
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<PsiMethod, JavaChangeInfo> getPreviewInfoForJavaMethod(KotlinMethodDescriptor descriptor2) {
        void elements$iv;
        JavaChangeInfoImpl javaChangeInfoImpl;
        Object object;
        PsiMethod psiMethod;
        void destination$iv$iv;
        void $receiver$iv$iv;
        ThrownExceptionInfo[] $receiver$iv;
        StringBuilder stringBuilder;
        void receiver$iv;
        PsiElement psiElement2 = descriptor2.getBaseDeclaration();
        if (psiElement2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.psi.PsiMethod");
        }
        PsiMethod originalMethod = (PsiMethod)psiElement2;
        PsiFile psiFile = this.defaultValueContext.getContainingFile();
        if (psiFile == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFile");
        }
        KtFile contextFile = (KtFile)psiFile;
        KotlinChangeInfo ktChangeInfo = new KotlinChangeInfo(descriptor2, null, null, null, null, null, this.defaultValueContext, null, 190, null);
        String ktSignature = ktChangeInfo.getNewSignature(descriptor2.getOriginalPrimaryCallable());
        StringBuilder stringBuilder2 = new StringBuilder();
        StringBuilder $receiver = (StringBuilder)receiver$iv;
        KtPackageDirective ktPackageDirective = contextFile.getPackageDirective();
        if (ktPackageDirective != null) {
            void $receiver$iv2;
            KtPackageDirective ktPackageDirective2 = ktPackageDirective;
            KtPackageDirective it = (KtPackageDirective)$receiver$iv2;
            stringBuilder = $receiver.append(it.getText()).append("\n");
        } else {
            stringBuilder = null;
        }
        $receiver.append("class Dummy {\n").append(ktSignature).append("{}\n}");
        String dummyFileText = $receiver.toString();
        PsiFile psiFile2 = JetRefactoringUtilKt.toPsiFile((VirtualFile)new LightVirtualFile("dummy.kt", (FileType)KotlinFileType.INSTANCE, (CharSequence)dummyFileText), this.getProject());
        if (psiFile2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFile");
        }
        KtFile dummyFile = (KtFile)psiFile2;
        KtPsiFactoryKt.setAnalysisContext(dummyFile, (PsiElement)originalMethod);
        Object object2 = CollectionsKt.first(dummyFile.getDeclarations());
        if (object2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtClass");
        }
        KtClassBody ktClassBody = ((KtClass)object2).getBody();
        if (ktClassBody == null) {
            Intrinsics.throwNpe();
        }
        KtDeclaration dummyDeclaration = (KtDeclaration)CollectionsKt.first(ktClassBody.getDeclarations());
        PsiClass containingClass = PsiElementFactory.SERVICE.getInstance((Project)this.getProject()).createClass("Dummy");
        PsiMethod psiMethod2 = LightClassUtilsKt.getRepresentativeLightMethod(dummyDeclaration);
        if (psiMethod2 == null) {
            Intrinsics.throwNpe();
        }
        PsiClass psiClass = containingClass;
        Intrinsics.checkExpressionValueIsNotNull((Object)psiClass, (String)"containingClass");
        PsiMethod preview2 = JetRefactoringUtilKt.createJavaMethod(psiMethod2, psiClass);
        String visibility = VisibilityUtil.getVisibilityModifier((PsiModifierList)originalMethod.getModifierList());
        PsiType psiType = preview2.getReturnType();
        if (psiType == null) {
            psiType = (PsiType)PsiType.VOID;
        }
        CanonicalTypes.Type returnType2 = CanonicalTypes.createTypeWrapper((PsiType)psiType);
        Iterable $i$f$with = ArraysKt.zip((Object[])preview2.getParameterList().getParameters(), (Object[])ktChangeInfo.getNewParameters());
        void var15_14 = $receiver$iv;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void param;
            void paramInfo;
            void it;
            Pair pair2 = (Pair)item$iv$iv;
            psiMethod = destination$iv$iv;
            Object var20_19 = it;
            PsiParameter psiParameter = (PsiParameter)var20_19.component1();
            KotlinParameterInfo kotlinParameterInfo = (KotlinParameterInfo)var20_19.component2();
            var20_19 = null;
            int n = paramInfo.getOldIndex();
            String string = param.getName();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"param.name!!");
            PsiType psiType2 = param.getType();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiType2, (String)"param.type");
            object = new KotlinAwareJavaParameterInfoImpl(n, string, psiType2, paramInfo.getDefaultValueForCall());
            psiMethod.add(object);
        }
        $receiver$iv = (ThrownExceptionInfo[])((List)destination$iv$iv);
        ThrownExceptionInfo[] thisCollection$iv = $receiver$iv;
        KotlinAwareJavaParameterInfoImpl[] kotlinAwareJavaParameterInfoImplArray = thisCollection$iv.toArray(new KotlinAwareJavaParameterInfoImpl[thisCollection$iv.size()]);
        if (kotlinAwareJavaParameterInfoImplArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        KotlinAwareJavaParameterInfoImpl[] params2 = (KotlinAwareJavaParameterInfoImpl[])((Object[])kotlinAwareJavaParameterInfoImplArray);
        $receiver$iv = new ThrownExceptionInfo[]{};
        ParameterInfoImpl[] parameterInfoImplArray = params2;
        CanonicalTypes.Type type2 = returnType2;
        String string = preview2.getName();
        PsiMethod psiMethod3 = originalMethod;
        String string2 = visibility;
        JavaChangeInfoImpl javaChangeInfoImpl2 = javaChangeInfoImpl;
        object = javaChangeInfoImpl;
        psiMethod = preview2;
        Object[] objectArray = (Object[])elements$iv;
        javaChangeInfoImpl2(string2, psiMethod3, string, type2, parameterInfoImplArray, (ThrownExceptionInfo[])objectArray, false, SetsKt.emptySet(), SetsKt.emptySet());
        return TuplesKt.to((Object)psiMethod, (Object)object);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    protected void performRefactoring(@NotNull Collection<? extends CallableDescriptor> descriptorsForChange) {
        void destination$iv$iv;
        void $receiver$iv$iv$iv;
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull(descriptorsForChange, (String)"descriptorsForChange");
        KotlinMethodDescriptor kotlinMethodDescriptor = this.adjustDescriptor(descriptorsForChange);
        if (kotlinMethodDescriptor == null) return;
        KotlinMethodDescriptor adjustedDescriptor = kotlinMethodDescriptor;
        Iterable iterable = adjustedDescriptor.getAffectedCallables();
        Iterator iterator2 = $receiver$iv;
        Collection collection = new ArrayList();
        void var7_6 = $receiver$iv$iv;
        for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
            Boolean bl;
            Object element$iv$iv = element$iv$iv$iv;
            UsageInfo it = (UsageInfo)element$iv$iv;
            if (it.getElement() != null) {
                void $receiver$iv$iv$iv2;
                void it$iv$iv = $receiver$iv$iv$iv2;
                bl = destination$iv$iv.add(it$iv$iv);
                continue;
            }
            bl = null;
        }
        List affectedFunctions = (List)destination$iv$iv;
        $receiver$iv = affectedFunctions;
        for (Object element$iv : $receiver$iv) {
            PsiElement it;
            PsiElement psiElement2 = it = (PsiElement)element$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"it");
            if (!this.checkModifiable(psiElement2)) {
                return;
            }
            boolean bl = false;
            if (!bl) continue;
            return;
        }
        boolean bl = false;
        if (bl) {
            return;
        }
        if (!this.configuration.performSilently(affectedFunctions)) {
            Application application = ApplicationManager.getApplication();
            if (application == null) {
                Intrinsics.throwNpe();
            }
            if (!application.isUnitTestMode()) {
                this.runInteractiveRefactoring(adjustedDescriptor);
                return;
            }
        }
        this.runSilentRefactoring(adjustedDescriptor);
    }

    @Nullable
    public final KotlinMethodDescriptor adjustDescriptor(@NotNull Collection<? extends CallableDescriptor> descriptorsForSignatureChange) {
        Intrinsics.checkParameterIsNotNull(descriptorsForSignatureChange, (String)"descriptorsForSignatureChange");
        CallableDescriptor baseDescriptor = this.preferContainedInClass(descriptorsForSignatureChange);
        PsiElement functionDeclaration = DescriptorToSourceUtilsIde.INSTANCE.getAnyDeclaration(this.getProject(), baseDescriptor);
        if (functionDeclaration == null) {
            this.LOG.error("Could not find declaration for " + baseDescriptor);
            return null;
        }
        if (!this.checkModifiable(functionDeclaration)) {
            return null;
        }
        KotlinChangeSignatureData originalDescriptor = new KotlinChangeSignatureData(baseDescriptor, functionDeclaration, descriptorsForSignatureChange);
        return this.configuration.configure(originalDescriptor);
    }

    private final CallableDescriptor preferContainedInClass(Collection<? extends CallableDescriptor> descriptorsForSignatureChange) {
        for (CallableDescriptor callableDescriptor : descriptorsForSignatureChange) {
            DeclarationDescriptor containingDeclaration = callableDescriptor.getContainingDeclaration();
            if (!(containingDeclaration instanceof ClassDescriptor) || !(Intrinsics.areEqual((Object)((Object)((ClassDescriptor)containingDeclaration).getKind()), (Object)((Object)ClassKind.INTERFACE)) ^ true)) continue;
            return callableDescriptor;
        }
        return (CallableDescriptor)CollectionsKt.first((Iterable)descriptorsForSignatureChange);
    }

    @NotNull
    public final KotlinChangeSignatureConfiguration getConfiguration() {
        return this.configuration;
    }

    @NotNull
    public final PsiElement getDefaultValueContext() {
        return this.defaultValueContext;
    }

    public KotlinChangeSignature(@NotNull Project project, @NotNull CallableDescriptor callableDescriptor, @NotNull KotlinChangeSignatureConfiguration configuration2, @NotNull PsiElement defaultValueContext, @Nullable String commandName) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)callableDescriptor, (String)"callableDescriptor");
        Intrinsics.checkParameterIsNotNull((Object)configuration2, (String)"configuration");
        Intrinsics.checkParameterIsNotNull((Object)defaultValueContext, (String)"defaultValueContext");
        String string = commandName;
        if (string == null) {
            String string2 = ChangeSignatureHandler.REFACTORING_NAME;
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"ChangeSignatureHandler.REFACTORING_NAME");
        }
        super(project, callableDescriptor, string);
        this.configuration = configuration2;
        this.defaultValueContext = defaultValueContext;
        this.LOG = Logger.getInstance(KotlinChangeSignature.class);
    }
}

