/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtDeclarationStub;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.KtWithExpressionInitializer;
import org.jetbrains.kotlin.psi.stubs.KotlinPropertyAccessorStub;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementTypes;

public class KtPropertyAccessor
extends KtDeclarationStub<KotlinPropertyAccessorStub>
implements KtDeclarationWithBody,
KtModifierListOwner,
KtWithExpressionInitializer {
    public KtPropertyAccessor(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/psi/KtPropertyAccessor", "<init>"));
        }
        super(node);
    }

    public KtPropertyAccessor(@NotNull KotlinPropertyAccessorStub stub) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "org/jetbrains/kotlin/psi/KtPropertyAccessor", "<init>"));
        }
        super(stub, KtStubElementTypes.PROPERTY_ACCESSOR);
    }

    @Override
    public <R, D> R accept(@NotNull KtVisitor<R, D> visitor2, D data) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/kotlin/psi/KtPropertyAccessor", "accept"));
        }
        return visitor2.visitPropertyAccessor(this, data);
    }

    public boolean isSetter() {
        KotlinPropertyAccessorStub stub = (KotlinPropertyAccessorStub)this.getStub();
        if (stub != null) {
            return !stub.isGetter();
        }
        return this.findChildByType(KtTokens.SET_KEYWORD) != null;
    }

    public boolean isGetter() {
        KotlinPropertyAccessorStub stub = (KotlinPropertyAccessorStub)this.getStub();
        if (stub != null) {
            return stub.isGetter();
        }
        return this.findChildByType(KtTokens.GET_KEYWORD) != null;
    }

    @Nullable
    public KtParameterList getParameterList() {
        return (KtParameterList)this.getStubOrPsiChild(KtStubElementTypes.VALUE_PARAMETER_LIST);
    }

    @Nullable
    public KtParameter getParameter() {
        KtParameterList parameterList2 = this.getParameterList();
        if (parameterList2 == null) {
            return null;
        }
        List<KtParameter> parameters2 = parameterList2.getParameters();
        if (parameters2.isEmpty()) {
            return null;
        }
        return parameters2.get(0);
    }

    @Override
    @NotNull
    public List<KtParameter> getValueParameters() {
        KtParameter parameter = this.getParameter();
        if (parameter == null) {
            List<KtParameter> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/KtPropertyAccessor", "getValueParameters"));
            }
            return list2;
        }
        List<KtParameter> list3 = Collections.singletonList(parameter);
        if (list3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/KtPropertyAccessor", "getValueParameters"));
        }
        return list3;
    }

    @Override
    @Nullable
    public KtExpression getBodyExpression() {
        return (KtExpression)this.findChildByClass(KtExpression.class);
    }

    @Override
    public boolean hasBlockBody() {
        return this.getEqualsToken() == null;
    }

    @Override
    public boolean hasBody() {
        KotlinPropertyAccessorStub stub = (KotlinPropertyAccessorStub)this.getStub();
        if (stub != null) {
            return stub.hasBody();
        }
        return this.getBodyExpression() != null;
    }

    @Override
    @Nullable
    public PsiElement getEqualsToken() {
        return this.findChildByType(KtTokens.EQ);
    }

    @Override
    public boolean hasDeclaredReturnType() {
        return true;
    }

    @Nullable
    public KtTypeReference getReturnTypeReference() {
        return (KtTypeReference)this.getStubOrPsiChild(KtStubElementTypes.TYPE_REFERENCE);
    }

    @NotNull
    public PsiElement getNamePlaceholder() {
        PsiElement get2 = this.findChildByType(KtTokens.GET_KEYWORD);
        if (get2 != null) {
            PsiElement psiElement2 = get2;
            if (psiElement2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/KtPropertyAccessor", "getNamePlaceholder"));
            }
            return psiElement2;
        }
        PsiElement psiElement3 = this.findChildByType(KtTokens.SET_KEYWORD);
        if (psiElement3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/KtPropertyAccessor", "getNamePlaceholder"));
        }
        return psiElement3;
    }

    @Nullable
    public ASTNode getRightParenthesis() {
        return this.getNode().findChildByType((IElementType)KtTokens.RPAR);
    }

    @Override
    @Nullable
    public KtExpression getInitializer() {
        return (KtExpression)PsiTreeUtil.getNextSiblingOfType((PsiElement)this.getEqualsToken(), KtExpression.class);
    }

    @Override
    public boolean hasInitializer() {
        return this.getInitializer() != null;
    }

    @NotNull
    public KtProperty getProperty() {
        KtProperty ktProperty = (KtProperty)this.getParent();
        if (ktProperty == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/KtPropertyAccessor", "getProperty"));
        }
        return ktProperty;
    }
}

