/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.io;

import com.esotericsoftware.kryo.KryoException;
import com.esotericsoftware.kryo.io.ByteBufferOutput;
import com.esotericsoftware.kryo.util.UnsafeUtil;
import com.esotericsoftware.kryo.util.Util;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import sun.nio.ch.DirectBuffer;

public final class UnsafeMemoryOutput
extends ByteBufferOutput {
    private long bufaddress;
    private static final boolean isLittleEndian = ByteOrder.nativeOrder().equals(ByteOrder.LITTLE_ENDIAN);

    public UnsafeMemoryOutput() {
        this.varIntsEnabled = false;
        this.updateBufferAddress();
    }

    public UnsafeMemoryOutput(int n) {
        this(n, n);
    }

    public UnsafeMemoryOutput(int n, int n2) {
        super(n, n2);
        this.varIntsEnabled = false;
        this.updateBufferAddress();
    }

    public UnsafeMemoryOutput(OutputStream outputStream) {
        super(outputStream);
        this.varIntsEnabled = false;
        this.updateBufferAddress();
    }

    public UnsafeMemoryOutput(OutputStream outputStream, int n) {
        super(outputStream, n);
        this.varIntsEnabled = false;
        this.updateBufferAddress();
    }

    public UnsafeMemoryOutput(long l, int n) {
        super(l, n);
        this.varIntsEnabled = false;
        this.updateBufferAddress();
    }

    @Override
    public void setBuffer(ByteBuffer byteBuffer, int n) {
        super.setBuffer(byteBuffer, n);
        this.updateBufferAddress();
    }

    private void updateBufferAddress() {
        this.bufaddress = ((DirectBuffer)((Object)this.niobuffer)).address();
    }

    @Override
    public final void writeInt(int n) throws KryoException {
        this.require(4);
        UnsafeUtil.unsafe().putInt(this.bufaddress + (long)this.position, n);
        this.position += 4;
    }

    @Override
    public final void writeFloat(float f) throws KryoException {
        this.require(4);
        UnsafeUtil.unsafe().putFloat(this.bufaddress + (long)this.position, f);
        this.position += 4;
    }

    @Override
    public final void writeShort(int n) throws KryoException {
        this.require(2);
        UnsafeUtil.unsafe().putShort(this.bufaddress + (long)this.position, (short)n);
        this.position += 2;
    }

    @Override
    public final void writeLong(long l) throws KryoException {
        this.require(8);
        UnsafeUtil.unsafe().putLong(this.bufaddress + (long)this.position, l);
        this.position += 8;
    }

    @Override
    public final void writeByte(int n) throws KryoException {
        this.niobuffer.position(this.position);
        super.writeByte(n);
    }

    @Override
    public void writeByte(byte by) throws KryoException {
        this.niobuffer.position(this.position);
        super.writeByte(by);
    }

    @Override
    public final void writeBoolean(boolean bl) throws KryoException {
        this.niobuffer.position(this.position);
        super.writeBoolean(bl);
    }

    @Override
    public final void writeChar(char c) throws KryoException {
        this.niobuffer.position(this.position);
        super.writeChar(c);
    }

    @Override
    public final void writeDouble(double d) throws KryoException {
        this.require(8);
        UnsafeUtil.unsafe().putDouble(this.bufaddress + (long)this.position, d);
        double d2 = UnsafeUtil.unsafe().getDouble(this.bufaddress + (long)this.position);
        this.position += 8;
    }

    @Override
    public final int writeInt(int n, boolean bl) throws KryoException {
        if (!this.varIntsEnabled) {
            this.writeInt(n);
            return 4;
        }
        return this.writeVarInt(n, bl);
    }

    @Override
    public final int writeLong(long l, boolean bl) throws KryoException {
        if (!this.varIntsEnabled) {
            this.writeLong(l);
            return 8;
        }
        return this.writeVarLong(l, bl);
    }

    @Override
    public final int writeVarInt(int n, boolean bl) throws KryoException {
        long l = n;
        if (!bl) {
            l = l << 1 ^ l >> 31;
        }
        long l2 = 0L;
        l2 = l & 0x7FL;
        if ((l >>>= 7) == 0L) {
            this.writeByte((byte)l2);
            return 1;
        }
        l2 |= 0x80L;
        l2 |= (l & 0x7FL) << 8;
        if ((l >>>= 7) == 0L) {
            this.writeLittleEndianInt((int)l2);
            this.position -= 2;
            return 2;
        }
        l2 |= 0x8000L;
        l2 |= (l & 0x7FL) << 16;
        if ((l >>>= 7) == 0L) {
            this.writeLittleEndianInt((int)l2);
            --this.position;
            return 3;
        }
        l2 |= 0x800000L;
        l2 |= (l & 0x7FL) << 24;
        if ((l >>>= 7) == 0L) {
            this.writeLittleEndianInt((int)l2);
            this.position -= 0;
            return 4;
        }
        l2 |= Integer.MIN_VALUE;
        l2 |= (l & 0x7FL) << 32;
        this.writeLittleEndianLong(l2 &= 0xFFFFFFFFL);
        this.position -= 3;
        return 5;
    }

    @Override
    public final int writeVarLong(long l, boolean bl) throws KryoException {
        if (!bl) {
            l = l << 1 ^ l >> 63;
        }
        int n = 0;
        n = (int)(l & 0x7FL);
        if ((l >>>= 7) == 0L) {
            this.write(n);
            return 1;
        }
        n |= 0x80;
        n = (int)((long)n | (l & 0x7FL) << 8);
        if ((l >>>= 7) == 0L) {
            this.writeLittleEndianInt(n);
            this.position -= 2;
            return 2;
        }
        n |= 0x8000;
        n = (int)((long)n | (l & 0x7FL) << 16);
        if ((l >>>= 7) == 0L) {
            this.writeLittleEndianInt(n);
            --this.position;
            return 3;
        }
        n |= 0x800000;
        n = (int)((long)n | (l & 0x7FL) << 24);
        if ((l >>>= 7) == 0L) {
            this.writeLittleEndianInt(n);
            this.position -= 0;
            return 4;
        }
        long l2 = (long)(n |= Integer.MIN_VALUE) & 0xFFFFFFFFL | (l & 0x7FL) << 32;
        if ((l >>>= 7) == 0L) {
            this.writeLittleEndianLong(l2);
            this.position -= 3;
            return 5;
        }
        l2 |= 0x8000000000L;
        l2 |= (l & 0x7FL) << 40;
        if ((l >>>= 7) == 0L) {
            this.writeLittleEndianLong(l2);
            this.position -= 2;
            return 6;
        }
        l2 |= 0x800000000000L;
        l2 |= (l & 0x7FL) << 48;
        if ((l >>>= 7) == 0L) {
            this.writeLittleEndianLong(l2);
            --this.position;
            return 7;
        }
        l2 |= 0x80000000000000L;
        l2 |= (l & 0x7FL) << 56;
        if ((l >>>= 7) == 0L) {
            this.writeLittleEndianLong(l2);
            return 8;
        }
        this.writeLittleEndianLong(l2 |= Long.MIN_VALUE);
        this.write((byte)(l & 0x7FL));
        return 9;
    }

    private final void writeLittleEndianInt(int n) {
        if (isLittleEndian) {
            this.writeInt(n);
        } else {
            this.writeInt(Util.swapInt(n));
        }
    }

    private final void writeLittleEndianLong(long l) {
        if (isLittleEndian) {
            this.writeLong(l);
        } else {
            this.writeLong(Util.swapLong(l));
        }
    }

    @Override
    public final void writeInts(int[] nArray, boolean bl) throws KryoException {
        if (!this.varIntsEnabled) {
            int n = nArray.length << 2;
            this.writeBytes(nArray, UnsafeUtil.intArrayBaseOffset, 0L, n);
        } else {
            super.writeInts(nArray, bl);
        }
    }

    @Override
    public final void writeLongs(long[] lArray, boolean bl) throws KryoException {
        if (!this.varIntsEnabled) {
            int n = lArray.length << 3;
            this.writeBytes(lArray, UnsafeUtil.longArrayBaseOffset, 0L, n);
        } else {
            super.writeLongs(lArray, bl);
        }
    }

    @Override
    public final void writeInts(int[] nArray) throws KryoException {
        int n = nArray.length << 2;
        this.writeBytes(nArray, UnsafeUtil.intArrayBaseOffset, 0L, n);
    }

    @Override
    public final void writeLongs(long[] lArray) throws KryoException {
        int n = lArray.length << 3;
        this.writeBytes(lArray, UnsafeUtil.longArrayBaseOffset, 0L, n);
    }

    @Override
    public final void writeFloats(float[] fArray) throws KryoException {
        int n = fArray.length << 2;
        this.writeBytes(fArray, UnsafeUtil.floatArrayBaseOffset, 0L, n);
    }

    @Override
    public final void writeShorts(short[] sArray) throws KryoException {
        int n = sArray.length << 1;
        this.writeBytes(sArray, UnsafeUtil.shortArrayBaseOffset, 0L, n);
    }

    @Override
    public final void writeChars(char[] cArray) throws KryoException {
        int n = cArray.length << 1;
        this.writeBytes(cArray, UnsafeUtil.charArrayBaseOffset, 0L, n);
    }

    @Override
    public final void writeDoubles(double[] dArray) throws KryoException {
        int n = dArray.length << 3;
        this.writeBytes(dArray, UnsafeUtil.doubleArrayBaseOffset, 0L, n);
    }

    public final void writeBytes(Object object, long l, long l2) throws KryoException {
        this.writeBytes(object, 0L, l, l2);
    }

    private final void writeBytes(Object object, long l, long l2, long l3) throws KryoException {
        int n = Math.min(this.capacity - this.position, (int)l3);
        while (true) {
            UnsafeUtil.unsafe().copyMemory(object, l + l2, null, this.bufaddress + (long)this.position, n);
            this.position += n;
            if ((l3 -= (long)n) == 0L) {
                return;
            }
            l2 += (long)n;
            n = Math.min(this.capacity, (int)l3);
            this.require(n);
        }
    }
}

