/*
 * Decompiled with CFR 0.152.
 */
package com.theoryinpractice.testng.configuration;

import com.intellij.execution.Location;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.junit.JavaRuntimeConfigurationProducerBase;
import com.intellij.execution.junit2.info.LocationUtil;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPackage;
import com.theoryinpractice.testng.configuration.TestNGConfiguration;
import com.theoryinpractice.testng.configuration.TestNGConfigurationProducer;
import com.theoryinpractice.testng.model.TestData;
import com.theoryinpractice.testng.model.TestType;
import com.theoryinpractice.testng.util.TestNGUtil;

public abstract class AbstractTestNGPackageConfigurationProducer
extends TestNGConfigurationProducer {
    protected AbstractTestNGPackageConfigurationProducer(ConfigurationType configurationType) {
        super(configurationType);
    }

    protected boolean setupConfigurationFromContext(TestNGConfiguration configuration, ConfigurationContext context, Ref<PsiElement> sourceElement) {
        PsiElement element = context.getPsiLocation();
        PsiPackage aPackage = JavaRuntimeConfigurationProducerBase.checkPackage((PsiElement)element);
        if (aPackage == null) {
            return false;
        }
        Location location = context.getLocation();
        if (location == null) {
            return false;
        }
        if (!LocationUtil.isJarAttached((Location)location, (PsiPackage)aPackage, (String)TestNGUtil.TEST_ANNOTATION_FQN)) {
            return false;
        }
        TestData data = configuration.data;
        data.PACKAGE_NAME = aPackage.getQualifiedName();
        data.TEST_OBJECT = TestType.PACKAGE.getType();
        data.setScope(this.setupPackageConfiguration(context, (ModuleBasedConfiguration)configuration, data.getScope()));
        configuration.setGeneratedName();
        sourceElement.set((Object)aPackage);
        return true;
    }
}

