/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme;

import com.android.resources.ResourceType;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ThemeSelectionDialog;
import com.android.tools.idea.configurations.ThemeSelectionPanel;
import com.android.tools.idea.editors.theme.ParentThemesListModel;
import com.android.tools.idea.editors.theme.ResolutionUtils;
import com.android.tools.idea.editors.theme.ThemeEditorContext;
import com.android.tools.idea.editors.theme.ThemeEditorUtils;
import com.android.tools.idea.editors.theme.ThemeResolver;
import com.android.tools.idea.editors.theme.attributes.editors.StyleListCellRenderer;
import com.android.tools.idea.rendering.AppResourceRepository;
import com.android.tools.idea.rendering.ResourceNameValidator;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NewStyleDialog
extends DialogWrapper {
    private final ResourceNameValidator myResourceNameValidator;
    private JPanel contentPane;
    private JTextField myStyleNameTextField;
    private JLabel myMessageLabel;
    private JLabel myParentStyleLabel;
    private JLabel myStyleNameLabel;
    private JComboBox myParentStyleComboBox;
    private final String myEmptyStyleValidationText;
    @Nullable
    private ThemeSelectionPanel.ThemeChangedListener myThemeChangedListener;
    private static final String[] COMMON_THEME_NAMES = new String[]{"Material", "Holo", "Leanback", "Micro", "DeviceDefault", "AppCompat"};

    public NewStyleDialog(boolean isTheme, @NotNull ThemeEditorContext context, @Nullable String defaultParentName, final @Nullable String currentThemeName, @Nullable String message) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/editors/theme/NewStyleDialog", "<init>"));
        }
        super(true);
        this.$$$setupUI$$$();
        if (!Strings.isNullOrEmpty((String)message)) {
            this.myMessageLabel.setText(message);
            this.myMessageLabel.setVisible(true);
        } else {
            this.myMessageLabel.setVisible(false);
        }
        final Configuration configuration = context.getConfiguration();
        this.myResourceNameValidator = ResourceNameValidator.create(false, AppResourceRepository.getAppResources(configuration.getModule(), true), ResourceType.STYLE);
        String styleTypeString = isTheme ? "theme" : "style";
        this.setTitle("New " + StringUtil.capitalize((String)styleTypeString));
        this.myStyleNameLabel.setText(String.format("New %1$s name:", styleTypeString));
        this.myParentStyleLabel.setText(String.format("Parent %1$s name:", styleTypeString));
        this.myEmptyStyleValidationText = String.format("You must specify a %1$s name", styleTypeString);
        this.myStyleNameTextField.setText(NewStyleDialog.getNewStyleNameSuggestion(defaultParentName, currentThemeName));
        ThemeResolver themeResolver = context.getThemeResolver();
        final ImmutableList<String> defaultThemeNames = ThemeEditorUtils.getDefaultThemeNames(themeResolver);
        this.myParentStyleComboBox.setRenderer(new StyleListCellRenderer(context, this.myParentStyleComboBox));
        final ParentThemesListModel parentThemesListModel = new ParentThemesListModel((List<String>)defaultThemeNames, defaultParentName);
        this.myParentStyleComboBox.setModel(parentThemesListModel);
        this.myParentStyleComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String selectedValue = (String)NewStyleDialog.this.myParentStyleComboBox.getSelectedItem();
                if ("Show all themes".equals(selectedValue)) {
                    NewStyleDialog.this.myParentStyleComboBox.hidePopup();
                    ThemeSelectionDialog dialog = new ThemeSelectionDialog(configuration);
                    if (NewStyleDialog.this.myThemeChangedListener != null) {
                        dialog.setThemeChangedListener(NewStyleDialog.this.myThemeChangedListener);
                    }
                    dialog.show();
                    String string = selectedValue = dialog.isOK() ? dialog.getTheme() : null;
                }
                if (selectedValue == null) {
                    selectedValue = (String)parentThemesListModel.getElementAt(0);
                } else if (!defaultThemeNames.contains((Object)selectedValue)) {
                    parentThemesListModel.removeElement(selectedValue);
                    parentThemesListModel.insertElementAt(selectedValue, 0);
                }
                NewStyleDialog.this.myParentStyleComboBox.setSelectedItem(selectedValue);
                NewStyleDialog.this.myStyleNameTextField.setText(NewStyleDialog.getNewStyleNameSuggestion(selectedValue, currentThemeName));
                if (NewStyleDialog.this.myThemeChangedListener != null) {
                    NewStyleDialog.this.myThemeChangedListener.themeChanged(selectedValue);
                }
            }
        });
        this.init();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.contentPane;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myStyleNameTextField;
    }

    @Nullable
    protected ValidationInfo doValidate() {
        String newStyleName = this.myStyleNameTextField.getText();
        if (Strings.isNullOrEmpty((String)newStyleName)) {
            return new ValidationInfo(this.myEmptyStyleValidationText, (JComponent)this.myStyleNameTextField);
        }
        if (!this.myResourceNameValidator.checkInput(newStyleName)) {
            return new ValidationInfo(this.myResourceNameValidator.getErrorText(newStyleName), (JComponent)this.myStyleNameTextField);
        }
        return super.doValidate();
    }

    public void show() {
        if (this.myThemeChangedListener != null) {
            this.myThemeChangedListener.themeChanged((String)this.myParentStyleComboBox.getSelectedItem());
        }
        super.show();
    }

    public String getStyleName() {
        return this.myStyleNameTextField.getText();
    }

    public String getStyleParentName() {
        return (String)this.myParentStyleComboBox.getSelectedItem();
    }

    @NotNull
    static String getNewStyleNameSuggestion(@Nullable String parentQualifiedName, @Nullable String currentThemeName) {
        if (Strings.isNullOrEmpty((String)parentQualifiedName) || Strings.isNullOrEmpty((String)currentThemeName)) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/NewStyleDialog", "getNewStyleNameSuggestion"));
            }
            return "";
        }
        String parentStyleName = ResolutionUtils.getNameFromQualifiedName(parentQualifiedName);
        if (parentStyleName.equals(currentThemeName)) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/NewStyleDialog", "getNewStyleNameSuggestion"));
            }
            return "";
        }
        currentThemeName = currentThemeName.replace("Theme.", "");
        for (String themeName : COMMON_THEME_NAMES) {
            if (!parentStyleName.matches(".*\\b" + themeName + "\\b.*")) continue;
            String string = parentStyleName.replaceFirst("\\b" + themeName + "\\b", currentThemeName);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/NewStyleDialog", "getNewStyleNameSuggestion"));
            }
            return string;
        }
        String string = parentStyleName + '.' + currentThemeName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/NewStyleDialog", "getNewStyleNameSuggestion"));
        }
        return string;
    }

    public void setThemeChangedListener(@NotNull ThemeSelectionPanel.ThemeChangedListener themeChangedListener) {
        if (themeChangedListener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "themeChangedListener", "com/android/tools/idea/editors/theme/NewStyleDialog", "setThemeChangedListener"));
        }
        this.myThemeChangedListener = themeChangedListener;
    }

    public void enableParentChoice(boolean enable) {
        this.myParentStyleComboBox.setEnabled(enable);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JComboBox jComboBox;
        JLabel jLabel2;
        JTextField jTextField;
        JLabel jLabel3;
        JPanel jPanel;
        this.contentPane = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(10, 10, 10, 10), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myStyleNameLabel = jLabel3 = new JLabel();
        jLabel3.setText("New style name:");
        jPanel2.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myStyleNameTextField = jTextField = new JTextField();
        jPanel2.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myParentStyleLabel = jLabel2 = new JLabel();
        jLabel2.setText("Parent style name:");
        jPanel2.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myParentStyleComboBox = jComboBox = new JComboBox();
        jPanel2.add(jComboBox, new GridConstraints(1, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 1, 6, 1, null, new Dimension(400, -1), null));
        this.myMessageLabel = jLabel = new JLabel();
        jLabel.setText("");
        Font font = jLabel.getFont();
        if (font != null) {
            jLabel.setFont(new Font(font.getName(), 1, font.getSize()));
        }
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 9, 0, 6, 0, null, null, null));
        jLabel3.setLabelFor(jTextField);
        jLabel2.setLabelFor(jComboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }
}

