/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.actions;

import com.android.tools.idea.gradle.actions.AndroidStudioGradleAction;
import com.android.tools.idea.gradle.invoker.GradleInvoker;
import com.android.tools.idea.gradle.util.Projects;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;

public class MakeGradleModuleAction
extends AndroidStudioGradleAction {
    public MakeGradleModuleAction() {
        super("Make Module(s)");
    }

    @Override
    protected void doUpdate(@NotNull AnActionEvent e, @NotNull Project project) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/android/tools/idea/gradle/actions/MakeGradleModuleAction", "doUpdate"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/actions/MakeGradleModuleAction", "doUpdate"));
        }
        MakeGradleModuleAction.updatePresentation(e, project);
    }

    public static void updatePresentation(@NotNull AnActionEvent e, @NotNull Project project) {
        String presentationText;
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/android/tools/idea/gradle/actions/MakeGradleModuleAction", "updatePresentation"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/actions/MakeGradleModuleAction", "updatePresentation"));
        }
        DataContext dataContext = e.getDataContext();
        Module[] modules = Projects.getModulesToBuildFromSelection(project, dataContext);
        int moduleCount = modules.length;
        Presentation presentation = e.getPresentation();
        presentation.setEnabled(moduleCount > 0);
        if (moduleCount > 0) {
            String text = "Make Module";
            if (moduleCount > 1) {
                text = text + "s";
            }
            for (int i = 0; i < moduleCount; ++i) {
                if (text.length() > 30) {
                    text = "Make Selected Modules";
                    break;
                }
                Module toMake = modules[i];
                if (i != 0) {
                    text = text + ",";
                }
                text = text + " '" + toMake.getName() + "'";
            }
            presentationText = text;
        } else {
            presentationText = "Make";
        }
        presentation.setText(presentationText);
        presentation.setVisible(moduleCount > 0 || !"ProjectViewPopup".equals(e.getPlace()));
    }

    @Override
    protected void doPerform(@NotNull AnActionEvent e, @NotNull Project project) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/android/tools/idea/gradle/actions/MakeGradleModuleAction", "doPerform"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/actions/MakeGradleModuleAction", "doPerform"));
        }
        Module[] modules = Projects.getModulesToBuildFromSelection(project, e.getDataContext());
        GradleInvoker.getInstance(project).compileJava(modules, GradleInvoker.TestCompileType.NONE);
    }
}

