/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.parser;

import com.android.tools.idea.gradle.parser.BuildFileKey;
import com.android.tools.idea.gradle.parser.GradleBuildFile;
import com.android.tools.idea.gradle.parser.GradleGroovyFile;
import com.android.tools.idea.gradle.parser.ValueFactory;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.text.Collator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.util.GrStatementOwner;

public class NamedObject
implements Comparable<NamedObject> {
    private String myName;
    private final boolean myAlwaysOnTop;
    private final Map<BuildFileKey, Object> myValues;

    public NamedObject(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/gradle/parser/NamedObject", "<init>"));
        }
        this(name, false);
    }

    protected NamedObject(@NotNull String name, boolean alwaysOnTop) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/gradle/parser/NamedObject", "<init>"));
        }
        this.myValues = Maps.newHashMap();
        this.myName = name;
        this.myAlwaysOnTop = alwaysOnTop;
    }

    public NamedObject(@NotNull NamedObject obj) {
        if (obj == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "obj", "com/android/tools/idea/gradle/parser/NamedObject", "<init>"));
        }
        this.myValues = Maps.newHashMap();
        this.myName = obj.myName;
        this.myAlwaysOnTop = obj.myAlwaysOnTop;
        this.myValues.putAll(obj.myValues);
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/parser/NamedObject", "getName"));
        }
        return string;
    }

    @NotNull
    public Map<BuildFileKey, Object> getValues() {
        Map<BuildFileKey, Object> map = this.myValues;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/parser/NamedObject", "getValues"));
        }
        return map;
    }

    @Nullable
    public Object getValue(@NotNull BuildFileKey buildFileKey) {
        if (buildFileKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildFileKey", "com/android/tools/idea/gradle/parser/NamedObject", "getValue"));
        }
        return this.myValues.get((Object)buildFileKey);
    }

    public void setName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/gradle/parser/NamedObject", "setName"));
        }
        this.myName = name;
    }

    public void setValue(@NotNull BuildFileKey property, @Nullable Object value) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/android/tools/idea/gradle/parser/NamedObject", "setValue"));
        }
        if (value == null) {
            this.myValues.remove((Object)property);
        } else {
            this.myValues.put(property, value);
        }
    }

    public static ValueFactory getFactory(@NotNull List<BuildFileKey> properties) {
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/android/tools/idea/gradle/parser/NamedObject", "getFactory"));
        }
        return new Factory(properties);
    }

    @Override
    public int compareTo(NamedObject o) {
        if (this.myAlwaysOnTop != o.myAlwaysOnTop) {
            return this.myAlwaysOnTop ? -1 : 1;
        }
        return Collator.getInstance().compare(this.myName, o.myName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NamedObject)) {
            return false;
        }
        NamedObject that = (NamedObject)o;
        if (!this.myName.equals(that.myName)) {
            return false;
        }
        return this.myValues.equals(that.myValues);
    }

    public int hashCode() {
        int result = this.myName.hashCode();
        result = 31 * result + this.myValues.hashCode();
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("NamedObject ");
        sb.append(this.myName);
        sb.append(' ');
        sb.append(this.myValues.toString());
        return sb.toString();
    }

    public static class Factory
    extends ValueFactory<NamedObject> {
        private final List<BuildFileKey> myProperties;

        private Factory(@NotNull List<BuildFileKey> properties) {
            if (properties == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/android/tools/idea/gradle/parser/NamedObject$Factory", "<init>"));
            }
            this.myProperties = properties;
        }

        @Override
        protected Iterable<NamedObject> findValuesToDelete(@NotNull GrStatementOwner closure, final @NotNull List<NamedObject> replacementValues) {
            if (closure == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "closure", "com/android/tools/idea/gradle/parser/NamedObject$Factory", "findValuesToDelete"));
            }
            if (replacementValues == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "replacementValues", "com/android/tools/idea/gradle/parser/NamedObject$Factory", "findValuesToDelete"));
            }
            return Iterables.filter(this.getValues(closure), (Predicate)new Predicate<NamedObject>(){

                public boolean apply(NamedObject input) {
                    for (NamedObject value : replacementValues) {
                        if (!value.getName().equals(input.getName())) continue;
                        return false;
                    }
                    return true;
                }
            });
        }

        @Override
        protected void setValue(@NotNull GrStatementOwner closure, @NotNull NamedObject object, @Nullable ValueFactory.KeyFilter filter) {
            if (closure == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "closure", "com/android/tools/idea/gradle/parser/NamedObject$Factory", "setValue"));
            }
            if (object == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/android/tools/idea/gradle/parser/NamedObject$Factory", "setValue"));
            }
            GrClosableBlock subclosure = GradleGroovyFile.getMethodClosureArgument(closure, object.myName);
            GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance((Project)closure.getProject());
            if (subclosure == null) {
                closure.addBefore((PsiElement)factory.createStatementFromText((CharSequence)(object.getName() + " {\n}\n")), closure.getLastChild());
                subclosure = GradleGroovyFile.getMethodClosureArgument(closure, object.myName);
                if (subclosure == null) {
                    return;
                }
            }
            for (BuildFileKey property : this.myProperties) {
                if (filter != null && !filter.shouldWriteKey(property, object)) continue;
                Object value = object.getValue(property);
                if (value != null) {
                    GradleGroovyFile.setValueStatic((GrStatementOwner)subclosure, property, value, false, null);
                    continue;
                }
                if (GradleGroovyFile.getValueStatic((GrStatementOwner)subclosure, property) == GradleBuildFile.UNRECOGNIZED_VALUE) continue;
                GradleGroovyFile.removeValueStatic((GrStatementOwner)subclosure, property);
            }
            GradleGroovyFile.reformatClosure((GrStatementOwner)subclosure);
        }

        @Override
        @Nullable
        public List<NamedObject> getValues(@NotNull PsiElement statement) {
            if (statement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/android/tools/idea/gradle/parser/NamedObject$Factory", "getValues"));
            }
            if (!(statement instanceof GrMethodCall)) {
                return null;
            }
            GrMethodCall method = (GrMethodCall)statement;
            NamedObject item = new NamedObject(GradleGroovyFile.getMethodCallName((GrMethodCall)statement));
            GrClosableBlock subclosure = GradleGroovyFile.getMethodClosureArgument(method);
            if (subclosure == null) {
                return null;
            }
            for (BuildFileKey property : this.myProperties) {
                Object value = GradleGroovyFile.getValueStatic((GrStatementOwner)subclosure, property);
                if (value == null) continue;
                item.setValue(property, value);
            }
            return ImmutableList.of((Object)item);
        }

        @Override
        protected void removeValue(@NotNull GrStatementOwner closure, @NotNull NamedObject value) {
            if (closure == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "closure", "com/android/tools/idea/gradle/parser/NamedObject$Factory", "removeValue"));
            }
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/gradle/parser/NamedObject$Factory", "removeValue"));
            }
            GrMethodCall call = GradleGroovyFile.getMethodCall(closure, value.getName());
            if (call != null) {
                call.removeStatement();
            }
        }

        @NotNull
        public List<BuildFileKey> getProperties() {
            List<BuildFileKey> list = this.myProperties;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/parser/NamedObject$Factory", "getProperties"));
            }
            return list;
        }
    }
}

