/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.ClientData;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.TimeoutException;
import com.android.tools.idea.run.AndroidRunningState;
import com.android.tools.idea.run.ErrorMatchingReceiver;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.diagnostic.Logger;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AndroidApplicationLauncher {
    private static final Logger LOG = Logger.getInstance(AndroidApplicationLauncher.class);

    public abstract LaunchResult launch(@NotNull AndroidRunningState var1, @NotNull IDevice var2) throws IOException, AdbCommandRejectedException, TimeoutException;

    public boolean isReadyForDebugging(@NotNull ClientData data, @Nullable ProcessHandler processHandler) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/android/tools/idea/run/AndroidApplicationLauncher", "isReadyForDebugging"));
        }
        return data.getDebuggerConnectionStatus() == ClientData.DebuggerStatus.WAITING;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected LaunchResult executeCommand(@NotNull String command, @NotNull AndroidRunningState state, @NotNull IDevice device) throws IOException, AdbCommandRejectedException, TimeoutException {
        boolean success;
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/android/tools/idea/run/AndroidApplicationLauncher", "executeCommand"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/android/tools/idea/run/AndroidApplicationLauncher", "executeCommand"));
        }
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/run/AndroidApplicationLauncher", "executeCommand"));
        }
        ProcessHandler processHandler = state.getProcessHandler();
        ErrorMatchingReceiver receiver = new ErrorMatchingReceiver(state.getStoppedRef());
        while (true) {
            if (state.isStopped()) {
                return LaunchResult.STOP;
            }
            boolean deviceNotResponding = false;
            try {
                state.executeDeviceCommandAndWriteToConsole(device, command, receiver);
            }
            catch (ShellCommandUnresponsiveException e) {
                LOG.info((Throwable)e);
                deviceNotResponding = true;
            }
            if (!deviceNotResponding && receiver.getErrorType() != 2) break;
            processHandler.notifyTextAvailable("Device is not ready. Waiting for 20 sec.\n", ProcessOutputTypes.STDOUT);
            Object object = state.getRunningLock();
            synchronized (object) {
                try {
                    state.getRunningLock().wait(20000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            receiver = new ErrorMatchingReceiver(state.getStoppedRef());
        }
        boolean bl = success = !receiver.hasError();
        if (success) {
            processHandler.notifyTextAvailable(receiver.getOutput().toString(), ProcessOutputTypes.STDOUT);
            return LaunchResult.SUCCESS;
        }
        processHandler.notifyTextAvailable(receiver.getOutput().toString(), ProcessOutputTypes.STDERR);
        return LaunchResult.STOP;
    }

    @NotNull
    protected String getDebugFlags(@NotNull AndroidRunningState state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/android/tools/idea/run/AndroidApplicationLauncher", "getDebugFlags"));
        }
        String string = state.isDebugMode() ? "-D" : "";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/AndroidApplicationLauncher", "getDebugFlags"));
        }
        return string;
    }

    public static enum LaunchResult {
        SUCCESS,
        STOP,
        NOTHING_TO_DO;

    }
}

