/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.activity;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.psi.PsiClass;
import com.intellij.util.xml.DomElement;
import java.util.List;
import org.jetbrains.android.dom.AndroidDomUtil;
import org.jetbrains.android.dom.converters.PackageClassConverter;
import org.jetbrains.android.dom.manifest.Activity;
import org.jetbrains.android.dom.manifest.ActivityAlias;
import org.jetbrains.android.dom.manifest.Application;
import org.jetbrains.android.dom.manifest.IntentFilter;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ActivityLocatorUtils {
    public static boolean shouldUseMergedManifest(@NotNull AndroidFacet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/run/activity/ActivityLocatorUtils", "shouldUseMergedManifest"));
        }
        return facet.requiresAndroidModel() || facet.getProperties().ENABLE_MANIFEST_MERGING;
    }

    public static boolean containsLauncherIntent(@NotNull List<IntentFilter> intentFilters) {
        if (intentFilters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "intentFilters", "com/android/tools/idea/run/activity/ActivityLocatorUtils", "containsLauncherIntent"));
        }
        for (IntentFilter filter : intentFilters) {
            if (!AndroidDomUtil.containsAction(filter, "android.intent.action.MAIN") || !AndroidDomUtil.containsCategory(filter, "android.intent.category.LAUNCHER") && !AndroidDomUtil.containsCategory(filter, "android.intent.category.LEANBACK_LAUNCHER")) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static String getQualifiedName(@NotNull ActivityAlias alias) {
        if (alias == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "alias", "com/android/tools/idea/run/activity/ActivityLocatorUtils", "getQualifiedName"));
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        String name = alias.getName().getStringValue();
        if (name == null) {
            return null;
        }
        int dotIndex = name.indexOf(46);
        if (dotIndex > 0) {
            return name;
        }
        String pkg = null;
        DomElement parent = alias.getParent();
        if (parent instanceof Application && (parent = parent.getParent()) instanceof Manifest) {
            Manifest manifest = (Manifest)parent;
            pkg = manifest.getPackage().getStringValue();
        }
        return pkg == null ? name : pkg + (dotIndex == -1 ? "." : "") + name;
    }

    @Nullable
    public static String getQualifiedName(@NotNull Activity activity) {
        if (activity == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "activity", "com/android/tools/idea/run/activity/ActivityLocatorUtils", "getQualifiedName"));
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        PsiClass c = (PsiClass)activity.getActivityClass().getValue();
        if (c == null) {
            return null;
        }
        return ActivityLocatorUtils.getQualifiedActivityName(c);
    }

    @Nullable
    public static String getQualifiedActivityName(@NotNull PsiClass c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/android/tools/idea/run/activity/ActivityLocatorUtils", "getQualifiedActivityName"));
        }
        return PackageClassConverter.getQualifiedName(c);
    }
}

