/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.structure.services;

import com.google.common.collect.Lists;
import java.io.File;
import java.net.URI;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DeveloperServiceMetadata {
    @NotNull
    private final String myName;
    @NotNull
    private final String myDescription;
    @NotNull
    private final Icon myIcon;
    @NotNull
    private final List<String> myDependencies;
    @NotNull
    private final List<String> myPermissions;
    @NotNull
    private final List<String> myModifiedFiles;
    @Nullable
    private URI myLearnMoreLink;
    @Nullable
    private URI myApiLink;

    public DeveloperServiceMetadata(@NotNull String name, @NotNull String description, @NotNull Icon icon) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/structure/services/DeveloperServiceMetadata", "<init>"));
        }
        if (description == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "description", "com/android/tools/idea/structure/services/DeveloperServiceMetadata", "<init>"));
        }
        if (icon == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "icon", "com/android/tools/idea/structure/services/DeveloperServiceMetadata", "<init>"));
        }
        this.myDependencies = Lists.newArrayList();
        this.myPermissions = Lists.newArrayList();
        this.myModifiedFiles = Lists.newArrayList();
        this.myName = name;
        this.myDescription = description;
        this.myIcon = icon;
    }

    public void addDependency(@NotNull String dependency) {
        if (dependency == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependency", "com/android/tools/idea/structure/services/DeveloperServiceMetadata", "addDependency"));
        }
        this.myDependencies.add(dependency);
    }

    public void addPermission(@NotNull String permission) {
        if (permission == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "permission", "com/android/tools/idea/structure/services/DeveloperServiceMetadata", "addPermission"));
        }
        this.myPermissions.add(permission);
    }

    public void addModifiedFile(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/structure/services/DeveloperServiceMetadata", "addModifiedFile"));
        }
        this.myModifiedFiles.add(file.getName());
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/structure/services/DeveloperServiceMetadata", "getName"));
        }
        return string;
    }

    @NotNull
    public String getDescription() {
        String string = this.myDescription;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/structure/services/DeveloperServiceMetadata", "getDescription"));
        }
        return string;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = this.myIcon;
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/structure/services/DeveloperServiceMetadata", "getIcon"));
        }
        return icon;
    }

    @Nullable
    public URI getLearnMoreLink() {
        return this.myLearnMoreLink;
    }

    public void setLearnMoreLink(@NotNull URI learnMoreLink) {
        if (learnMoreLink == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "learnMoreLink", "com/android/tools/idea/structure/services/DeveloperServiceMetadata", "setLearnMoreLink"));
        }
        this.myLearnMoreLink = learnMoreLink;
    }

    @Nullable
    public URI getApiLink() {
        return this.myApiLink;
    }

    public void setApiLink(@NotNull URI apiLink) {
        if (apiLink == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "apiLink", "com/android/tools/idea/structure/services/DeveloperServiceMetadata", "setApiLink"));
        }
        this.myApiLink = apiLink;
    }

    @NotNull
    public List<String> getDependencies() {
        List<String> list = this.myDependencies;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/structure/services/DeveloperServiceMetadata", "getDependencies"));
        }
        return list;
    }

    @NotNull
    public List<String> getModifiedFiles() {
        List<String> list = this.myModifiedFiles;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/structure/services/DeveloperServiceMetadata", "getModifiedFiles"));
        }
        return list;
    }

    @NotNull
    public List<String> getPermissions() {
        List<String> list = this.myPermissions;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/structure/services/DeveloperServiceMetadata", "getPermissions"));
        }
        return list;
    }
}

