/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.patterns;

import java.io.ByteArrayInputStream;
import java.io.FilePermission;
import java.io.InputStream;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Policy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import junit.framework.TestCase;
import org.languagetool.JLanguageTool;
import org.languagetool.chunking.ChunkTag;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.IncorrectExample;
import org.languagetool.rules.Rule;
import org.languagetool.rules.patterns.AbstractPatternRule;
import org.languagetool.rules.patterns.PatternRule;
import org.languagetool.rules.patterns.PatternRuleLoader;
import org.languagetool.rules.patterns.PatternToken;

public class PatternRuleLoaderTest
extends TestCase {
    public void testGetRules() throws Exception {
        PatternRuleLoader prg = new PatternRuleLoader();
        String name = "/xx/grammar.xml";
        List rules = prg.getRules(JLanguageTool.getDataBroker().getFromRulesDirAsStream("/xx/grammar.xml"), "/xx/grammar.xml");
        PatternRuleLoaderTest.assertTrue((rules.size() >= 30 ? 1 : 0) != 0);
        Rule demoRule1 = this.getRuleById("DEMO_RULE", rules);
        PatternRuleLoaderTest.assertEquals((String)"http://fake-server.org/foo-bar-error-explained", (String)demoRule1.getUrl().toString());
        PatternRuleLoaderTest.assertEquals((String)"[This is <marker>fuu bah</marker>.]", (String)demoRule1.getCorrectExamples().toString());
        List incorrectExamples = demoRule1.getIncorrectExamples();
        PatternRuleLoaderTest.assertEquals((int)1, (int)incorrectExamples.size());
        PatternRuleLoaderTest.assertEquals((String)"This is <marker>foo bar</marker>.", (String)((IncorrectExample)incorrectExamples.get(0)).getExample());
        Rule demoRule2 = this.getRuleById("API_OUTPUT_TEST_RULE", rules);
        PatternRuleLoaderTest.assertNull((Object)demoRule2.getUrl());
        PatternRuleLoaderTest.assertEquals((Object)ITSIssueType.Uncategorized, (Object)demoRule1.getLocQualityIssueType());
        PatternRuleLoaderTest.assertEquals((String)"tag inheritance failed", (Object)ITSIssueType.Addition, (Object)this.getRuleById("TEST_GO", rules).getLocQualityIssueType());
        PatternRuleLoaderTest.assertEquals((String)"tag inheritance overwrite failed", (Object)ITSIssueType.Uncategorized, (Object)this.getRuleById("TEST_PHRASES1", rules).getLocQualityIssueType());
        PatternRuleLoaderTest.assertEquals((String)"tag inheritance overwrite failed", (Object)ITSIssueType.Characters, (Object)this.getRuleById("test_include", rules).getLocQualityIssueType());
        List<Rule> groupRules1 = this.getRulesById("test_spacebefore", rules);
        PatternRuleLoaderTest.assertEquals((String)"tag inheritance form category failed", (Object)ITSIssueType.Addition, (Object)groupRules1.get(0).getLocQualityIssueType());
        PatternRuleLoaderTest.assertEquals((String)"tag inheritance overwrite failed", (Object)ITSIssueType.Duplication, (Object)groupRules1.get(1).getLocQualityIssueType());
        List<Rule> groupRules2 = this.getRulesById("test_unification_with_negation", rules);
        PatternRuleLoaderTest.assertEquals((String)"tag inheritance from rulegroup failed", (Object)ITSIssueType.Grammar, (Object)groupRules2.get(0).getLocQualityIssueType());
        Set<String> categories = this.getCategoryNames(rules);
        PatternRuleLoaderTest.assertEquals((int)3, (int)categories.size());
        PatternRuleLoaderTest.assertTrue((boolean)categories.contains("misc"));
        PatternRuleLoaderTest.assertTrue((boolean)categories.contains("otherCategory"));
        PatternRuleLoaderTest.assertTrue((boolean)categories.contains("Test tokens with min and max attributes"));
        PatternRule demoRuleWithChunk = (PatternRule)this.getRuleById("DEMO_CHUNK_RULE", rules);
        List patternTokens = demoRuleWithChunk.getPatternTokens();
        PatternRuleLoaderTest.assertEquals((int)2, (int)patternTokens.size());
        PatternRuleLoaderTest.assertEquals(null, (String)((PatternToken)patternTokens.get(1)).getPOStag());
        PatternRuleLoaderTest.assertEquals((Object)new ChunkTag("B-NP-singular"), (Object)((PatternToken)patternTokens.get(1)).getChunkTag());
        List<Rule> orRules = this.getRulesById("GROUP_WITH_URL", rules);
        PatternRuleLoaderTest.assertEquals((int)3, (int)orRules.size());
        PatternRuleLoaderTest.assertEquals((String)"http://fake-server.org/rule-group-url", (String)orRules.get(0).getUrl().toString());
        PatternRuleLoaderTest.assertEquals((String)"http://fake-server.org/rule-group-url-overwrite", (String)orRules.get(1).getUrl().toString());
        PatternRuleLoaderTest.assertEquals((String)"http://fake-server.org/rule-group-url", (String)orRules.get(2).getUrl().toString());
        PatternRuleLoaderTest.assertEquals((String)"short message on rule group", (String)((PatternRule)orRules.get(0)).getShortMessage());
        PatternRuleLoaderTest.assertEquals((String)"overwriting short message", (String)((PatternRule)orRules.get(1)).getShortMessage());
        PatternRuleLoaderTest.assertEquals((String)"short message on rule group", (String)((PatternRule)orRules.get(2)).getShortMessage());
        List<Rule> orRules2 = this.getRulesById("OR_GROUPS", rules);
        for (Rule rule : orRules2) {
            PatternRuleLoaderTest.assertNull((String)"http://fake-server.org/rule-group-url", (Object)rule.getUrl());
        }
        Rule nextRule = this.getRuleById("DEMO_CHUNK_RULE", rules);
        PatternRuleLoaderTest.assertNull((String)"http://fake-server.org/rule-group-url", (Object)nextRule.getUrl());
    }

    public void testPermissionManager() throws Exception {
        Policy.setPolicy(new MyPolicy());
        System.setSecurityManager(new SecurityManager());
        try {
            PatternRuleLoader loader = new PatternRuleLoader();
            loader.getRules((InputStream)new ByteArrayInputStream("<rules lang='xx'></rules>".getBytes("utf-8")), "fakeName");
        }
        finally {
            System.setSecurityManager(null);
        }
    }

    private Set<String> getCategoryNames(List<AbstractPatternRule> rules) {
        HashSet<String> categories = new HashSet<String>();
        for (AbstractPatternRule rule : rules) {
            categories.add(rule.getCategory().getName());
        }
        return categories;
    }

    private Rule getRuleById(String id, List<AbstractPatternRule> rules) {
        for (Rule rule : rules) {
            if (!rule.getId().equals(id)) continue;
            return rule;
        }
        throw new RuntimeException("No rule found for id '" + id + "'");
    }

    private List<Rule> getRulesById(String id, List<AbstractPatternRule> rules) {
        ArrayList<Rule> result = new ArrayList<Rule>();
        for (Rule rule : rules) {
            if (!rule.getId().equals(id)) continue;
            result.add(rule);
        }
        return result;
    }

    static class MyPermissionCollection
    extends PermissionCollection {
        private final List<Permission> perms = new ArrayList<Permission>();

        MyPermissionCollection() {
        }

        @Override
        public void add(Permission p) {
            this.perms.add(p);
        }

        @Override
        public boolean implies(Permission p) {
            for (Permission perm : this.perms) {
                if (!perm.implies(p)) continue;
                return true;
            }
            return false;
        }

        @Override
        public Enumeration<Permission> elements() {
            return Collections.enumeration(this.perms);
        }

        @Override
        public boolean isReadOnly() {
            return false;
        }
    }

    static class MyPolicy
    extends Policy {
        MyPolicy() {
        }

        @Override
        public PermissionCollection getPermissions(CodeSource codesource) {
            MyPermissionCollection perms = new MyPermissionCollection();
            ((PermissionCollection)perms).add(new RuntimePermission("setIO"));
            ((PermissionCollection)perms).add(new RuntimePermission("setSecurityManager"));
            ((PermissionCollection)perms).add(new FilePermission("<<ALL FILES>>", "read"));
            return perms;
        }
    }
}

