/*
 * Decompiled with CFR 0.152.
 */
package morfologik.tools;

import java.io.PrintWriter;
import java.util.ArrayDeque;
import java.util.Locale;
import morfologik.fsa.IMessageLogger;

public class WriterMessageLogger
implements IMessageLogger {
    private static final long world = System.currentTimeMillis();
    private boolean indent;
    private ArrayDeque<Part> parts = new ArrayDeque();
    private final PrintWriter writer;

    public WriterMessageLogger(PrintWriter w) {
        this.writer = w;
    }

    public void log(String msg) {
        this.cancelIndent();
        this.writer.println(msg);
        this.writer.flush();
    }

    public void log(String header, Object v) {
        this.cancelIndent();
        if (v instanceof Integer || v instanceof Long) {
            this.writer.println(String.format(Locale.ENGLISH, "%-30s  %,11d", header, v));
        } else {
            this.writer.println(String.format(Locale.ENGLISH, "%-30s  %11s", header, v.toString()));
        }
        this.writer.flush();
    }

    public void startPart(String header) {
        this.cancelIndent();
        Part p = new Part(header, System.currentTimeMillis());
        this.parts.addLast(p);
        this.writer.print(String.format(Locale.ENGLISH, "%-30s", p.name + "..."));
        this.writer.flush();
        this.indent = true;
    }

    public void endPart() {
        long now = System.currentTimeMillis();
        Part p = this.parts.removeLast();
        if (!this.indent) {
            this.writer.print(String.format(Locale.ENGLISH, "%-30s", p.name + "..."));
        }
        this.writer.println(String.format(Locale.ENGLISH, "%13.2f sec.  [%6.2f sec.]", (double)(now - p.start) / 1000.0, (double)(now - world) / 1000.0));
        this.writer.flush();
        this.indent = false;
    }

    private void cancelIndent() {
        if (this.indent) {
            System.err.println();
        }
        this.indent = false;
    }

    private static class Part {
        final String name;
        final long start;

        Part(String name, long start) {
            this.name = name;
            this.start = start;
        }
    }
}

