/*
 * Decompiled with CFR 0.152.
 */
package be.frma.langguess;

import be.frma.langguess.IOUtils;
import com.cybozu.labs.langdetect.util.LangProfile;
import com.cybozu.labs.langdetect.util.Util;
import com.optimaize.langdetect.text.CommonTextObjectFactories;
import com.optimaize.langdetect.text.TextObject;
import com.optimaize.langdetect.text.TextObjectFactory;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.zip.GZIPInputStream;

public class GenProfile {
    private static final TextObjectFactory textObjectFactory = CommonTextObjectFactories.forIndexing();

    public static LangProfile generate(String lang, File textFile) {
        LangProfile profile = new LangProfile(lang);
        FilterInputStream is = null;
        try {
            String line;
            is = new BufferedInputStream(new FileInputStream(textFile));
            if (textFile.getName().endsWith(".gz")) {
                is = new GZIPInputStream(is);
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)is, Charset.forName("UTF-8")));
            while ((line = reader.readLine()) != null) {
                TextObject textObject = textObjectFactory.forText(" " + line + " ");
                Util.addCharSequence(profile, textObject);
            }
        }
        catch (IOException e) {
            try {
                throw new RuntimeException("Can't open training database file '" + textFile.getName() + "'", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(is);
        return profile;
    }
}

