/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient.contrib.ssl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.ssl.SSLSocketFactory;
import org.apache.commons.httpclient.ConnectTimeoutException;
import org.apache.commons.httpclient.params.HttpConnectionParams;
import org.apache.commons.httpclient.protocol.SecureProtocolSocketFactory;

public class SocketFactoryWrapper
implements SecureProtocolSocketFactory {
    private SSLSocketFactory socketFactory;

    public SocketFactoryWrapper(SSLSocketFactory socketFactory) {
        this.socketFactory = socketFactory;
    }

    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        return this.socketFactory.createSocket(host, port);
    }

    public Socket createSocket(String host, int port, InetAddress localAddress, int localPort) throws IOException, UnknownHostException {
        return this.socketFactory.createSocket(host, port, localAddress, localPort);
    }

    public Socket createSocket(String host, int port, InetAddress localAddress, int localPort, HttpConnectionParams params) throws IOException, UnknownHostException, ConnectTimeoutException {
        Socket rval;
        if (params == null) {
            throw new IllegalArgumentException("Parameters may not be null");
        }
        int timeout = params.getConnectionTimeout();
        if (timeout == 0) {
            rval = this.socketFactory.createSocket(host, port, localAddress, localPort);
        } else {
            rval = this.socketFactory.createSocket();
            InetSocketAddress localaddr = new InetSocketAddress(localAddress, localPort);
            InetSocketAddress remoteaddr = new InetSocketAddress(host, port);
            rval.bind(localaddr);
            rval.connect(remoteaddr, timeout);
        }
        return rval;
    }

    public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException, UnknownHostException {
        return this.socketFactory.createSocket(socket, host, port, autoClose);
    }
}

