/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.server;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.josm.data.preferences.BooleanProperty;
import org.openstreetmap.josm.data.preferences.CollectionProperty;
import org.openstreetmap.josm.data.preferences.StringProperty;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceSettingFactory;
import org.openstreetmap.josm.gui.preferences.PreferenceTabbedPane;
import org.openstreetmap.josm.gui.preferences.SubPreferenceSetting;
import org.openstreetmap.josm.gui.preferences.TabPreferenceSetting;
import org.openstreetmap.josm.gui.widgets.HistoryComboBox;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class OverpassServerPreference
implements SubPreferenceSetting {
    private static final StringProperty OVERPASS_SERVER = new StringProperty("download.overpass.server", "http://overpass-api.de/api/");
    private static final CollectionProperty OVERPASS_SERVER_HISTORY = new CollectionProperty("download.overpass.servers", (Collection<String>)Arrays.asList("http://overpass-api.de/api/", "http://overpass.osm.rambler.ru/cgi/"));
    private static final BooleanProperty FOR_MULTI_FETCH = new BooleanProperty("download.overpass.for-multi-fetch", false);
    private HistoryComboBox overpassServer = new HistoryComboBox();
    private final JCheckBox forMultiFetch = new JCheckBox(I18n.tr("Use Overpass server for object downloads", new Object[0]));

    @Override
    public TabPreferenceSetting getTabPreferenceSetting(PreferenceTabbedPane preferenceTabbedPane) {
        return preferenceTabbedPane.getServerPreference();
    }

    @Override
    public void addGui(PreferenceTabbedPane preferenceTabbedPane) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel.add((Component)new JLabel(I18n.tr("Overpass server: ", new Object[0])), GBC.std().insets(5, 5, 5, 5));
        jPanel.add((Component)this.overpassServer, GBC.eop().fill(2));
        this.overpassServer.setPossibleItems((Collection<String>)OVERPASS_SERVER_HISTORY.get());
        this.overpassServer.setText(OVERPASS_SERVER.get());
        jPanel.add((Component)this.forMultiFetch, GBC.eop());
        this.forMultiFetch.setSelected(OverpassServerPreference.useForMultiFetch());
        jPanel.add(Box.createVerticalGlue(), GBC.eol().fill());
        this.getTabPreferenceSetting(preferenceTabbedPane).addSubTab(this, I18n.tr("Overpass server", new Object[0]), jPanel);
    }

    @Override
    public boolean ok() {
        OVERPASS_SERVER.put(this.overpassServer.getText());
        OVERPASS_SERVER_HISTORY.put((Collection<String>)this.overpassServer.getHistory());
        FOR_MULTI_FETCH.put(this.forMultiFetch.isSelected());
        return false;
    }

    @Override
    public boolean isExpert() {
        return true;
    }

    public static String getOverpassServer() {
        return OVERPASS_SERVER.get();
    }

    public static boolean useForMultiFetch() {
        return FOR_MULTI_FETCH.get();
    }

    public static class Factory
    implements PreferenceSettingFactory {
        @Override
        public PreferenceSetting createPreferenceSetting() {
            return new OverpassServerPreference();
        }
    }
}

