// Generated by IcedCoffeeScript 1.7.1-c
(function() {
  var ArgumentParser, Base, Command, PackageJson, User, add_option_dict, env, format_fingerprint, iced, log, make_esc, session, __iced_k, __iced_k_noop,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  iced = require('iced-runtime').iced;
  __iced_k = __iced_k_noop = function() {};

  Base = require('./base').Base;

  log = require('../log');

  ArgumentParser = require('argparse').ArgumentParser;

  add_option_dict = require('./argparse').add_option_dict;

  PackageJson = require('../package').PackageJson;

  session = require('../session').session;

  make_esc = require('iced-error').make_esc;

  env = require('../env').env;

  log = require('../log');

  User = require('../user').User;

  format_fingerprint = require('pgp-utils').util.format_fingerprint;

  exports.Command = Command = (function(_super) {
    __extends(Command, _super);

    function Command() {
      return Command.__super__.constructor.apply(this, arguments);
    }

    Command.prototype.OPTS = {
      T: {
        alias: 'text',
        action: 'storeTrue',
        help: 'output in text format; default is JSON'
      }
    };

    Command.prototype.use_session = function() {
      return true;
    };

    Command.prototype.add_subcommand_parser = function(scp) {
      var name, opts, sub;
      opts = {
        help: "print current status"
      };
      name = "status";
      sub = scp.addParser(name, opts);
      add_option_dict(sub, this.OPTS);
      return [name];
    };

    Command.prototype.run = function(cb) {
      var d, esc, logged_in, me, obj, rp, un, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      esc = make_esc(cb, "Command::run");
      (function(_this) {
        return (function(__iced_k) {
          if ((un = env().get_username()) != null) {
            (function(__iced_k) {
              __iced_deferrals = new iced.Deferrals(__iced_k, {
                parent: ___iced_passed_deferral,
                filename: "/home/jacko/node-client/src/command/status.iced",
                funcname: "Command.run"
              });
              session.check(esc(__iced_deferrals.defer({
                assign_fn: (function() {
                  return function() {
                    return logged_in = arguments[0];
                  };
                })(),
                lineno: 44
              })));
              __iced_deferrals._fulfill();
            })(function() {
              (function(__iced_k) {
                __iced_deferrals = new iced.Deferrals(__iced_k, {
                  parent: ___iced_passed_deferral,
                  filename: "/home/jacko/node-client/src/command/status.iced",
                  funcname: "Command.run"
                });
                User.load_me({
                  secret: false
                }, esc(__iced_deferrals.defer({
                  assign_fn: (function() {
                    return function() {
                      return me = arguments[0];
                    };
                  })(),
                  lineno: 45
                })));
                __iced_deferrals._fulfill();
              })(function() {
                var _ref;
                obj = {
                  status: {
                    configured: true,
                    logged_in: logged_in
                  },
                  user: {
                    name: un
                  }
                };
                return __iced_k(typeof me !== "undefined" && me !== null ? (obj.user.key = {
                  key_id: (_ref = me.key_id_64()) != null ? _ref.toUpperCase() : void 0,
                  fingerprint: me.fingerprint() != null ? format_fingerprint(me.fingerprint(true)) : void 0
                }, (rp = me.list_remote_proofs()) != null ? obj.user.proofs = rp : void 0, (d = me.list_cryptocurrency_addresses()) != null ? obj.user.cryptocurrency = d : void 0) : void 0);
              });
            });
          } else {
            return __iced_k(obj = {
              status: {
                configured: false
              }
            });
          }
        });
      })(this)((function(_this) {
        return function() {
          _this.output(obj);
          return cb(null);
        };
      })(this));
    };

    Command.prototype.output_text = function(obj) {
      var ct, k, ko, rp, v, _results;
      if (obj.status.configured) {
        log.console.log("configged as " + obj.user.name);
        log.console.log("  * " + (obj.status.logged_in ? '' : 'NOT ') + "logged in");
        if ((ko = obj.user.key) != null) {
          log.console.log("  * Key ID: " + ko.key_id);
          log.console.log("  * Fingerprint: " + ko.fingerprint);
        }
        if ((rp = obj.user.proofs) != null) {
          log.console.log("Remote proofs:");
          for (k in rp) {
            v = rp[k];
            log.console.log("  * " + k + ": " + v);
          }
        }
        if ((ct = obj.user.cryptocurrency) != null) {
          log.console.log("Cryptocurrency Addresses:");
          _results = [];
          for (k in ct) {
            v = ct[k];
            _results.push(log.console.log("  * " + k + ": " + v));
          }
          return _results;
        }
      } else {
        return log.error("Not configured");
      }
    };

    Command.prototype.output = function(obj) {
      if (this.argv.text) {
        return this.output_text(obj);
      } else {
        return log.console.log(JSON.stringify(obj, null, "  "));
      }
    };

    return Command;

  })(Base);

}).call(this);
