// Generated by IcedCoffeeScript 1.8.0-d
(function() {
  var Base, TweetNaCl, b2u, bufeq_secure, u2b, _ref,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  bufeq_secure = require('./util').bufeq_secure;

  _ref = require('./base'), b2u = _ref.b2u, u2b = _ref.u2b, Base = _ref.Base;

  exports.TweetNaCl = TweetNaCl = (function(_super) {
    __extends(TweetNaCl, _super);

    function TweetNaCl() {
      return TweetNaCl.__super__.constructor.apply(this, arguments);
    }

    TweetNaCl.prototype.verify = function(_arg) {
      var detached, err, payload, r_payload, sig;
      payload = _arg.payload, sig = _arg.sig, detached = _arg.detached;
      err = null;
      if (detached) {
        if (payload == null) {
          payload = new Buffer([]);
        }
        if (!this.lib.js.sign.detached.verify(b2u(payload), b2u(sig), b2u(this.publicKey))) {
          err = new Error("signature didn't verify");
        }
      } else if ((r_payload = this.lib.js.sign.open(b2u(sig), b2u(this.publicKey))) == null) {
        err = new Error("signature didn't verify");
      } else if ((r_payload = u2b(r_payload)) == null) {
        err = new Error("failed to convert from a Uint8Array to a buffer");
      } else if ((payload != null) && !bufeq_secure(r_payload, payload)) {
        err = new Error("got unexpected payload");
      } else {
        payload = r_payload;
      }
      if (err != null) {
        payload = null;
      }
      return [err, payload];
    };

    TweetNaCl.prototype.sign = function(_arg) {
      var detached, f, payload;
      payload = _arg.payload, detached = _arg.detached;
      f = detached ? this.lib.js.sign.detached : this.lib.js.sign;
      return u2b(f(b2u(payload), b2u(this.secretKey)));
    };

    return TweetNaCl;

  })(Base);

}).call(this);
