/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tk.quantum;

import com.sun.glass.ui.Application;
import com.sun.glass.ui.MenuBar;
import com.sun.glass.ui.Screen;
import com.sun.glass.ui.View;
import com.sun.glass.ui.Window;
import com.sun.javafx.PlatformUtil;
import com.sun.javafx.iio.common.PushbroomScaler;
import com.sun.javafx.iio.common.ScalerFactory;
import com.sun.javafx.tk.FocusCause;
import com.sun.javafx.tk.TKScene;
import com.sun.javafx.tk.TKStage;
import com.sun.javafx.tk.quantum.AbstractPainter;
import com.sun.javafx.tk.quantum.GlassAppletWindow;
import com.sun.javafx.tk.quantum.GlassScene;
import com.sun.javafx.tk.quantum.GlassStage;
import com.sun.javafx.tk.quantum.GlassSystemMenu;
import com.sun.javafx.tk.quantum.GlassWindowEventHandler;
import com.sun.javafx.tk.quantum.OverlayWarning;
import com.sun.javafx.tk.quantum.PixelUtils;
import com.sun.javafx.tk.quantum.PrismPen;
import com.sun.javafx.tk.quantum.QuantumRenderer;
import com.sun.javafx.tk.quantum.ViewPainter;
import com.sun.javafx.tk.quantum.ViewScene;
import com.sun.prism.Image;
import com.sun.prism.PixelFormat;
import java.nio.ByteBuffer;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.util.List;
import javafx.stage.Modality;
import javafx.stage.StageStyle;

public class WindowStage
extends GlassStage {
    PushbroomScaler scaler;
    StageStyle style;
    Window platformWindow;
    MenuBar menubar;
    String title;
    int minWidth = 0;
    int minHeight = 0;
    int maxWidth = Integer.MAX_VALUE;
    int maxHeight = Integer.MAX_VALUE;
    private OverlayWarning warning = null;
    private boolean transparent = false;
    private boolean isPrimaryStage = false;
    private boolean isAppletStage = false;
    private boolean isInFullScreen = false;
    private TKStage owner = null;
    private Window ownerWindow = null;
    private Modality modality = Modality.NONE;
    private boolean inEventHandler = false;
    private static final QuantumRenderer renderer = QuantumRenderer.getInstance();
    private static WindowStage activeFullScreenWindow = null;
    private static GlassAppletWindow appletWindow = null;
    private boolean trustedFullScreen = false;
    private static final Permission fullScreenPermission = new AllPermission();
    private boolean fullScreenFromUserEvent = false;
    private boolean platformWindowClosed = false;

    static void setAppletWindow(GlassAppletWindow glassAppletWindow) {
        appletWindow = glassAppletWindow;
    }

    static GlassAppletWindow getAppletWindow() {
        return appletWindow;
    }

    public WindowStage(boolean bl) {
        this(bl, StageStyle.DECORATED, false, Modality.NONE, null);
    }

    public WindowStage(boolean bl, StageStyle stageStyle) {
        this(bl, stageStyle, false, Modality.NONE, null);
    }

    public final WindowStage init(GlassSystemMenu glassSystemMenu) {
        this.initPlatformWindow();
        this.platformWindow.setEventHandler(new GlassWindowEventHandler(this));
        this.platformWindow.setMinimumSize(this.minWidth, this.minHeight);
        this.platformWindow.setMaximumSize(this.maxWidth, this.maxHeight);
        if (glassSystemMenu.isSupported()) {
            glassSystemMenu.createMenuBar();
            this.platformWindow.setMenuBar(glassSystemMenu.getMenuBar());
        }
        return this;
    }

    public WindowStage(boolean bl, StageStyle stageStyle, boolean bl2, Modality modality, TKStage tKStage) {
        super(bl);
        this.transparent = stageStyle == StageStyle.TRANSPARENT;
        this.style = stageStyle;
        this.isPrimaryStage = bl2;
        if (null != appletWindow && bl2) {
            this.isAppletStage = true;
        }
        if (tKStage == null) {
            if (modality == Modality.WINDOW_MODAL) {
                modality = Modality.NONE;
            }
        } else if (tKStage instanceof WindowStage) {
            this.ownerWindow = ((WindowStage)tKStage).platformWindow;
        } else {
            System.err.println("Error: Unsupported type of owner " + tKStage);
        }
        this.owner = tKStage;
        this.modality = modality;
    }

    protected void initPlatformWindow() {
        int n = 0;
        Application application = Application.GetApplication();
        if (this.isPrimaryStage && null != appletWindow) {
            this.platformWindow = application.createWindow(appletWindow.getGlassWindow().getNativeWindow());
        } else if (this.style == StageStyle.DECORATED) {
            n = 113;
            this.platformWindow = application.createWindow(this.ownerWindow, Screen.getMainScreen(), n);
            this.platformWindow.setResizable(true);
        } else if (this.style == StageStyle.UTILITY) {
            n = 21;
            this.platformWindow = application.createWindow(this.ownerWindow, Screen.getMainScreen(), n);
        } else {
            n = (this.transparent ? 2 : 0) | 0x10;
            this.platformWindow = application.createWindow(this.ownerWindow, Screen.getMainScreen(), n);
        }
    }

    protected Window getPlatformWindow() {
        return this.platformWindow;
    }

    protected TKStage getOwner() {
        return this.owner;
    }

    protected ViewScene getViewScene() {
        return (ViewScene)this.scene;
    }

    StageStyle getStyle() {
        return this.style;
    }

    @Override
    public TKScene createTKScene(boolean bl) {
        return new ViewScene(this.verbose, bl);
    }

    @Override
    public void setScene(TKScene tKScene) {
        Object object;
        GlassScene glassScene = this.scene;
        super.setScene(tKScene);
        if (this.scene != null) {
            object = this.getViewScene().getPlatformView();
            this.platformWindow.setView((View)object);
            this.requestFocus();
            this.applyFullScreen();
        } else {
            this.platformWindow.setView(null);
        }
        if (glassScene != null) {
            object = ((ViewScene)glassScene).getPen();
            ViewPainter viewPainter = ((PrismPen)object).getPainter();
            renderer.disposePresentable(viewPainter.presentable);
        }
    }

    @Override
    public void setBounds(float f, float f2, boolean bl, boolean bl2, float f3, float f4, float f5, float f6, float f7, float f8) {
        if (this.isAppletStage || Float.isNaN(f) || Float.isNaN(f2)) {
            bl2 = false;
            bl = false;
        }
        this.platformWindow.setBounds((int)f, (int)f2, bl, bl2, (int)f3, (int)f4, (int)f5, (int)f6, f7, f8);
    }

    @Override
    public void setMinimumSize(int n, int n2) {
        if (this.minWidth != n || this.minHeight != n2) {
            this.minWidth = n;
            this.minHeight = n2;
            if (this.platformWindow != null) {
                this.platformWindow.setMinimumSize(n, n2);
            }
        }
    }

    @Override
    public void setMaximumSize(int n, int n2) {
        if (this.maxWidth != n || this.maxHeight != n2) {
            this.maxWidth = n;
            this.maxHeight = n2;
            if (this.platformWindow != null) {
                this.platformWindow.setMaximumSize(n, n2);
            }
        }
    }

    @Override
    public void setIcons(List list) {
        int n;
        int n2;
        Object object;
        int n3 = 32;
        int n4 = 32;
        if (PlatformUtil.isMac()) {
            n3 = 128;
            n4 = 128;
        } else if (PlatformUtil.isWindows()) {
            n3 = 32;
            n4 = 32;
        } else if (PlatformUtil.isLinux()) {
            n3 = 128;
            n4 = 128;
        }
        if (list == null || list.size() < 1) {
            return;
        }
        int n5 = this.platformWindow.getWidth();
        int n6 = this.platformWindow.getHeight();
        Object object2 = null;
        double d = 3.0;
        for (int i = 0; i < list.size(); ++i) {
            double d2;
            int n7;
            int n8;
            object = (Image)list.get(i);
            if (object == null || ((Image)object).getPixelFormat() != PixelFormat.BYTE_RGB && ((Image)object).getPixelFormat() != PixelFormat.BYTE_BGRA_PRE && ((Image)object).getPixelFormat() != PixelFormat.BYTE_GRAY) continue;
            n2 = ((Image)object).getWidth();
            n = ((Image)object).getHeight();
            if (n2 <= 0 || n <= 0) continue;
            double d3 = Math.min((double)n4 / (double)n2, (double)n3 / (double)n);
            double d4 = 1.0;
            if (d3 >= 2.0) {
                d3 = Math.floor(d3);
                n8 = n2 * (int)d3;
                n7 = n * (int)d3;
                d4 = 1.0 - 0.5 / d3;
            } else if (d3 >= 1.0) {
                d3 = 1.0;
                n8 = n2;
                n7 = n;
                d4 = 0.0;
            } else if (d3 >= 0.75) {
                d3 = 0.75;
                n8 = n2 * 3 / 4;
                n7 = n * 3 / 4;
                d4 = 0.3;
            } else if (d3 >= 0.6666) {
                d3 = 0.6666;
                n8 = n2 * 2 / 3;
                n7 = n * 2 / 3;
                d4 = 0.33;
            } else {
                d2 = Math.ceil(1.0 / d3);
                d3 = 1.0 / d2;
                n8 = (int)Math.round((double)n2 / d2);
                n7 = (int)Math.round((double)n / d2);
                d4 = 1.0 - 1.0 / d2;
            }
            d2 = ((double)n5 - (double)n8) / (double)n5 + ((double)n6 - (double)n7) / (double)n6 + d4;
            if (d2 < d) {
                object2 = object;
            }
            if (d2 == 0.0) break;
        }
        if (object2 == null) {
            return;
        }
        this.scaler = ScalerFactory.createScaler(((Image)object2).getWidth(), ((Image)object2).getHeight(), ((Image)object2).getBytesPerPixelUnit(), n4, n3, true);
        ByteBuffer byteBuffer = (ByteBuffer)((Image)object2).getPixelBuffer();
        object = new byte[byteBuffer.limit()];
        n2 = ((Image)object2).getHeight();
        for (n = 0; n < n2; ++n) {
            byteBuffer.position(n * ((Image)object2).getScanlineStride());
            byteBuffer.get((byte[])object, 0, ((Image)object2).getScanlineStride());
            if (this.scaler == null) continue;
            this.scaler.putSourceScanline((byte[])object, 0);
        }
        byteBuffer.rewind();
        Image image = ((Image)object2).iconify(this.scaler.getDestination(), n4, n3);
        this.platformWindow.setIcon(PixelUtils.imageToPixels(image));
    }

    @Override
    public void setTitle(String string) {
        if (this.platformWindow == null) {
            this.title = string;
        } else {
            this.platformWindow.setTitle(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setVisible(boolean bl) {
        if (this.platformWindow.supportsPlatformModality()) {
            if (bl) {
                if (this.modality == Modality.WINDOW_MODAL) {
                    assert (this.owner != null);
                    ((WindowStage)this.owner).setEnabled(false);
                    this.platformWindow.enterModal(this.ownerWindow);
                } else if (this.modality == Modality.APPLICATION_MODAL) {
                    this.windowsSetEnabled(false);
                    this.platformWindow.enterModal();
                }
            } else if (this.modality == Modality.WINDOW_MODAL) {
                ((WindowStage)this.owner).setEnabled(true);
                this.platformWindow.exitModal();
            } else if (this.modality == Modality.APPLICATION_MODAL) {
                this.windowsSetEnabled(true);
                this.platformWindow.exitModal();
            } else if (this.owner != null) {
                ((WindowStage)this.owner).requestToFront();
            }
            try {
                AbstractPainter.renderLock.lock();
                this.platformWindow.setVisible(bl);
                super.setVisible(bl);
            }
            finally {
                AbstractPainter.renderLock.unlock();
            }
        }
        if (!bl) {
            if (this.modality == Modality.WINDOW_MODAL) {
                assert (this.owner != null);
                ((WindowStage)this.owner).setEnabled(true);
            } else if (this.modality == Modality.APPLICATION_MODAL) {
                this.windowsSetEnabled(true);
            } else if (this.owner != null) {
                WindowStage windowStage = (WindowStage)this.owner;
                windowStage.requestToFront();
            }
        }
        try {
            AbstractPainter.renderLock.lock();
            this.platformWindow.setVisible(bl);
            super.setVisible(bl);
        }
        finally {
            AbstractPainter.renderLock.unlock();
        }
        if (bl) {
            if (this.modality == Modality.WINDOW_MODAL) {
                assert (this.owner != null);
                ((WindowStage)this.owner).setEnabled(false);
            } else if (this.modality == Modality.APPLICATION_MODAL) {
                this.windowsSetEnabled(false);
            }
            if (this.isAppletStage && null != appletWindow) {
                appletWindow.assertStageOrder();
            }
        }
        this.applyFullScreen();
    }

    @Override
    boolean isVisible() {
        return this.platformWindow.isVisible();
    }

    @Override
    public void setOpacity(float f) {
        this.platformWindow.setAlpha(f);
    }

    public boolean needsUpdateWindow() {
        return this.transparent && Application.GetApplication().shouldUpdateWindow();
    }

    @Override
    public void setIconified(boolean bl) {
        if (this.platformWindow.isMinimized() && bl || !this.platformWindow.isMinimized() && !bl) {
            return;
        }
        if (this.platformWindow.minimize(bl) != bl) {
            throw new RuntimeException("WindowStage.setIconified failed");
        }
    }

    @Override
    public void setResizable(boolean bl) {
        this.platformWindow.setResizable(bl);
    }

    private void initTrustedFullScreen() {
        this.trustedFullScreen = this.hasPermission(fullScreenPermission);
    }

    boolean isTrustedFullScreen() {
        return this.trustedFullScreen;
    }

    void exitFullScreen() {
        this.setFullScreen(false);
    }

    private boolean hasPermission(Permission permission) {
        try {
            if (System.getSecurityManager() != null) {
                this.getAccessControlContext().checkPermission(permission);
            }
            return true;
        }
        catch (AccessControlException accessControlException) {
            return false;
        }
    }

    private void applyFullScreen() {
        View view = this.platformWindow.getView();
        if (this.isVisible() && view != null && view.isInFullscreen() != this.isInFullScreen) {
            if (this.isInFullScreen) {
                this.initTrustedFullScreen();
                if (!this.trustedFullScreen && !this.fullScreenFromUserEvent) {
                    this.exitFullScreen();
                } else {
                    view.enterFullscreen(false, false, false);
                    if (this.warning != null && this.warning.inWarningTransition()) {
                        this.warning.setView(this.getViewScene());
                    } else if (this.warning == null) {
                        this.warning = new OverlayWarning(this.getViewScene());
                        this.warning.warn();
                    }
                }
            } else {
                if (this.warning != null) {
                    this.warning.cancel();
                    this.warning = null;
                }
                view.exitFullscreen(false);
            }
            this.fullScreenFromUserEvent = false;
        } else if (!this.isVisible() && this.warning != null) {
            this.warning.cancel();
            this.warning = null;
        }
    }

    @Override
    public void setFullScreen(boolean bl) {
        if (this.isInFullScreen == bl) {
            return;
        }
        if (this.isInEventHandler()) {
            this.fullScreenFromUserEvent = true;
        }
        if (bl && activeFullScreenWindow != null) {
            activeFullScreenWindow.setFullScreen(false);
        }
        this.isInFullScreen = bl;
        this.applyFullScreen();
        if (bl) {
            activeFullScreenWindow = this;
        }
    }

    void fullscreenChanged(final boolean bl) {
        if (bl) {
            this.initTrustedFullScreen();
        }
        if (!bl && this == activeFullScreenWindow) {
            activeFullScreenWindow = null;
        }
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                if (WindowStage.this.stageListener != null) {
                    WindowStage.this.stageListener.changedFullscreen(bl);
                }
                return null;
            }
        }, this.getAccessControlContext());
    }

    @Override
    public void toBack() {
        this.platformWindow.toBack();
        if (this.isAppletStage && null != appletWindow) {
            appletWindow.assertStageOrder();
        }
    }

    @Override
    public void toFront() {
        this.platformWindow.requestFocus();
        this.platformWindow.toFront();
        if (this.isAppletStage && null != appletWindow) {
            appletWindow.assertStageOrder();
        }
    }

    @Override
    public void close() {
        super.close();
        if (!this.platformWindowClosed) {
            this.platformWindow.close();
        }
    }

    @Override
    protected void setPlatformWindowClosed() {
        this.platformWindowClosed = true;
    }

    @Override
    public boolean isTopLevel() {
        return this.owner == null;
    }

    @Override
    public boolean grabFocus() {
        return this.platformWindow.grabFocus();
    }

    @Override
    public void ungrabFocus() {
        this.platformWindow.ungrabFocus();
    }

    @Override
    public void requestFocus(FocusCause focusCause) {
        switch (focusCause) {
            case TRAVERSED_FORWARD: {
                this.platformWindow.requestFocus(543);
                break;
            }
            case TRAVERSED_BACKWARD: {
                this.platformWindow.requestFocus(544);
                break;
            }
            case ACTIVATED: {
                this.platformWindow.requestFocus(542);
                break;
            }
            case DEACTIVATED: {
                this.platformWindow.requestFocus(541);
            }
        }
    }

    @Override
    protected void setPlatformEnabled(boolean bl) {
        if (!this.platformWindowClosed) {
            this.platformWindow.setEnabled(bl);
        }
        if (!bl) {
            GlassStage.removeActiveWindow(this);
        }
    }

    void setEnabled(boolean bl) {
        if (this.owner != null && this.owner instanceof WindowStage) {
            ((WindowStage)this.owner).setEnabled(bl);
        }
        if (bl && this.platformWindow.isClosed()) {
            return;
        }
        this.setPlatformEnabled(bl);
        if (bl) {
            this.requestToFront();
            if (this.isAppletStage && null != appletWindow) {
                appletWindow.assertStageOrder();
            }
        }
    }

    void windowsSetEnabled(boolean bl) {
        for (GlassStage glassStage : windows) {
            if (glassStage == this) continue;
            glassStage.setPlatformEnabled(bl);
            if (!bl) continue;
            glassStage.requestToFront();
        }
    }

    @Override
    protected void requestToFront() {
        this.platformWindow.toFront();
        this.platformWindow.requestFocus();
    }

    public void setInEventHandler(boolean bl) {
        this.inEventHandler = bl;
    }

    public boolean isInEventHandler() {
        return this.inEventHandler;
    }
}

