/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.jbrofuzz;

import java.util.prefs.Preferences;
import javax.swing.SwingUtilities;
import org.owasp.jbrofuzz.core.Database;
import org.owasp.jbrofuzz.io.CommandLineInterpreter;
import org.owasp.jbrofuzz.io.StorageHandler;
import org.owasp.jbrofuzz.io.StorageInterface;
import org.owasp.jbrofuzz.ui.JBroFuzzWindow;
import org.owasp.jbrofuzz.version.JBroFuzzFormat;

public class JBroFuzz {
    private final StorageHandler mHandler;
    private final JBroFuzzFormat mFormat;
    private final JBroFuzzWindow mWindow;
    private Database mDatabase = new Database();
    public static final Preferences PREFS = Preferences.userRoot().node("owasp/jbrofuzz");

    public static void main(String[] args) {
        CommandLineInterpreter cli = new CommandLineInterpreter();
        try {
            if (cli.process(args) <= 0) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        new JBroFuzz();
                    }
                });
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public JBroFuzz() {
        this.mHandler = new StorageHandler();
        this.mFormat = new JBroFuzzFormat();
        this.mWindow = new JBroFuzzWindow(this);
    }

    public Database getDatabase() {
        return this.mDatabase;
    }

    public void setDatabase(Database db) {
        this.mDatabase = db;
    }

    public JBroFuzzFormat getFormat() {
        return this.mFormat;
    }

    public StorageInterface getStorageHandler() {
        return this.mHandler;
    }

    public JBroFuzzWindow getWindow() {
        return this.mWindow;
    }
}

