/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.jbrofuzz.graph.canvas;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import org.apache.commons.io.IOUtils;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.labels.CategoryToolTipGenerator;
import org.jfree.chart.labels.StandardCategoryToolTipGenerator;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.owasp.jbrofuzz.version.ImageCreator;

public class HammingDistanceChart {
    private static final int MAX_CHARS = 0x100000;
    private final String[] xData;
    private final double[] yData;
    private final DefaultCategoryDataset dataset;
    private final StringBuffer firstSet;
    private static final String END_SIGNATURE = "--jbrofuzz-->\n";

    public HammingDistanceChart() {
        this(0);
    }

    public HammingDistanceChart(int size) {
        this.xData = new String[size];
        this.yData = new double[size];
        this.dataset = new DefaultCategoryDataset();
        this.firstSet = new StringBuffer();
    }

    private void calculateFirstSet(File inputFile) {
        block8: {
            BufferedReader inBuffReader = null;
            try {
                try {
                    int got;
                    inBuffReader = new BufferedReader(new FileReader(inputFile));
                    int counter = 0;
                    int check = 0;
                    while ((got = inBuffReader.read()) > 0 && counter < 0x100000) {
                        if (check == END_SIGNATURE.length()) {
                            this.firstSet.append((char)got);
                        } else {
                            check = got == END_SIGNATURE.charAt(check) ? ++check : 0;
                        }
                        ++counter;
                    }
                    inBuffReader.close();
                }
                catch (IOException e1) {
                    System.out.println("An IOException occurred.");
                    IOUtils.closeQuietly(inBuffReader);
                    break block8;
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inBuffReader);
                throw throwable;
            }
            IOUtils.closeQuietly(inBuffReader);
        }
    }

    private int calculateValue(File inputFile) {
        int hammingDistance;
        block11: {
            hammingDistance = 0;
            BufferedReader inBuffReader = null;
            try {
                try {
                    int got;
                    inBuffReader = new BufferedReader(new FileReader(inputFile));
                    int counter1 = 0;
                    int counter = 0;
                    int check = 0;
                    while ((got = inBuffReader.read()) > 0 && counter < 0x100000) {
                        if (check == END_SIGNATURE.length()) {
                            if (counter1 >= this.firstSet.length()) {
                                ++hammingDistance;
                            } else if ((char)got != this.firstSet.charAt(counter1)) {
                                ++hammingDistance;
                            }
                            ++counter1;
                        } else {
                            check = got == END_SIGNATURE.charAt(check) ? ++check : 0;
                        }
                        ++counter;
                    }
                    inBuffReader.close();
                }
                catch (IOException e1) {
                    System.out.println("An IOException occurred.");
                    IOUtils.closeQuietly(inBuffReader);
                    break block11;
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inBuffReader);
                throw throwable;
            }
            IOUtils.closeQuietly(inBuffReader);
        }
        return hammingDistance;
    }

    public void createFinalPlotCanvas() {
    }

    public ChartPanel getPlotCanvas() {
        JFreeChart chart = ChartFactory.createBarChart((String)"JBroFuzz Hamming Distance Bar Chart", (String)"File Name", (String)"Hamming Distance", (CategoryDataset)this.dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)true);
        Plot plot = chart.getPlot();
        plot.setBackgroundImage(ImageCreator.IMG_OWASP_MED.getImage());
        plot.setBackgroundImageAlignment(9);
        CategoryItemRenderer renderer = chart.getCategoryPlot().getRenderer();
        renderer.setBaseToolTipGenerator((CategoryToolTipGenerator)new StandardCategoryToolTipGenerator());
        return new ChartPanel(chart);
    }

    public void setValueAt(int index, File inputFile) {
        this.xData[index] = inputFile.getName();
        if (index == 0) {
            this.calculateFirstSet(inputFile);
            this.yData[index] = 0.0;
        } else {
            this.yData[index] = this.calculateValue(inputFile);
        }
        this.dataset.addValue(this.yData[index], (Comparable)((Object)"Row 1"), (Comparable)((Object)this.xData[index]));
    }
}

