/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.jbrofuzz.help;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import org.owasp.jbrofuzz.ui.JBroFuzzWindow;
import org.owasp.jbrofuzz.version.ImageCreator;
import org.owasp.jbrofuzz.version.JBroFuzzFormat;

public class Topics
extends JFrame
implements TreeSelectionListener {
    private static final long serialVersionUID = -7418512227087099730L;
    private static final int SIZE_X = 650;
    private static final int SIZE_Y = 400;
    private static final String FILE_NOT_FOUND = "Help file could not be located.";
    private static final String[] NODENAMES = new String[]{"Help Topics", "Fuzzing", "Graphing", "Payloads", "Headers", "System"};
    private static boolean topicsShowing = false;
    private JButton ok;
    private JTree tree;
    private JScrollPane helpScrPane;
    private JScrollPane webdScrPane;
    private JScrollPane tcpsScrPane;
    private JScrollPane tcpfScrPane;
    private JScrollPane geneScrPane;
    private JScrollPane sysmScrPane;
    private JSplitPane splitPane;
    private URL[] topicsURL;

    public Topics(JBroFuzzWindow parent) {
        JEditorPane sysmPane;
        JEditorPane genePane;
        JEditorPane tcpsPane;
        JEditorPane tcpfPane;
        JEditorPane webdPane;
        JEditorPane helpPane;
        if (topicsShowing) {
            return;
        }
        topicsShowing = true;
        this.setTitle(" JBroFuzz - Help Topics ");
        this.setIconImage(ImageCreator.IMG_FRAME.getImage());
        this.setLayout(new BorderLayout());
        this.setFont(new Font("SansSerif", 0, 12));
        this.topicsURL = new URL[NODENAMES.length];
        DefaultMutableTreeNode top = new DefaultMutableTreeNode(NODENAMES[0]);
        int i = 0;
        while (i < NODENAMES.length) {
            this.topicsURL[i] = ClassLoader.getSystemClassLoader().getResource("help/topics-0" + i + ".html");
            if (i > 0) {
                top.add(new DefaultMutableTreeNode(NODENAMES[i]));
            }
            ++i;
        }
        this.tree = new JTree(top);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.addTreeSelectionListener(this);
        JScrollPane treeView = new JScrollPane(this.tree);
        try {
            helpPane = new JEditorPane(this.topicsURL[0]);
        }
        catch (IOException e1) {
            helpPane = new JEditorPane("text/html", FILE_NOT_FOUND);
        }
        helpPane.setEditable(false);
        this.helpScrPane = new JScrollPane(helpPane);
        try {
            webdPane = new JEditorPane(this.topicsURL[2]);
        }
        catch (IOException e1) {
            webdPane = new JEditorPane("text/html", FILE_NOT_FOUND);
        }
        webdPane.setEditable(false);
        this.webdScrPane = new JScrollPane(webdPane);
        try {
            tcpfPane = new JEditorPane(this.topicsURL[1]);
        }
        catch (IOException e1) {
            tcpfPane = new JEditorPane("text/html", FILE_NOT_FOUND);
        }
        tcpfPane.setEditable(false);
        this.tcpfScrPane = new JScrollPane(tcpfPane);
        try {
            tcpsPane = new JEditorPane(this.topicsURL[3]);
        }
        catch (IOException e1) {
            tcpsPane = new JEditorPane("text/html", FILE_NOT_FOUND);
        }
        tcpsPane.setEditable(false);
        this.tcpsScrPane = new JScrollPane(tcpsPane);
        try {
            genePane = new JEditorPane(this.topicsURL[4]);
        }
        catch (IOException e1) {
            genePane = new JEditorPane("text/html", FILE_NOT_FOUND);
        }
        genePane.setEditable(false);
        this.geneScrPane = new JScrollPane(genePane);
        try {
            sysmPane = new JEditorPane(this.topicsURL[5]);
        }
        catch (IOException e1) {
            sysmPane = new JEditorPane("text/html", FILE_NOT_FOUND);
        }
        sysmPane.setEditable(false);
        this.sysmScrPane = new JScrollPane(sysmPane);
        this.splitPane = new JSplitPane(1);
        this.splitPane.setLeftComponent(treeView);
        this.splitPane.setRightComponent(this.helpScrPane);
        this.splitPane.setOneTouchExpandable(false);
        this.helpScrPane.setMinimumSize(JBroFuzzFormat.ZERO_DIM);
        this.webdScrPane.setMinimumSize(JBroFuzzFormat.ZERO_DIM);
        this.tcpsScrPane.setMinimumSize(JBroFuzzFormat.ZERO_DIM);
        this.tcpfScrPane.setMinimumSize(JBroFuzzFormat.ZERO_DIM);
        this.geneScrPane.setMinimumSize(JBroFuzzFormat.ZERO_DIM);
        this.sysmScrPane.setMinimumSize(JBroFuzzFormat.ZERO_DIM);
        treeView.setMinimumSize(JBroFuzzFormat.ZERO_DIM);
        this.splitPane.setDividerLocation(100);
        this.splitPane.setPreferredSize(new Dimension(650, 400));
        this.getContentPane().add((Component)this.splitPane, "Center");
        this.ok = new JButton("  OK  ");
        JPanel buttonPanel = new JPanel(new FlowLayout(2, 15, 15));
        buttonPanel.add(this.ok);
        this.ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                topicsShowing = false;
                Topics.this.dispose();
            }
        });
        this.getContentPane().add((Component)buttonPanel, "South");
        this.splitPane.setDividerLocation(150);
        this.setLocation(parent.getLocation().x + (parent.getWidth() - 650) / 2, parent.getLocation().y + (parent.getHeight() - 400) / 2);
        this.setSize(650, 400);
        this.setMinimumSize(new Dimension(325, 200));
        this.setResizable(true);
        this.setVisible(true);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                topicsShowing = false;
                Topics.this.dispose();
            }
        });
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        String s = node.toString();
        if (s.equalsIgnoreCase("Help Topics")) {
            this.splitPane.setRightComponent(this.helpScrPane);
            this.splitPane.setDividerLocation(150);
        }
        if (s.equalsIgnoreCase("Graphing")) {
            this.splitPane.setRightComponent(this.webdScrPane);
            this.splitPane.setDividerLocation(150);
        }
        if (s.equalsIgnoreCase("Fuzzing")) {
            this.splitPane.setRightComponent(this.tcpfScrPane);
            this.splitPane.setDividerLocation(150);
        }
        if (s.equalsIgnoreCase("Headers")) {
            this.splitPane.setRightComponent(this.tcpsScrPane);
            this.splitPane.setDividerLocation(150);
        }
        if (s.equalsIgnoreCase("Payloads")) {
            this.splitPane.setRightComponent(this.geneScrPane);
            this.splitPane.setDividerLocation(150);
        }
        if (s.equalsIgnoreCase("System")) {
            this.splitPane.setRightComponent(this.sysmScrPane);
            this.splitPane.setDividerLocation(150);
        }
    }
}

