/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.extension.option;

import java.util.Locale;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.common.AbstractParam;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.extension.httppanel.view.largerequest.LargeRequestUtil;
import org.zaproxy.zap.extension.httppanel.view.largeresponse.LargeResponseUtil;

public class OptionsParamView
extends AbstractParam {
    private static final String DEFAULT_TIME_STAMP_FORMAT = Constant.messages.getString("timestamp.format.default");
    public static final String BASE_VIEW_KEY = "view";
    private static final String SHOW_TEXT_ICONS = "view.showTabNames";
    private static final String PROCESS_IMAGES = "view.processImages";
    public static final String LOCALE = "view.locale";
    public static final String LOCALES = "view.locales";
    public static final String DISPLAY_OPTION = "view.displayOption";
    public static final String BRK_PANEL_VIEW_OPTION = "view.brkPanelView";
    public static final String SHOW_MAIN_TOOLBAR_OPTION = "view.showMainToolbar";
    public static final String DEFAULT_LOCALE = "en_GB";
    public static final String ADVANCEDUI_OPTION = "view.advancedview";
    public static final String WMUIHANDLING_OPTION = "view.uiWmHandling";
    public static final String ASKONEXIT_OPTION = "view.askOnExit";
    public static final String WARN_ON_TAB_DOUBLE_CLICK_OPTION = "view.warnOnTabDoubleClick";
    public static final String MODE_OPTION = "view.mode";
    public static final String TAB_PIN_OPTION = "view.tab.pin";
    public static final String OUTPUT_TAB_TIMESTAMPING_OPTION = "view.outputTabsTimeStampsOption";
    public static final String OUTPUT_TAB_TIMESTAMP_FORMAT = "view.outputTabsTimeStampsFormat";
    public static final String SPLASHSCREEN_OPTION = "view.splashScreen";
    public static final String LARGE_REQUEST_SIZE = "view.largeRequest";
    public static final String LARGE_RESPONSE_SIZE = "view.largeResponse";
    public static final String FONT_NAME = "view.fontName";
    public static final String FONT_SIZE = "view.fontSize";
    public static final String SCALE_IMAGES = "view.scaleImages";
    public static final String SHOW_DEV_WARNING = "view.showDevWarning";
    private int advancedViewEnabled = 0;
    private int processImages = 0;
    private int showMainToolbar = 1;
    private String configLocale = "";
    private String locale = "";
    private int displayOption = 0;
    private int brkPanelViewOption = 0;
    private int askOnExitEnabled = 1;
    private int wmUiHandlingEnabled = 0;
    private boolean warnOnTabDoubleClick = false;
    private boolean showTabNames = true;
    private String mode = Control.Mode.standard.name();
    private boolean outputTabTimeStampingEnabled = false;
    private String outputTabTimeStampFormat = DEFAULT_TIME_STAMP_FORMAT;
    private boolean showSplashScreen = true;
    private int largeRequestSize = 100000;
    private int largeResponseSize = 100000;
    private int fontSize = -1;
    private String fontName = "";
    private boolean scaleImages = true;
    private boolean showDevWarning = true;

    @Override
    protected void parse() {
        this.showTabNames = this.getConfig().getBoolean(SHOW_TEXT_ICONS, true);
        this.processImages = this.getConfig().getInt(PROCESS_IMAGES, 0);
        this.configLocale = this.getConfig().getString(LOCALE, null);
        this.locale = this.getConfig().getString(LOCALE, DEFAULT_LOCALE);
        this.displayOption = this.getConfig().getInt(DISPLAY_OPTION, 0);
        this.brkPanelViewOption = this.getConfig().getInt(BRK_PANEL_VIEW_OPTION, 0);
        this.showMainToolbar = this.getConfig().getInt(SHOW_MAIN_TOOLBAR_OPTION, 1);
        this.advancedViewEnabled = this.getConfig().getInt(ADVANCEDUI_OPTION, 0);
        this.wmUiHandlingEnabled = this.getConfig().getInt(WMUIHANDLING_OPTION, 0);
        this.askOnExitEnabled = this.getConfig().getInt(ASKONEXIT_OPTION, 1);
        this.warnOnTabDoubleClick = this.getConfig().getBoolean(WARN_ON_TAB_DOUBLE_CLICK_OPTION, true);
        this.mode = this.getConfig().getString(MODE_OPTION, Control.Mode.standard.name());
        this.outputTabTimeStampingEnabled = this.getConfig().getBoolean(OUTPUT_TAB_TIMESTAMPING_OPTION, false);
        this.outputTabTimeStampFormat = this.getConfig().getString(OUTPUT_TAB_TIMESTAMP_FORMAT, DEFAULT_TIME_STAMP_FORMAT);
        this.showSplashScreen = this.getConfig().getBoolean(SPLASHSCREEN_OPTION, true);
        this.largeRequestSize = this.getConfig().getInteger(LARGE_REQUEST_SIZE, Integer.valueOf(100000));
        this.largeResponseSize = this.getConfig().getInteger(LARGE_RESPONSE_SIZE, Integer.valueOf(100000));
        this.fontSize = this.getConfig().getInteger(FONT_SIZE, Integer.valueOf(-1));
        this.fontName = this.getConfig().getString(FONT_NAME, "");
        this.scaleImages = this.getConfig().getBoolean(SCALE_IMAGES, true);
        this.showDevWarning = this.getConfig().getBoolean(SHOW_DEV_WARNING, true);
        LargeRequestUtil.setMinContentLength(this.largeRequestSize);
        LargeResponseUtil.setMinContentLength(this.largeResponseSize);
    }

    public int getProcessImages() {
        return this.processImages;
    }

    public void setProcessImages(int n) {
        this.processImages = n;
        this.getConfig().setProperty(PROCESS_IMAGES, (Object)Integer.toString(n));
    }

    public boolean isProcessImages() {
        return this.processImages != 0;
    }

    public int getShowMainToolbar() {
        return this.showMainToolbar;
    }

    public void setShowMainToolbar(int n) {
        this.showMainToolbar = n;
        this.getConfig().setProperty(SHOW_MAIN_TOOLBAR_OPTION, (Object)Integer.toString(n));
    }

    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String string) {
        if (string != null) {
            this.locale = string;
            this.getConfig().setProperty(LOCALE, (Object)string);
        }
    }

    public void setLocale(Locale locale) {
        if (locale != null) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(locale.getLanguage());
            if (locale.getCountry().length() > 0) {
                stringBuilder.append("_").append(locale.getCountry());
            }
            if (locale.getVariant().length() > 0) {
                stringBuilder.append("_").append(locale.getVariant());
            }
            this.locale = stringBuilder.toString();
            this.getConfig().setProperty(LOCALE, (Object)locale);
        }
    }

    public String getConfigLocale() {
        return this.configLocale;
    }

    public boolean getShowTabNames() {
        return this.showTabNames;
    }

    public void setShowTabNames(boolean bl) {
        this.showTabNames = bl;
        View.getSingleton().getWorkbench().toggleTabNames(bl);
        this.getConfig().setProperty(SHOW_TEXT_ICONS, (Object)bl);
    }

    public int getBrkPanelViewOption() {
        return this.brkPanelViewOption;
    }

    public void setBrkPanelViewOption(int n) {
        this.brkPanelViewOption = n;
        this.getConfig().setProperty(BRK_PANEL_VIEW_OPTION, (Object)Integer.toString(this.brkPanelViewOption));
    }

    public int getDisplayOption() {
        return this.displayOption;
    }

    public void setDisplayOption(int n) {
        this.displayOption = n;
        this.getConfig().setProperty(DISPLAY_OPTION, (Object)Integer.toString(n));
    }

    public int getAdvancedViewOption() {
        return this.advancedViewEnabled;
    }

    public void setAdvancedViewOption(int n) {
        this.advancedViewEnabled = n;
        this.getConfig().setProperty(ADVANCEDUI_OPTION, (Object)Integer.toString(n));
    }

    public void setAskOnExitOption(int n) {
        this.askOnExitEnabled = n;
        this.getConfig().setProperty(ASKONEXIT_OPTION, (Object)Integer.toString(n));
    }

    public int getAskOnExitOption() {
        return this.askOnExitEnabled;
    }

    public void setWmUiHandlingOption(int n) {
        this.wmUiHandlingEnabled = n;
        this.getConfig().setProperty(WMUIHANDLING_OPTION, (Object)Integer.toString(n));
    }

    public int getWmUiHandlingOption() {
        return this.wmUiHandlingEnabled;
    }

    public boolean getWarnOnTabDoubleClick() {
        return this.warnOnTabDoubleClick;
    }

    public void setWarnOnTabDoubleClick(boolean bl) {
        this.warnOnTabDoubleClick = bl;
        this.getConfig().setProperty(WARN_ON_TAB_DOUBLE_CLICK_OPTION, (Object)bl);
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String string) {
        this.mode = string;
        this.getConfig().setProperty(MODE_OPTION, (Object)string);
    }

    public void setOutputTabTimeStampingEnabled(boolean bl) {
        this.outputTabTimeStampingEnabled = bl;
        this.getConfig().setProperty(OUTPUT_TAB_TIMESTAMPING_OPTION, (Object)bl);
    }

    public boolean isOutputTabTimeStampingEnabled() {
        return this.outputTabTimeStampingEnabled;
    }

    public void setOutputTabTimeStampsFormat(String string) {
        this.outputTabTimeStampFormat = string;
        this.getConfig().setProperty(OUTPUT_TAB_TIMESTAMP_FORMAT, (Object)string);
    }

    public String getOutputTabTimeStampsFormat() {
        return this.outputTabTimeStampFormat;
    }

    public boolean isShowSplashScreen() {
        return this.showSplashScreen;
    }

    public void setShowSplashScreen(boolean bl) {
        this.showSplashScreen = bl;
        this.getConfig().setProperty(SPLASHSCREEN_OPTION, (Object)bl);
    }

    public int getLargeRequestSize() {
        return this.largeRequestSize;
    }

    public void setLargeRequestSize(int n) {
        this.largeRequestSize = n;
        LargeRequestUtil.setMinContentLength(n);
        this.getConfig().setProperty(LARGE_REQUEST_SIZE, (Object)n);
    }

    public int getLargeResponseSize() {
        return this.largeResponseSize;
    }

    public void setLargeResponseSize(int n) {
        this.largeResponseSize = n;
        LargeResponseUtil.setMinContentLength(n);
        this.getConfig().setProperty(LARGE_RESPONSE_SIZE, (Object)n);
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(int n) {
        this.fontSize = n;
        this.getConfig().setProperty(FONT_SIZE, (Object)n);
    }

    public String getFontName() {
        return this.fontName;
    }

    public void setFontName(String string) {
        this.fontName = string;
        this.getConfig().setProperty(FONT_NAME, (Object)string);
    }

    public boolean isScaleImages() {
        return this.scaleImages;
    }

    public void setScaleImages(boolean bl) {
        this.scaleImages = bl;
        this.getConfig().setProperty(SCALE_IMAGES, (Object)bl);
    }

    public boolean isShowDevWarning() {
        return this.showDevWarning;
    }

    public void setShowDevWarning(boolean bl) {
        this.showDevWarning = bl;
        this.getConfig().setProperty(SHOW_DEV_WARNING, (Object)bl);
    }
}

