/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.extension.report;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.List;
import org.parosproxy.paros.CommandLine;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.extension.CommandLineArgument;
import org.parosproxy.paros.extension.CommandLineListener;
import org.parosproxy.paros.extension.ExtensionAdaptor;
import org.parosproxy.paros.extension.ExtensionHook;
import org.parosproxy.paros.extension.report.ReportLastScan;
import org.zaproxy.zap.view.ZapMenuItem;

public class ExtensionReport
extends ExtensionAdaptor
implements CommandLineListener {
    private static final int ARG_LAST_SCAN_REPORT_IDX = 0;
    private ZapMenuItem menuItemHtmlReport = null;
    private ZapMenuItem menuItemXmlReport = null;
    private CommandLineArgument[] arguments = new CommandLineArgument[1];

    public ExtensionReport() {
        this.initialize();
    }

    public ExtensionReport(String string) {
        super(string);
        this.setOrder(14);
    }

    private void initialize() {
        this.setName("ExtensionReport");
    }

    @Override
    public void hook(ExtensionHook extensionHook) {
        super.hook(extensionHook);
        if (this.getView() != null) {
            extensionHook.getHookMenu().addReportMenuItem(this.getMenuItemHtmlReport());
            extensionHook.getHookMenu().addReportMenuItem(this.getMenuItemXmlReport());
        }
        extensionHook.addCommandLine(this.getCommandLineArguments());
    }

    private ZapMenuItem getMenuItemHtmlReport() {
        if (this.menuItemHtmlReport == null) {
            this.menuItemHtmlReport = new ZapMenuItem("menu.report.html.generate");
            this.menuItemHtmlReport.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ReportLastScan reportLastScan = new ReportLastScan();
                    reportLastScan.generateReport(ExtensionReport.this.getView(), ExtensionReport.this.getModel(), ReportLastScan.ReportType.HTML);
                }
            });
        }
        return this.menuItemHtmlReport;
    }

    private ZapMenuItem getMenuItemXmlReport() {
        if (this.menuItemXmlReport == null) {
            this.menuItemXmlReport = new ZapMenuItem("menu.report.xml.generate");
            this.menuItemXmlReport.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ReportLastScan reportLastScan = new ReportLastScan();
                    reportLastScan.generateReport(ExtensionReport.this.getView(), ExtensionReport.this.getModel(), ReportLastScan.ReportType.XML);
                }
            });
        }
        return this.menuItemXmlReport;
    }

    @Override
    public void execute(CommandLineArgument[] commandLineArgumentArray) {
        if (this.arguments[0].isEnabled()) {
            CommandLineArgument commandLineArgument = this.arguments[0];
            ReportLastScan reportLastScan = new ReportLastScan();
            String string = commandLineArgument.getArguments().get(0);
            try {
                reportLastScan.generate(string, this.getModel(), "xml/report.html.xsl");
                CommandLine.info("Last Scan Report generated at " + string);
            }
            catch (Exception exception) {
                CommandLine.error(exception.getMessage(), exception);
            }
        } else {
            return;
        }
    }

    private CommandLineArgument[] getCommandLineArguments() {
        this.arguments[0] = new CommandLineArgument("-last_scan_report", 1, null, "", Constant.messages.getString("report.cmdline.gen.help"));
        return this.arguments;
    }

    @Override
    public String getAuthor() {
        return "Chinotec Technologies";
    }

    @Override
    public boolean handleFile(File file) {
        return false;
    }

    @Override
    public List<String> getHandledExtensions() {
        return null;
    }
}

