/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.api;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.commons.lang.StringUtils;
import org.zaproxy.zap.extension.api.ApiElement;
import org.zaproxy.zap.extension.api.ApiGeneratorUtils;
import org.zaproxy.zap.extension.api.ApiImplementor;

public class GoAPIGenerator {
    private File dir;
    private boolean optional = false;
    private boolean addImports = false;
    private final String HEADER = "// Zed Attack Proxy (ZAP) and its related class files.\n//\n// ZAP is an HTTP/HTTPS proxy for assessing web application security.\n//\n// Copyright 2015 the ZAP development team\n//\n// Licensed under the Apache License, Version 2.0 (the \"License\");\n// you may not use this file except in compliance with the License.\n// You may obtain a copy of the License at\n//\n//   http://www.apache.org/licenses/LICENSE-2.0\n//\n// Unless required by applicable law or agreed to in writing, software\n// distributed under the License is distributed on an \"AS IS\" BASIS,\n// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n// See the License for the specific language governing permissions and\n// limitations under the License.\n";
    private final String OPTIONAL_MASSAGE = "This component is optional and therefore the API will only work if it is installed";
    private ResourceBundle msgs = ResourceBundle.getBundle("lang.Messages", Locale.ENGLISH, ResourceBundle.Control.getControl(ResourceBundle.Control.FORMAT_PROPERTIES));
    private static final Map<String, String> nameMap;

    public GoAPIGenerator() {
        this.dir = new File("../zap-api-go/zap/");
    }

    public GoAPIGenerator(String string, boolean bl) {
        this.dir = new File(string);
        this.optional = bl;
    }

    public void generateGoFiles(List<ApiImplementor> list) throws IOException {
        for (ApiImplementor apiImplementor : list) {
            this.generateGoComponent(apiImplementor);
        }
    }

    private void generateGoComponent(ApiImplementor apiImplementor) throws IOException {
        String string = apiImplementor.getPrefix().substring(0, 1).toUpperCase() + apiImplementor.getPrefix().substring(1);
        String string2 = GoAPIGenerator.safeName(GoAPIGenerator.camelCaseToLowerCaseDash(string));
        File file = new File(this.dir, string2 + ".go");
        System.out.println("Generating " + file.getAbsolutePath());
        FileWriter fileWriter = new FileWriter(file);
        fileWriter.write("// Zed Attack Proxy (ZAP) and its related class files.\n//\n// ZAP is an HTTP/HTTPS proxy for assessing web application security.\n//\n// Copyright 2015 the ZAP development team\n//\n// Licensed under the Apache License, Version 2.0 (the \"License\");\n// you may not use this file except in compliance with the License.\n// You may obtain a copy of the License at\n//\n//   http://www.apache.org/licenses/LICENSE-2.0\n//\n// Unless required by applicable law or agreed to in writing, software\n// distributed under the License is distributed on an \"AS IS\" BASIS,\n// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n// See the License for the specific language governing permissions and\n// limitations under the License.\n");
        fileWriter.write("//\n");
        fileWriter.write("// *** This file was automatically generated. ***\n");
        fileWriter.write("//\n\n");
        fileWriter.write("package zap\n\n");
        fileWriter.write("_imports_");
        fileWriter.write("type " + string + " struct {}" + "\n\n");
        for (ApiElement apiElement : apiImplementor.getApiViews()) {
            this.generateGoElement(apiElement, string, apiImplementor.getPrefix(), "view", fileWriter);
        }
        for (ApiElement apiElement : apiImplementor.getApiActions()) {
            this.generateGoElement(apiElement, string, apiImplementor.getPrefix(), "action", fileWriter);
        }
        for (ApiElement apiElement : apiImplementor.getApiOthers()) {
            this.generateGoElement(apiElement, string, apiImplementor.getPrefix(), "other", fileWriter);
        }
        fileWriter.close();
        GoAPIGenerator.addImports(file, this.addImports);
        this.addImports = false;
    }

    private void generateGoElement(ApiElement apiElement, String string, String string2, String string3, Writer writer) throws IOException {
        String string4;
        boolean bl;
        boolean bl2;
        block10: {
            bl2 = string3.equals("other");
            bl = apiElement.getMandatoryParamNames() != null && apiElement.getMandatoryParamNames().size() > 0 || apiElement.getOptionalParamNames() != null && apiElement.getOptionalParamNames().size() > 0;
            String string5 = apiElement.getDescriptionTag();
            if (string5 == null) {
                string5 = string2 + ".api." + string3 + "." + apiElement.getName();
            }
            try {
                string4 = this.msgs.getString(string5);
                writer.write("// " + string4 + "\n");
                if (this.optional) {
                    writer.write("//\n");
                    writer.write("// This component is optional and therefore the API will only work if it is installed\n");
                }
            }
            catch (Exception exception) {
                System.out.println("No i18n for: " + string5);
                if (!this.optional) break block10;
                writer.write("// This component is optional and therefore the API will only work if it is installed\n");
            }
        }
        writer.write("func (" + string.substring(0, 1).toLowerCase() + " " + string + ") ");
        writer.write(GoAPIGenerator.toTitleCase(GoAPIGenerator.createMethodName(apiElement.getName())));
        writer.write("(");
        this.writeOutArgs(apiElement.getMandatoryParamNames(), writer, bl);
        if (apiElement.getMandatoryParamNames() != null && apiElement.getMandatoryParamNames().size() > 0 && apiElement.getOptionalParamNames() != null && apiElement.getOptionalParamNames().size() > 0) {
            writer.write(", ");
        }
        this.writeOutArgs(apiElement.getOptionalParamNames(), writer, bl);
        writer.write(")");
        if (bl2) {
            writer.write(" ([]byte, error) ");
        } else {
            writer.write(" (interface{}, error) ");
        }
        writer.write("{\n");
        if (bl) {
            writer.write("\tm := map[string]string{");
            this.writeOutRequestParams(apiElement.getMandatoryParamNames(), writer);
            this.writeOutRequestParams(apiElement.getOptionalParamNames(), writer);
            writer.write("\n\t}\n");
        }
        string4 = "Request";
        if (bl2) {
            string4 = string4 + "Other";
        }
        writer.write("\treturn " + string4 + "(\"" + string2 + "/" + string3 + "/" + apiElement.getName() + "/\"");
        if (bl) {
            writer.write(", m");
        }
        writer.write(")\n");
        writer.write("}\n\n");
    }

    private void writeOutArgs(List<String> list, Writer writer, boolean bl) throws IOException {
        if (list != null && list.size() > 0) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String string : list) {
                if (string.toLowerCase().equals("boolean")) {
                    arrayList.add("boolean bool");
                    continue;
                }
                if (string.toLowerCase().equals("integer")) {
                    arrayList.add("i int");
                    continue;
                }
                if (string.toLowerCase().equals("string")) {
                    arrayList.add("str string");
                    continue;
                }
                if (string.toLowerCase().equals("type")) {
                    arrayList.add("t string");
                    continue;
                }
                arrayList.add(string.toLowerCase() + " string");
            }
            writer.write(StringUtils.join(arrayList, ", "));
        }
    }

    private void writeOutRequestParams(List<String> list, Writer writer) throws IOException {
        if (list != null && list.size() > 0) {
            for (String string : list) {
                writer.write("\n\t\t\"" + string + "\": ");
                if (string.toLowerCase().equals("boolean")) {
                    this.addImports = true;
                    writer.write("strconv.FormatBool(boolean)");
                } else if (string.toLowerCase().equals("integer")) {
                    this.addImports = true;
                    writer.write("strconv.Itoa(i)");
                } else if (string.toLowerCase().equals("string")) {
                    writer.write("str");
                } else if (string.toLowerCase().equals("type")) {
                    writer.write("t");
                } else {
                    writer.write(string.toLowerCase());
                }
                writer.write(",");
            }
        }
    }

    private static String safeName(String string) {
        if (nameMap.containsKey(string)) {
            return nameMap.get(string);
        }
        return string;
    }

    private static String createMethodName(String string) {
        if (nameMap.containsKey(string)) {
            string = nameMap.get(string);
        }
        return GoAPIGenerator.removeAllFullStopCharacters(string);
    }

    private static String removeAllFullStopCharacters(String string) {
        return string.replaceAll("\\.", "");
    }

    public static String camelCaseToLowerCaseDash(String string) {
        return GoAPIGenerator.safeName(string).replaceAll(String.format("%s|%s|%s", "(?<=[A-Z])(?=[A-Z][a-z])", "(?<=[^A-Z])(?=[A-Z])", "(?<=[A-Za-z])(?=[^A-Za-z])"), "-").toLowerCase();
    }

    private static String toTitleCase(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (char c : string.toCharArray()) {
            if (Character.isSpaceChar(c)) {
                bl = true;
            } else if (bl) {
                c = Character.toTitleCase(c);
                bl = false;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    private static void addImports(File file, boolean bl) throws IOException {
        Path path = Paths.get(file.getPath(), new String[0]);
        Charset charset = StandardCharsets.UTF_8;
        String string = new String(Files.readAllBytes(path), charset);
        string = bl ? string.replaceAll("_imports_", "import \"strconv\"\n\n") : string.replaceAll("_imports_", "");
        Files.write(path, string.getBytes(charset), new OpenOption[0]);
    }

    public static void main(String[] stringArray) throws Exception {
        GoAPIGenerator goAPIGenerator = new GoAPIGenerator();
        goAPIGenerator.generateGoFiles(ApiGeneratorUtils.getAllImplementors());
    }

    static {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("break", "brk");
        nameMap = Collections.unmodifiableMap(hashMap);
    }
}

