/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.ascan;

import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.InvalidParameterException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.KeyStroke;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.core.scanner.HostProcess;
import org.parosproxy.paros.core.scanner.ScannerParam;
import org.parosproxy.paros.extension.CommandLineArgument;
import org.parosproxy.paros.extension.CommandLineListener;
import org.parosproxy.paros.extension.ExtensionAdaptor;
import org.parosproxy.paros.extension.ExtensionHook;
import org.parosproxy.paros.extension.SessionChangedListener;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.model.SiteNode;
import org.parosproxy.paros.view.AbstractParamPanel;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.ZAP;
import org.zaproxy.zap.extension.alert.ExtensionAlert;
import org.zaproxy.zap.extension.api.API;
import org.zaproxy.zap.extension.ascan.ActiveScan;
import org.zaproxy.zap.extension.ascan.ActiveScanAPI;
import org.zaproxy.zap.extension.ascan.ActiveScanController;
import org.zaproxy.zap.extension.ascan.ActiveScanPanel;
import org.zaproxy.zap.extension.ascan.AttackModeScanner;
import org.zaproxy.zap.extension.ascan.CustomScanDialog;
import org.zaproxy.zap.extension.ascan.CustomScanPanel;
import org.zaproxy.zap.extension.ascan.OptionsScannerPanel;
import org.zaproxy.zap.extension.ascan.OptionsVariantPanel;
import org.zaproxy.zap.extension.ascan.PolicyDialog;
import org.zaproxy.zap.extension.ascan.PolicyManager;
import org.zaproxy.zap.extension.ascan.PolicyManagerDialog;
import org.zaproxy.zap.extension.ascan.ScanPolicy;
import org.zaproxy.zap.extension.help.ExtensionHelp;
import org.zaproxy.zap.extension.script.ExtensionScript;
import org.zaproxy.zap.extension.script.ScriptType;
import org.zaproxy.zap.model.ScanController;
import org.zaproxy.zap.model.StructuralNode;
import org.zaproxy.zap.model.StructuralSiteNode;
import org.zaproxy.zap.model.Target;
import org.zaproxy.zap.users.User;
import org.zaproxy.zap.view.ZapMenuItem;

public class ExtensionActiveScan
extends ExtensionAdaptor
implements SessionChangedListener,
CommandLineListener,
ScanController<ActiveScan> {
    private static final Logger logger = Logger.getLogger(ExtensionActiveScan.class);
    private static final int ARG_SCAN_IDX = 0;
    public static final String NAME = "ExtensionActiveScan";
    private static final ImageIcon SCRIPT_ICON_ACTIVE = new ImageIcon(ZAP.class.getResource("/resource/icon/16/script-ascan.png"));
    private static final ImageIcon SCRIPT_ICON_VARIANT = new ImageIcon(ZAP.class.getResource("/resource/icon/16/script-variant.png"));
    public static final String SCRIPT_TYPE_ACTIVE = "active";
    public static final String SCRIPT_TYPE_VARIANT = "variant";
    public static final int PROXY_LISTENER_ORDER = 5001;
    private static final List<Class<?>> DEPENDENCIES;
    private AttackModeScanner attackModeScanner;
    private ActiveScanController ascanController = null;
    private ZapMenuItem menuItemPolicy = null;
    private ZapMenuItem menuItemCustomScan = null;
    private OptionsScannerPanel optionsScannerPanel = null;
    private OptionsVariantPanel optionsVariantPanel = null;
    private ActiveScanPanel activeScanPanel = null;
    private ScannerParam scannerParam = null;
    private final CommandLineArgument[] arguments = new CommandLineArgument[1];
    private final List<AbstractParamPanel> policyPanels = new ArrayList<AbstractParamPanel>();
    private JButton policyButton = null;
    private CustomScanDialog customScanDialog = null;
    private PolicyManagerDialog policyManagerDialog = null;
    private PolicyManager policyManager = null;
    private List<CustomScanPanel> customScanPanels = new ArrayList<CustomScanPanel>();
    private ActiveScanAPI activeScanApi;

    public ExtensionActiveScan() {
        this.initialize();
    }

    public ExtensionActiveScan(String string) {
        super(string);
    }

    private void initialize() {
        this.setName(NAME);
        this.setOrder(28);
        this.policyManager = new PolicyManager(this);
        this.ascanController = new ActiveScanController(this);
        this.attackModeScanner = new AttackModeScanner(this);
    }

    @Override
    public void optionsLoaded() {
        this.policyManager.init();
        if (Control.getSingleton().getMode().equals((Object)Control.Mode.attack)) {
            if (this.getScannerParam().isAllowAttackOnStart()) {
                if (!View.isInitialised()) {
                    Control.getSingleton().setMode(Control.Mode.attack);
                }
            } else if (View.isInitialised()) {
                View.getSingleton().getMainFrame().getMainToolbarPanel().setMode(Control.Mode.standard);
            } else {
                Control.getSingleton().setMode(Control.Mode.standard);
            }
        }
    }

    @Override
    public void hook(ExtensionHook extensionHook) {
        super.hook(extensionHook);
        if (this.getView() != null) {
            extensionHook.getHookMenu().addAnalyseMenuItem(this.getMenuItemPolicy());
            extensionHook.getHookMenu().addToolsMenuItem(this.getMenuItemCustomScan());
            extensionHook.getHookView().addStatusPanel(this.getActiveScanPanel());
            extensionHook.getHookView().addOptionPanel(this.getOptionsScannerPanel());
            extensionHook.getHookView().addOptionPanel(this.getOptionsVariantPanel());
            View.getSingleton().addMainToolbarButton(this.getPolicyButton());
            View.getSingleton().getMainFrame().getMainFooterPanel().addFooterToolbarRightLabel(this.attackModeScanner.getScanStatus().getCountLabel());
            ExtensionHelp.enableHelpKey(this.getActiveScanPanel(), "ui.tabs.ascan");
        }
        extensionHook.addSessionListener(this);
        extensionHook.addOptionsParamSet(this.getScannerParam());
        ExtensionScript extensionScript = (ExtensionScript)Control.getSingleton().getExtensionLoader().getExtension("ExtensionScript");
        if (extensionScript != null) {
            extensionScript.registerScriptType(new ScriptType(SCRIPT_TYPE_ACTIVE, "ascan.scripts.type.active", SCRIPT_ICON_ACTIVE, true));
            extensionScript.registerScriptType(new ScriptType(SCRIPT_TYPE_VARIANT, "variant.scripts.type.variant", SCRIPT_ICON_VARIANT, true));
        }
        this.ascanController.setExtAlert((ExtensionAlert)Control.getSingleton().getExtensionLoader().getExtension("ExtensionAlert"));
        this.activeScanApi = new ActiveScanAPI(this);
        this.activeScanApi.addApiOptions(this.getScannerParam());
        API.getInstance().registerApiImplementor(this.activeScanApi);
    }

    @Override
    public List<String> getActiveActions() {
        List<ActiveScan> list = this.ascanController.getActiveScans();
        if (list.isEmpty()) {
            return null;
        }
        String string = Constant.messages.getString("ascan.activeActionPrefix");
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        for (ActiveScan activeScan : list) {
            arrayList.add(MessageFormat.format(string, activeScan.getDisplayName()));
        }
        return arrayList;
    }

    private ActiveScanPanel getActiveScanPanel() {
        if (this.activeScanPanel == null) {
            this.activeScanPanel = new ActiveScanPanel(this);
        }
        return this.activeScanPanel;
    }

    public void startScanAllInScope() {
        SiteNode siteNode = (SiteNode)Model.getSingleton().getSession().getSiteTree().getRoot();
        this.startScan(new Target(siteNode, null, true, true));
    }

    public int startScan(SiteNode siteNode) {
        return this.startScan(new Target(siteNode, true));
    }

    public int startScanNode(SiteNode siteNode) {
        return this.startScan(new Target(siteNode, false));
    }

    public int startScan(Target target) {
        return this.startScan(target, null, null);
    }

    public int startScan(Target target, User user, Object[] objectArray) {
        return this.startScan(target.getDisplayName(), target, user, objectArray);
    }

    @Override
    public int startScan(String string, Target target, User user, Object[] objectArray) {
        if (string == null) {
            string = target.getDisplayName();
        }
        switch (Control.getSingleton().getMode()) {
            case safe: {
                throw new InvalidParameterException("Scans are not allowed in Safe mode");
            }
            case protect: {
                List<StructuralNode> list = target.getStartNodes();
                if (list == null) break;
                for (StructuralNode structuralNode : list) {
                    SiteNode siteNode;
                    if (!(structuralNode instanceof StructuralSiteNode) || (siteNode = ((StructuralSiteNode)structuralNode).getSiteNode()).isIncludedInScope()) continue;
                    throw new InvalidParameterException("Scans are not allowed on nodes not in scope Protected mode " + target.getStartNode().getHierarchicNodeName());
                }
                break;
            }
            case standard: {
                break;
            }
        }
        int n = this.ascanController.startScan(string, target, user, objectArray);
        if (View.isInitialised()) {
            ActiveScan activeScan = this.ascanController.getScan(n);
            activeScan.addScannerListener(this.getActiveScanPanel());
            this.getActiveScanPanel().scannerStarted(activeScan);
            this.getActiveScanPanel().switchView(activeScan);
            this.getActiveScanPanel().setTabFocus();
        }
        return n;
    }

    public void scannerComplete() {
    }

    private JButton getPolicyButton() {
        if (this.policyButton == null) {
            this.policyButton = new JButton();
            this.policyButton.setIcon(new ImageIcon(ActiveScanPanel.class.getResource("/resource/icon/fugue/equalizer.png")));
            this.policyButton.setToolTipText(Constant.messages.getString("menu.analyse.scanPolicy"));
            this.policyButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ExtensionActiveScan.this.showPolicyManagerDialog();
                }
            });
        }
        return this.policyButton;
    }

    private ZapMenuItem getMenuItemPolicy() {
        if (this.menuItemPolicy == null) {
            this.menuItemPolicy = new ZapMenuItem("menu.analyse.scanPolicy", KeyStroke.getKeyStroke(80, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
            this.menuItemPolicy.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ExtensionActiveScan.this.showPolicyManagerDialog();
                }
            });
        }
        return this.menuItemPolicy;
    }

    protected void showPolicyDialog(PolicyManagerDialog policyManagerDialog) throws ConfigurationException {
        this.showPolicyDialog(policyManagerDialog, null);
    }

    protected void showPolicyDialog(PolicyManagerDialog policyManagerDialog, String string) throws ConfigurationException {
        ScanPolicy scanPolicy = string != null ? this.getPolicyManager().getPolicy(string) : this.getPolicyManager().getTemplatePolicy();
        PolicyDialog policyDialog = new PolicyDialog(this, policyManagerDialog, scanPolicy);
        policyDialog.initParam(this.getModel().getOptionsParam());
        for (AbstractParamPanel abstractParamPanel : this.policyPanels) {
            policyDialog.addPolicyPanel(abstractParamPanel);
        }
        int n = policyDialog.showDialog(true);
        if (n == 0) {
            try {
                this.getModel().getOptionsParam().getConfig().save();
            }
            catch (ConfigurationException configurationException) {
                logger.error((Object)configurationException.getMessage(), (Throwable)configurationException);
                this.getView().showWarningDialog(Constant.messages.getString("scanner.save.warning"));
            }
        }
    }

    private ZapMenuItem getMenuItemCustomScan() {
        if (this.menuItemCustomScan == null) {
            this.menuItemCustomScan = new ZapMenuItem("menu.tools.ascanadv", KeyStroke.getKeyStroke(65, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 8, false));
            this.menuItemCustomScan.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ExtensionActiveScan.this.showCustomScanDialog(null);
                }
            });
        }
        return this.menuItemCustomScan;
    }

    public void hostProgress(String string, String string2, int n) {
    }

    public void hostComplete(String string) {
    }

    public void hostNewScan(String string, HostProcess hostProcess) {
    }

    @Override
    public void sessionChanged(final Session session) {
        if (EventQueue.isDispatchThread()) {
            this.sessionChangedEventHandler(session);
        } else {
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        ExtensionActiveScan.this.sessionChangedEventHandler(session);
                    }
                });
            }
            catch (InterruptedException | InvocationTargetException exception) {
                logger.error((Object)exception.getMessage(), (Throwable)exception);
            }
        }
    }

    private void sessionChangedEventHandler(Session session) {
        if (View.isInitialised()) {
            this.getActiveScanPanel().reset();
        }
        this.attackModeScanner.stop();
        if (session == null) {
            return;
        }
        if (Control.getSingleton().getMode().equals((Object)Control.Mode.attack)) {
            this.attackModeScanner.start();
            this.attackModeScanner.setRescanOnChange(true);
        }
    }

    private OptionsScannerPanel getOptionsScannerPanel() {
        if (this.optionsScannerPanel == null) {
            this.optionsScannerPanel = new OptionsScannerPanel(this);
        }
        return this.optionsScannerPanel;
    }

    private OptionsVariantPanel getOptionsVariantPanel() {
        if (this.optionsVariantPanel == null) {
            this.optionsVariantPanel = new OptionsVariantPanel();
        }
        return this.optionsVariantPanel;
    }

    protected ScannerParam getScannerParam() {
        if (this.scannerParam == null) {
            this.scannerParam = new ScannerParam();
        }
        return this.scannerParam;
    }

    @Override
    public void execute(CommandLineArgument[] commandLineArgumentArray) {
    }

    private CommandLineArgument[] getCommandLineArguments() {
        this.arguments[0] = new CommandLineArgument("-scan", 0, null, "", "-scan : Run vulnerability scan depending on previously saved policy.");
        return this.arguments;
    }

    public void setExcludeList(List<String> list) {
        for (ActiveScan activeScan : this.ascanController.getActiveScans()) {
            activeScan.setExcludeList(list);
        }
    }

    public void addPolicyPanel(AbstractParamPanel abstractParamPanel) {
        this.policyPanels.add(abstractParamPanel);
    }

    @Override
    public List<Class<?>> getDependencies() {
        return DEPENDENCIES;
    }

    @Override
    public void sessionAboutToChange(Session session) {
        this.ascanController.reset();
        this.attackModeScanner.stop();
        if (View.isInitialised()) {
            this.getActiveScanPanel().reset();
        }
    }

    @Override
    public String getAuthor() {
        return "ZAP Dev Team";
    }

    @Override
    public String getDescription() {
        return Constant.messages.getString("ascan.desc");
    }

    @Override
    public URL getURL() {
        try {
            return new URL("http://www.owasp.org/index.php/ZAP");
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    @Override
    public void sessionScopeChanged(Session session) {
        if (View.isInitialised()) {
            this.getActiveScanPanel().sessionScopeChanged(session);
        }
        this.attackModeScanner.sessionScopeChanged(session);
    }

    @Override
    public void sessionModeChanged(Control.Mode mode) {
        if (Control.Mode.safe.equals((Object)mode)) {
            this.ascanController.stopAllScans();
        }
        if (View.isInitialised()) {
            this.getMenuItemCustomScan().setEnabled(!Control.Mode.safe.equals((Object)mode));
            this.getActiveScanPanel().sessionModeChanged(mode);
        }
        this.attackModeScanner.sessionModeChanged(mode);
    }

    @Override
    public void destroy() {
        this.ascanController.stopAllScans();
        if (View.isInitialised()) {
            this.getActiveScanPanel().reset();
        }
    }

    public void showCustomScanDialog(SiteNode siteNode) {
        if (this.customScanDialog == null) {
            String[] stringArray = CustomScanDialog.STD_TAB_LABELS;
            if (this.customScanPanels.size() > 0) {
                ArrayList<String> arrayList = new ArrayList<String>();
                for (String string : CustomScanDialog.STD_TAB_LABELS) {
                    arrayList.add(string);
                }
                for (CustomScanPanel customScanPanel : this.customScanPanels) {
                    arrayList.add(customScanPanel.getLabel());
                }
                stringArray = arrayList.toArray(new String[arrayList.size()]);
            }
            this.customScanDialog = new CustomScanDialog(this, stringArray, this.customScanPanels, View.getSingleton().getMainFrame(), new Dimension(700, 500));
        }
        if (this.customScanDialog.isVisible()) {
            this.customScanDialog.requestFocus();
            this.customScanDialog.toFront();
            return;
        }
        if (siteNode != null) {
            this.customScanDialog.init(new Target(siteNode));
        } else {
            this.customScanDialog.init(null);
        }
        this.customScanDialog.setVisible(true);
    }

    public void addCustomScanPanel(CustomScanPanel customScanPanel) {
        this.customScanPanels.add(customScanPanel);
        this.customScanDialog = null;
    }

    public void removeCustomScanPanel(CustomScanPanel customScanPanel) {
        this.customScanPanels.remove(customScanPanel);
        this.customScanDialog = null;
    }

    public void showPolicyManagerDialog() {
        if (this.policyManagerDialog == null) {
            this.policyManagerDialog = new PolicyManagerDialog(View.getSingleton().getMainFrame());
            this.policyManagerDialog.init(this);
        }
        this.policyManagerDialog.policyNamesChanged();
        this.policyManagerDialog.setVisible(true);
    }

    @Override
    public boolean handleFile(File file) {
        return false;
    }

    @Override
    public List<String> getHandledExtensions() {
        return null;
    }

    @Override
    public List<ActiveScan> getAllScans() {
        return this.ascanController.getAllScans();
    }

    @Override
    public List<ActiveScan> getActiveScans() {
        return this.ascanController.getActiveScans();
    }

    @Override
    public ActiveScan getScan(int n) {
        return this.ascanController.getScan(n);
    }

    @Override
    public void stopScan(int n) {
        this.ascanController.stopScan(n);
    }

    @Override
    public void pauseScan(int n) {
        this.ascanController.pauseScan(n);
        if (View.isInitialised()) {
            this.getActiveScanPanel().updateScannerUI();
        }
    }

    @Override
    public void resumeScan(int n) {
        this.ascanController.resumeScan(n);
        if (View.isInitialised()) {
            this.getActiveScanPanel().updateScannerUI();
        }
    }

    @Override
    public void stopAllScans() {
        this.ascanController.stopAllScans();
    }

    @Override
    public void pauseAllScans() {
        this.ascanController.pauseAllScans();
        if (View.isInitialised()) {
            this.getActiveScanPanel().updateScannerUI();
        }
    }

    @Override
    public void resumeAllScans() {
        this.ascanController.removeAllScans();
        if (View.isInitialised()) {
            this.getActiveScanPanel().updateScannerUI();
        }
    }

    @Override
    public ActiveScan removeScan(int n) {
        return this.ascanController.removeScan(n);
    }

    @Override
    public int removeAllScans() {
        return this.ascanController.removeAllScans();
    }

    @Override
    public int removeFinishedScans() {
        return this.ascanController.removeFinishedScans();
    }

    @Override
    public ActiveScan getLastScan() {
        return this.ascanController.getLastScan();
    }

    public int registerScan(ActiveScan activeScan) {
        int n = this.ascanController.registerScan(activeScan);
        if (View.isInitialised()) {
            activeScan.addScannerListener(this.getActiveScanPanel());
            this.getActiveScanPanel().scannerStarted(activeScan);
            this.getActiveScanPanel().switchView(activeScan);
            this.getActiveScanPanel().setTabFocus();
        }
        return n;
    }

    public PolicyManager getPolicyManager() {
        return this.policyManager;
    }

    public int getAttackModeStackSize() {
        return this.attackModeScanner.getStackSize();
    }

    @Override
    public boolean supportsLowMemory() {
        return true;
    }

    @Override
    public boolean supportsDb(String string) {
        return true;
    }

    static {
        ArrayList<Class<ExtensionAlert>> arrayList = new ArrayList<Class<ExtensionAlert>>(1);
        arrayList.add(ExtensionAlert.class);
        DEPENDENCIES = Collections.unmodifiableList(arrayList);
    }
}

