/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.help;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import javax.help.CSH;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.help.SwingHelpUtilities;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.extension.ExtensionAdaptor;
import org.parosproxy.paros.extension.ExtensionHook;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.control.AddOnLoader;
import org.zaproxy.zap.control.ExtensionFactory;
import org.zaproxy.zap.extension.help.BasicOnlineContentViewerUI;
import org.zaproxy.zap.utils.DisplayUtils;
import org.zaproxy.zap.view.ZapMenuItem;

public class ExtensionHelp
extends ExtensionAdaptor {
    private static final String HELP_SET_FILE_NAME = "helpset";
    public static final ImageIcon HELP_ICON = DisplayUtils.getScaledIcon(new ImageIcon(ExtensionHelp.class.getResource("/resource/icon/16/201.png")));
    private ZapMenuItem menuHelpZap = null;
    private JButton helpButton = null;
    private static HelpSet hs = null;
    private static HelpBroker hb = null;
    private static final Logger logger = Logger.getLogger(ExtensionHelp.class);

    public ExtensionHelp() {
        this.initialize();
    }

    public ExtensionHelp(String string) {
        super(string);
    }

    private void initialize() {
        this.setName("ExtensionHelp");
        this.setOrder(10000);
    }

    @Override
    public void init() {
        super.init();
        SwingHelpUtilities.setContentViewerUI((String)BasicOnlineContentViewerUI.class.getCanonicalName());
    }

    @Override
    public void hook(ExtensionHook extensionHook) {
        super.hook(extensionHook);
        if (this.getView() != null) {
            extensionHook.getHookMenu().addHelpMenuItem(this.getMenuHelpZapUserGuide());
            View.getSingleton().addMainToolbarSeparator();
            View.getSingleton().addMainToolbarButton(this.getHelpButton());
        }
    }

    public static HelpBroker getHelpBroker() {
        if (hb == null) {
            ExtensionHelp.createHelpBroker();
        }
        return hb;
    }

    private static synchronized void createHelpBroker() {
        if (hb == null) {
            try {
                AddOnLoader addOnLoader = ExtensionFactory.getAddOnLoader();
                URL uRL = HelpSet.findHelpSet((ClassLoader)addOnLoader, (String)HELP_SET_FILE_NAME, (Locale)Constant.getLocale());
                if (uRL != null) {
                    hs = new HelpSet((ClassLoader)addOnLoader, uRL);
                    hb = hs.createHelpBroker();
                }
            }
            catch (Exception exception) {
                logger.error((Object)exception.getMessage(), (Throwable)exception);
            }
        }
    }

    public static void enableHelpKey(Component component, String string) {
        if (ExtensionHelp.getHelpBroker() != null) {
            hb.enableHelp(component, string, hs);
        }
    }

    public static void showHelp() {
        ExtensionHelp.showHelp("zap.intro");
    }

    public static void showHelp(String string) {
        if (ExtensionHelp.getHelpBroker() == null) {
            return;
        }
        try {
            ExtensionHelp.getHelpBroker().showID(string, "javax.help.SecondaryWindow", null);
        }
        catch (Exception exception) {
            logger.error((Object)("error loading help with index: " + string), (Throwable)exception);
        }
    }

    private ZapMenuItem getMenuHelpZapUserGuide() {
        if (this.menuHelpZap == null) {
            this.menuHelpZap = new ZapMenuItem("help.menu.guide", KeyStroke.getKeyStroke(112, 0, false));
            if (ExtensionHelp.getHelpBroker() != null) {
                this.menuHelpZap.addActionListener((ActionListener)new CSH.DisplayHelpFromFocus(hb));
                hb.enableHelpKey((Component)this.getView().getMainFrame().getRootPane(), "zap.intro", hs, "javax.help.SecondaryWindow", null);
                hb.enableHelp((Component)this.getView().getSiteTreePanel(), "ui.tabs.sites", hs);
                hb.enableHelp((Component)this.getView().getRequestPanel(), "ui.tabs.request", hs);
                hb.enableHelp((Component)this.getView().getResponsePanel(), "ui.tabs.response", hs);
            } else {
                logger.debug((Object)"Failed to get helpset url");
                this.menuHelpZap.setEnabled(false);
                this.menuHelpZap.setToolTipText(Constant.messages.getString("help.error.nohelp"));
            }
        }
        return this.menuHelpZap;
    }

    private JButton getHelpButton() {
        if (this.helpButton == null) {
            this.helpButton = new JButton();
            this.helpButton.setIcon(new ImageIcon(ExtensionHelp.class.getResource("/resource/icon/16/201.png")));
            this.helpButton.setToolTipText(Constant.messages.getString("help.button.tooltip"));
            if (ExtensionHelp.getHelpBroker() == null) {
                this.helpButton.setEnabled(false);
                this.helpButton.setToolTipText(Constant.messages.getString("help.error.nohelp"));
            }
            this.helpButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ExtensionHelp.showHelp();
                }
            });
        }
        return this.helpButton;
    }

    @Override
    public String getAuthor() {
        return "ZAP Dev Team";
    }

    @Override
    public String getDescription() {
        return Constant.messages.getString("help.desc");
    }

    @Override
    public URL getURL() {
        try {
            return new URL("http://www.owasp.org/index.php/ZAP");
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    @Override
    public boolean supportsDb(String string) {
        return true;
    }
}

