/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.httppanel.view.syntaxhighlight;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JViewport;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Highlighter;
import org.apache.commons.configuration.FileConfiguration;
import org.apache.log4j.Logger;
import org.fife.ui.rsyntaxtextarea.AbstractTokenMakerFactory;
import org.fife.ui.rsyntaxtextarea.RSyntaxDocument;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.TokenMakerFactory;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;
import org.fife.ui.rtextarea.RecordableTextAction;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.extension.ExtensionPopupMenuItem;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.extension.httppanel.Message;
import org.zaproxy.zap.extension.httppanel.view.syntaxhighlight.menus.SyntaxMenu;
import org.zaproxy.zap.extension.httppanel.view.syntaxhighlight.menus.ViewMenu;
import org.zaproxy.zap.extension.search.SearchMatch;
import org.zaproxy.zap.utils.FontUtils;
import org.zaproxy.zap.view.HighlightSearchEntry;
import org.zaproxy.zap.view.HighlighterManager;

public abstract class HttpPanelSyntaxHighlightTextArea
extends RSyntaxTextArea
implements Observer {
    private static final long serialVersionUID = -9082089105656842054L;
    private static Logger log = Logger.getLogger(HttpPanelSyntaxHighlightTextArea.class);
    public static final String PLAIN_SYNTAX_LABEL = Constant.messages.getString("http.panel.view.syntaxtext.syntax.plain");
    private static final String ANTI_ALIASING = "aa";
    private static final String SHOW_LINE_NUMBERS = "linenumbers";
    private static final String WORD_WRAP = "wordwrap";
    private static final String HIGHLIGHT_CURRENT_LINE = "highlightline";
    private static final String FADE_CURRENT_HIGHLIGHT_LINE = "fadehighlightline";
    private static final String SHOW_WHITESPACE_CHARACTERS = "whitespaces";
    private static final String SHOW_NEWLINE_CHARACTERS = "newlines";
    private static final String MARK_OCCURRENCES = "markocurrences";
    private static final String ROUNDED_SELECTION_EDGES = "roundedselection";
    private static final String BRACKET_MATCHING = "bracketmatch";
    private static final String ANIMATED_BRACKET_MATCHING = "animatedbracketmatch";
    private Message message;
    private Vector<SyntaxStyle> syntaxStyles;
    private static SyntaxMenu syntaxMenu = null;
    private static ViewMenu viewMenu = null;
    private static TextAreaMenuItem cutAction = null;
    private static TextAreaMenuItem copyAction = null;
    private static TextAreaMenuItem pasteAction = null;
    private static TextAreaMenuItem deleteAction = null;
    private static TextAreaMenuItem undoAction = null;
    private static TextAreaMenuItem redoAction = null;
    private static TextAreaMenuItem selectAllAction = null;

    public HttpPanelSyntaxHighlightTextArea() {
        ((RSyntaxDocument)this.getDocument()).setTokenMakerFactory((TokenMakerFactory)this.getTokenMakerFactory());
        this.setSyntaxEditingStyle("text/plain");
        this.syntaxStyles = new Vector();
        this.addSyntaxStyle(PLAIN_SYNTAX_LABEL, "text/plain");
        if (syntaxMenu == null) {
            HttpPanelSyntaxHighlightTextArea.initActions();
        }
        this.setPopupMenu(null);
        this.message = null;
        this.setHyperlinksEnabled(false);
        this.setAntiAliasingEnabled(true);
        this.setLineWrap(true);
        this.setHighlightCurrentLine(false);
        this.setFadeCurrentLineHighlight(false);
        this.setWhitespaceVisible(false);
        this.setEOLMarkersVisible(false);
        this.setMarkOccurrences(false);
        this.setBracketMatchingEnabled(false);
        this.setAnimateBracketMatching(false);
        this.setAutoIndentEnabled(false);
        this.setCloseCurlyBraces(false);
        this.setCloseMarkupTags(false);
        this.setClearWhitespaceLinesEnabled(false);
        this.setFont(FontUtils.getFont(this.getFont().getFontName()));
        this.initHighlighter();
    }

    protected JPopupMenu createPopupMenu() {
        return null;
    }

    private void initHighlighter() {
        HighlighterManager highlighterManager = HighlighterManager.getInstance();
        highlighterManager.addObserver(this);
        if (this.message != null) {
            this.highlightAll();
        }
    }

    private void highlightAll() {
        HighlighterManager highlighterManager = HighlighterManager.getInstance();
        LinkedList<HighlightSearchEntry> linkedList = highlighterManager.getHighlights();
        for (HighlightSearchEntry highlightSearchEntry : linkedList) {
            this.highlightEntryParser(highlightSearchEntry);
        }
    }

    private void highlightEntryParser(HighlightSearchEntry highlightSearchEntry) {
        int n = 0;
        String string = this.getText();
        Highlighter highlighter = this.getHighlighter();
        DefaultHighlighter.DefaultHighlightPainter defaultHighlightPainter = new DefaultHighlighter.DefaultHighlightPainter(highlightSearchEntry.getColor());
        while ((n = string.indexOf(highlightSearchEntry.getToken(), n)) > -1) {
            try {
                highlighter.addHighlight(n, n + highlightSearchEntry.getToken().length(), defaultHighlightPainter);
                n += highlightSearchEntry.getToken().length();
            }
            catch (BadLocationException badLocationException) {
                log.warn((Object)"Could not highlight entry", (Throwable)badLocationException);
            }
        }
    }

    public void setText(String string) {
        super.setText(string);
        this.highlightAll();
    }

    public abstract void search(Pattern var1, List<SearchMatch> var2);

    public abstract void highlight(SearchMatch var1);

    protected void highlight(int n, int n2) {
        Highlighter highlighter = this.getHighlighter();
        DefaultHighlighter.DefaultHighlightPainter defaultHighlightPainter = new DefaultHighlighter.DefaultHighlightPainter(Color.LIGHT_GRAY);
        try {
            this.removeAllHighlights();
            highlighter.addHighlight(n, n2, defaultHighlightPainter);
            this.setCaretPosition(n);
        }
        catch (BadLocationException badLocationException) {
            log.error((Object)badLocationException.getMessage(), (Throwable)badLocationException);
        }
    }

    public Object highlight(int n, int n2, Highlighter.HighlightPainter highlightPainter) {
        try {
            Object object = this.getHighlighter().addHighlight(n, n2, highlightPainter);
            this.setCaretPosition(n);
            return object;
        }
        catch (BadLocationException badLocationException) {
            log.error((Object)badLocationException.getMessage(), (Throwable)badLocationException);
            return null;
        }
    }

    public void removeHighlight(Object object) {
        this.getHighlighter().removeHighlight(object);
    }

    private void removeAllHighlights() {
        Highlighter highlighter = this.getHighlighter();
        highlighter.removeAllHighlights();
    }

    @Override
    public void update(Observable observable, Object object) {
        if (object == null) {
            this.removeAllHighlights();
            this.highlightAll();
        } else {
            HighlightSearchEntry highlightSearchEntry = (HighlightSearchEntry)object;
            this.highlightEntryParser(highlightSearchEntry);
        }
        this.invalidate();
    }

    public void setMessage(Message message) {
        this.message = message;
    }

    public Message getMessage() {
        return this.message;
    }

    public void loadConfiguration(String string, FileConfiguration fileConfiguration) {
        this.setAntiAliasingEnabled(fileConfiguration.getBoolean(string + ANTI_ALIASING, this.getAntiAliasingEnabled()));
        Container container = this.getParent();
        if (container instanceof JViewport && (container = container.getParent()) instanceof RTextScrollPane) {
            RTextScrollPane rTextScrollPane = (RTextScrollPane)container;
            rTextScrollPane.setLineNumbersEnabled(fileConfiguration.getBoolean(string + SHOW_LINE_NUMBERS, rTextScrollPane.getLineNumbersEnabled()));
        }
        this.setLineWrap(fileConfiguration.getBoolean(string + WORD_WRAP, this.getLineWrap()));
        this.setHighlightCurrentLine(fileConfiguration.getBoolean(string + HIGHLIGHT_CURRENT_LINE, this.getHighlightCurrentLine()));
        this.setFadeCurrentLineHighlight(fileConfiguration.getBoolean(string + FADE_CURRENT_HIGHLIGHT_LINE, this.getFadeCurrentLineHighlight()));
        this.setWhitespaceVisible(fileConfiguration.getBoolean(string + SHOW_WHITESPACE_CHARACTERS, this.isWhitespaceVisible()));
        this.setEOLMarkersVisible(fileConfiguration.getBoolean(string + SHOW_NEWLINE_CHARACTERS, this.getEOLMarkersVisible()));
        this.setMarkOccurrences(fileConfiguration.getBoolean(string + MARK_OCCURRENCES, this.getMarkOccurrences()));
        this.setRoundedSelectionEdges(fileConfiguration.getBoolean(string + ROUNDED_SELECTION_EDGES, this.getRoundedSelectionEdges()));
        this.setBracketMatchingEnabled(fileConfiguration.getBoolean(string + BRACKET_MATCHING, this.isBracketMatchingEnabled()));
        this.setAnimateBracketMatching(fileConfiguration.getBoolean(string + ANIMATED_BRACKET_MATCHING, this.getAnimateBracketMatching()));
    }

    public void saveConfiguration(String string, FileConfiguration fileConfiguration) {
        fileConfiguration.setProperty(string + ANTI_ALIASING, (Object)this.getAntiAliasingEnabled());
        Container container = this.getParent();
        if (container instanceof JViewport && (container = container.getParent()) instanceof RTextScrollPane) {
            RTextScrollPane rTextScrollPane = (RTextScrollPane)container;
            fileConfiguration.setProperty(string + SHOW_LINE_NUMBERS, (Object)rTextScrollPane.getLineNumbersEnabled());
        }
        fileConfiguration.setProperty(string + WORD_WRAP, (Object)this.getLineWrap());
        fileConfiguration.setProperty(string + HIGHLIGHT_CURRENT_LINE, (Object)this.getHighlightCurrentLine());
        fileConfiguration.setProperty(string + FADE_CURRENT_HIGHLIGHT_LINE, (Object)this.getFadeCurrentLineHighlight());
        fileConfiguration.setProperty(string + SHOW_WHITESPACE_CHARACTERS, (Object)this.isWhitespaceVisible());
        fileConfiguration.setProperty(string + SHOW_NEWLINE_CHARACTERS, (Object)this.getEOLMarkersVisible());
        fileConfiguration.setProperty(string + MARK_OCCURRENCES, (Object)this.getMarkOccurrences());
        fileConfiguration.setProperty(string + ROUNDED_SELECTION_EDGES, (Object)this.getRoundedSelectionEdges());
        fileConfiguration.setProperty(string + BRACKET_MATCHING, (Object)this.isBracketMatchingEnabled());
        fileConfiguration.setProperty(string + ANIMATED_BRACKET_MATCHING, (Object)this.getAnimateBracketMatching());
    }

    public Vector<SyntaxStyle> getSyntaxStyles() {
        return this.syntaxStyles;
    }

    protected void addSyntaxStyle(String string, String string2) {
        this.syntaxStyles.add(new SyntaxStyle(string, string2));
    }

    protected abstract CustomTokenMakerFactory getTokenMakerFactory();

    private static synchronized void initActions() {
        if (syntaxMenu == null) {
            syntaxMenu = new SyntaxMenu();
            viewMenu = new ViewMenu();
            undoAction = new TextAreaMenuItem(6, true, false);
            redoAction = new TextAreaMenuItem(4, false, true);
            cutAction = new TextAreaMenuItem(1, false, false);
            copyAction = new TextAreaMenuItem(0, false, false);
            pasteAction = new TextAreaMenuItem(3, false, false);
            deleteAction = new TextAreaMenuItem(2, false, true);
            selectAllAction = new TextAreaMenuItem(5, false, false);
            Vector<JMenuItem> vector = View.getSingleton().getPopupList();
            vector.add(syntaxMenu);
            vector.add(viewMenu);
            vector.add(undoAction);
            vector.add(redoAction);
            vector.add(cutAction);
            vector.add(copyAction);
            vector.add(pasteAction);
            vector.add(deleteAction);
            vector.add(selectAllAction);
        }
    }

    private static class TextAreaMenuItem
    extends ExtensionPopupMenuItem {
        private static final long serialVersionUID = -8369459846515841057L;
        private int actionId;
        private boolean precedeWithSeparator;
        private boolean succeedWithSeparator;

        public TextAreaMenuItem(int n, boolean bl, boolean bl2) throws IllegalArgumentException {
            this.actionId = n;
            this.precedeWithSeparator = bl;
            this.succeedWithSeparator = bl2;
            RecordableTextAction recordableTextAction = RTextArea.getAction((int)n);
            if (recordableTextAction == null) {
                throw new IllegalArgumentException("Action not found with id: " + n);
            }
            this.setAction((Action)recordableTextAction);
        }

        @Override
        public boolean isEnableForComponent(Component component) {
            if (component instanceof HttpPanelSyntaxHighlightTextArea) {
                HttpPanelSyntaxHighlightTextArea httpPanelSyntaxHighlightTextArea = (HttpPanelSyntaxHighlightTextArea)((Object)component);
                switch (this.actionId) {
                    case 1: {
                        if (httpPanelSyntaxHighlightTextArea.isEditable()) break;
                        this.setEnabled(false);
                        break;
                    }
                    case 2: 
                    case 3: {
                        this.setEnabled(httpPanelSyntaxHighlightTextArea.isEditable());
                        break;
                    }
                    case 5: {
                        this.setEnabled(httpPanelSyntaxHighlightTextArea.getDocument().getLength() != 0);
                    }
                }
                return true;
            }
            return false;
        }

        @Override
        public boolean precedeWithSeparator() {
            return this.precedeWithSeparator;
        }

        @Override
        public boolean succeedWithSeparator() {
            return this.succeedWithSeparator;
        }

        @Override
        public boolean isSafe() {
            return true;
        }
    }

    protected static class CustomTokenMakerFactory
    extends AbstractTokenMakerFactory {
        protected CustomTokenMakerFactory() {
        }

        protected void initTokenMakerMap() {
            String string = "org.fife.ui.rsyntaxtextarea.modes.";
            this.putMapping("text/plain", string + "PlainTextTokenMaker");
        }
    }

    public static class SyntaxStyle {
        private String label;
        private String styleKey;

        public SyntaxStyle(String string, String string2) {
            this.label = string;
            this.styleKey = string2;
        }

        public String getLabel() {
            return this.label;
        }

        public String getStyleKey() {
            return this.styleKey;
        }
    }
}

