/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.params;

import java.awt.EventQueue;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.db.RecordParam;
import org.parosproxy.paros.extension.ExtensionAdaptor;
import org.parosproxy.paros.extension.ExtensionHook;
import org.parosproxy.paros.extension.ExtensionLoader;
import org.parosproxy.paros.extension.SessionChangedListener;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.model.SiteNode;
import org.parosproxy.paros.network.HtmlParameter;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.extension.anticsrf.ExtensionAntiCSRF;
import org.zaproxy.zap.extension.api.API;
import org.zaproxy.zap.extension.help.ExtensionHelp;
import org.zaproxy.zap.extension.httpsessions.ExtensionHttpSessions;
import org.zaproxy.zap.extension.params.HtmlParameterStats;
import org.zaproxy.zap.extension.params.ParamScanner;
import org.zaproxy.zap.extension.params.ParamsAPI;
import org.zaproxy.zap.extension.params.ParamsPanel;
import org.zaproxy.zap.extension.params.PopupMenuAddAntiCSRF;
import org.zaproxy.zap.extension.params.PopupMenuAddSession;
import org.zaproxy.zap.extension.params.PopupMenuParamSearch;
import org.zaproxy.zap.extension.params.PopupMenuRemoveAntiCSRF;
import org.zaproxy.zap.extension.params.PopupMenuRemoveSession;
import org.zaproxy.zap.extension.params.SiteParameters;
import org.zaproxy.zap.extension.pscan.ExtensionPassiveScan;
import org.zaproxy.zap.extension.search.ExtensionSearch;
import org.zaproxy.zap.view.SiteMapListener;
import org.zaproxy.zap.view.SiteMapTreeCellRenderer;

public class ExtensionParams
extends ExtensionAdaptor
implements SessionChangedListener,
SiteMapListener {
    public static final String NAME = "ExtensionParams";
    private ParamsPanel paramsPanel = null;
    private PopupMenuParamSearch popupMenuSearch = null;
    private PopupMenuAddAntiCSRF popupMenuAddAntiCsrf = null;
    private PopupMenuRemoveAntiCSRF popupMenuRemoveAntiCsrf = null;
    private PopupMenuAddSession popupMenuAddSession = null;
    private PopupMenuRemoveSession popupMenuRemoveSession = null;
    private Map<String, SiteParameters> siteParamsMap = new HashMap<String, SiteParameters>();
    private Logger logger = Logger.getLogger(ExtensionParams.class);
    private ExtensionHttpSessions extensionHttpSessions;
    private ParamScanner paramScanner;

    public ExtensionParams() {
        this.initialize();
    }

    public ExtensionParams(String string) {
        super(string);
    }

    private void initialize() {
        this.setName(NAME);
        this.setOrder(58);
        API.getInstance().registerApiImplementor(new ParamsAPI(this));
    }

    @Override
    public void hook(ExtensionHook extensionHook) {
        Object object;
        super.hook(extensionHook);
        extensionHook.addSessionListener(this);
        extensionHook.addSiteMapListener(this);
        if (this.getView() != null) {
            object = extensionHook.getHookView();
            extensionHook.getHookView().addStatusPanel(this.getParamsPanel());
            ExtensionLoader extensionLoader = Control.getSingleton().getExtensionLoader();
            if (extensionLoader.isExtensionEnabled("ExtensionSearch2")) {
                extensionHook.getHookMenu().addPopupMenuItem(this.getPopupMenuParamSearch());
            }
            if (extensionLoader.isExtensionEnabled("ExtensionAntiCSRF")) {
                extensionHook.getHookMenu().addPopupMenuItem(this.getPopupMenuAddAntiCSRF());
                extensionHook.getHookMenu().addPopupMenuItem(this.getPopupMenuRemoveAntiCSRF());
            }
            if (extensionLoader.isExtensionEnabled("ExtensionHttpSessions")) {
                extensionHook.getHookMenu().addPopupMenuItem(this.getPopupMenuAddSession());
                extensionHook.getHookMenu().addPopupMenuItem(this.getPopupMenuRemoveSession());
            }
            ExtensionHelp.enableHelpKey(this.getParamsPanel(), "ui.tabs.params");
        }
        if ((object = (ExtensionPassiveScan)Control.getSingleton().getExtensionLoader().getExtension("ExtensionPassiveScan")) != null) {
            this.paramScanner = new ParamScanner(this);
            ((ExtensionPassiveScan)object).addPassiveScanner(new ParamScanner(this));
        }
    }

    @Override
    public void unload() {
        ExtensionPassiveScan extensionPassiveScan = (ExtensionPassiveScan)Control.getSingleton().getExtensionLoader().getExtension("ExtensionPassiveScan");
        if (extensionPassiveScan != null) {
            extensionPassiveScan.removePassiveScanner(this.paramScanner);
        }
        super.unload();
    }

    private PopupMenuParamSearch getPopupMenuParamSearch() {
        if (this.popupMenuSearch == null) {
            this.popupMenuSearch = new PopupMenuParamSearch();
            this.popupMenuSearch.setExtension(this);
        }
        return this.popupMenuSearch;
    }

    private PopupMenuAddAntiCSRF getPopupMenuAddAntiCSRF() {
        if (this.popupMenuAddAntiCsrf == null) {
            this.popupMenuAddAntiCsrf = new PopupMenuAddAntiCSRF();
            this.popupMenuAddAntiCsrf.setExtension(this);
        }
        return this.popupMenuAddAntiCsrf;
    }

    private PopupMenuRemoveAntiCSRF getPopupMenuRemoveAntiCSRF() {
        if (this.popupMenuRemoveAntiCsrf == null) {
            this.popupMenuRemoveAntiCsrf = new PopupMenuRemoveAntiCSRF();
            this.popupMenuRemoveAntiCsrf.setExtension(this);
        }
        return this.popupMenuRemoveAntiCsrf;
    }

    private PopupMenuAddSession getPopupMenuAddSession() {
        if (this.popupMenuAddSession == null) {
            this.popupMenuAddSession = new PopupMenuAddSession();
            this.popupMenuAddSession.setExtension(this);
        }
        return this.popupMenuAddSession;
    }

    private PopupMenuRemoveSession getPopupMenuRemoveSession() {
        if (this.popupMenuRemoveSession == null) {
            this.popupMenuRemoveSession = new PopupMenuRemoveSession();
            this.popupMenuRemoveSession.setExtension(this);
        }
        return this.popupMenuRemoveSession;
    }

    protected ParamsPanel getParamsPanel() {
        if (this.paramsPanel == null) {
            this.paramsPanel = new ParamsPanel(this);
        }
        return this.paramsPanel;
    }

    @Override
    public void sessionChanged(final Session session) {
        if (EventQueue.isDispatchThread()) {
            this.sessionChangedEventHandler(session);
        } else {
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        ExtensionParams.this.sessionChangedEventHandler(session);
                    }
                });
            }
            catch (Exception exception) {
                this.logger.error((Object)exception.getMessage(), (Throwable)exception);
            }
        }
    }

    protected ExtensionHttpSessions getExtensionHttpSessions() {
        if (this.extensionHttpSessions == null) {
            this.extensionHttpSessions = (ExtensionHttpSessions)Control.getSingleton().getExtensionLoader().getExtension("ExtensionHttpSessions");
        }
        return this.extensionHttpSessions;
    }

    private void sessionChangedEventHandler(Session session) {
        Object object;
        this.siteParamsMap = new HashMap<String, SiteParameters>();
        if (this.getView() != null) {
            this.getParamsPanel().reset();
        }
        if (session == null) {
            return;
        }
        SiteNode siteNode = (SiteNode)session.getSiteTree().getRoot();
        Enumeration<TreeNode> enumeration = siteNode.children();
        while (enumeration.hasMoreElements()) {
            object = ((SiteNode)enumeration.nextElement()).getNodeName();
            if (((String)object).indexOf("//") >= 0) {
                object = ((String)object).substring(((String)object).indexOf("//") + 2);
            }
            if (this.getView() == null) continue;
            this.getParamsPanel().addSite((String)object);
        }
        try {
            object = Model.getSingleton().getDb().getTableParam().getAll();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                RecordParam recordParam = (RecordParam)iterator.next();
                SiteParameters siteParameters = this.getSiteParameters(recordParam.getSite());
                siteParameters.addParam(recordParam.getSite(), recordParam);
            }
        }
        catch (DatabaseException databaseException) {
            this.logger.error((Object)databaseException.getMessage(), (Throwable)databaseException);
        }
    }

    public boolean onHttpRequestSend(HttpMessage httpMessage) {
        Iterator<HtmlParameter> iterator;
        TreeSet<HtmlParameter> treeSet;
        SiteParameters siteParameters;
        String string = httpMessage.getRequestHeader().getHostName() + ":" + httpMessage.getRequestHeader().getHostPort();
        if (this.getView() != null) {
            this.getParamsPanel().addSite(string);
        }
        if ((siteParameters = this.siteParamsMap.get(string)) == null) {
            siteParameters = new SiteParameters(this, string);
            this.siteParamsMap.put(string, siteParameters);
        }
        try {
            treeSet = httpMessage.getCookieParams();
            iterator = treeSet.iterator();
            while (iterator.hasNext()) {
                this.persist(siteParameters.addParam(string, iterator.next(), httpMessage));
            }
        }
        catch (Exception exception) {
            this.logger.error((Object)exception.getMessage(), (Throwable)exception);
        }
        treeSet = httpMessage.getUrlParams();
        iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            this.persist(siteParameters.addParam(string, iterator.next(), httpMessage));
        }
        ExtensionAntiCSRF extensionAntiCSRF = (ExtensionAntiCSRF)Control.getSingleton().getExtensionLoader().getExtension("ExtensionAntiCSRF");
        treeSet = httpMessage.getFormParams();
        for (HtmlParameter htmlParameter : treeSet) {
            if (extensionAntiCSRF != null && extensionAntiCSRF.isAntiCsrfToken(htmlParameter.getName())) {
                htmlParameter.addFlag(HtmlParameter.Flags.anticsrf.name());
            }
            this.persist(siteParameters.addParam(string, htmlParameter, httpMessage));
        }
        return true;
    }

    private String setToString(Set<String> set) {
        StringBuilder stringBuilder = new StringBuilder();
        if (set == null) {
            return "";
        }
        for (String string : set) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(string.replace(",", "%2C"));
        }
        return stringBuilder.toString();
    }

    private void persist(HtmlParameterStats htmlParameterStats) {
        try {
            if (htmlParameterStats.getId() < 0L) {
                RecordParam recordParam = Model.getSingleton().getDb().getTableParam().insert(htmlParameterStats.getSite(), htmlParameterStats.getType().name(), htmlParameterStats.getName(), htmlParameterStats.getTimesUsed(), this.setToString(htmlParameterStats.getFlags()), this.setToString(htmlParameterStats.getValues()));
                htmlParameterStats.setId(recordParam.getParamId());
            } else {
                Model.getSingleton().getDb().getTableParam().update(htmlParameterStats.getId(), htmlParameterStats.getTimesUsed(), this.setToString(htmlParameterStats.getFlags()), this.setToString(htmlParameterStats.getValues()));
            }
        }
        catch (DatabaseException databaseException) {
            this.logger.error((Object)databaseException.getMessage(), (Throwable)databaseException);
        }
    }

    public boolean onHttpResponseReceive(HttpMessage httpMessage) {
        String string = httpMessage.getRequestHeader().getHostName() + ":" + httpMessage.getRequestHeader().getHostPort();
        if (this.getView() != null) {
            this.getParamsPanel().addSite(string);
        }
        SiteParameters siteParameters = this.getSiteParameters(string);
        TreeSet<HtmlParameter> treeSet = httpMessage.getCookieParams();
        Iterator<HtmlParameter> iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            this.persist(siteParameters.addParam(string, iterator.next(), httpMessage));
        }
        return true;
    }

    @Override
    public void nodeSelected(SiteNode siteNode) {
        this.getParamsPanel().nodeSelected(siteNode);
    }

    @Override
    public void onReturnNodeRendererComponent(SiteMapTreeCellRenderer siteMapTreeCellRenderer, boolean bl, SiteNode siteNode) {
    }

    protected void searchForSelectedParam() {
        ExtensionSearch extensionSearch;
        HtmlParameterStats htmlParameterStats = this.getParamsPanel().getSelectedParam();
        if (htmlParameterStats != null && (extensionSearch = (ExtensionSearch)Control.getSingleton().getExtensionLoader().getExtension("ExtensionSearch2")) != null) {
            if (HtmlParameter.Type.url.equals((Object)htmlParameterStats.getType())) {
                extensionSearch.search("[?&]" + htmlParameterStats.getName() + "=.*", ExtensionSearch.Type.URL, true, false);
            } else if (HtmlParameter.Type.cookie.equals((Object)htmlParameterStats.getType())) {
                extensionSearch.search(htmlParameterStats.getName() + "=.*", ExtensionSearch.Type.Header, true, false);
            } else {
                extensionSearch.search(htmlParameterStats.getName() + "=.*", ExtensionSearch.Type.Request, true, false);
            }
        }
    }

    public void addAntiCsrfToken() {
        HtmlParameterStats htmlParameterStats = this.getParamsPanel().getSelectedParam();
        ExtensionAntiCSRF extensionAntiCSRF = (ExtensionAntiCSRF)Control.getSingleton().getExtensionLoader().getExtension("ExtensionAntiCSRF");
        if (extensionAntiCSRF != null && htmlParameterStats != null) {
            extensionAntiCSRF.addAntiCsrfTokenName(htmlParameterStats.getName());
            htmlParameterStats.addFlag(HtmlParameter.Flags.anticsrf.name());
            this.getParamsPanel().getParamsTable().repaint();
        }
    }

    public void removeAntiCsrfToken() {
        HtmlParameterStats htmlParameterStats = this.getParamsPanel().getSelectedParam();
        ExtensionAntiCSRF extensionAntiCSRF = (ExtensionAntiCSRF)Control.getSingleton().getExtensionLoader().getExtension("ExtensionAntiCSRF");
        if (extensionAntiCSRF != null && htmlParameterStats != null) {
            extensionAntiCSRF.removeAntiCsrfTokenName(htmlParameterStats.getName());
            htmlParameterStats.removeFlag(HtmlParameter.Flags.anticsrf.name());
            this.getParamsPanel().getParamsTable().repaint();
        }
    }

    public SiteParameters getSiteParameters(String string) {
        SiteParameters siteParameters = this.siteParamsMap.get(string);
        if (siteParameters == null) {
            siteParameters = new SiteParameters(this, string);
            this.siteParamsMap.put(string, siteParameters);
        }
        return siteParameters;
    }

    public Collection<SiteParameters> getAllSiteParameters() {
        Collection<SiteParameters> collection = this.siteParamsMap.values();
        return collection;
    }

    public void addSessionToken() {
        HtmlParameterStats htmlParameterStats = this.getParamsPanel().getSelectedParam();
        if (htmlParameterStats != null) {
            ExtensionHttpSessions extensionHttpSessions = this.getExtensionHttpSessions();
            if (extensionHttpSessions != null) {
                extensionHttpSessions.addHttpSessionToken(this.getParamsPanel().getCurrentSite(), htmlParameterStats.getName());
            }
            htmlParameterStats.addFlag(HtmlParameter.Flags.session.name());
            this.getParamsPanel().getParamsTable().repaint();
        }
    }

    public void removeSessionToken() {
        HtmlParameterStats htmlParameterStats = this.getParamsPanel().getSelectedParam();
        if (htmlParameterStats != null) {
            ExtensionHttpSessions extensionHttpSessions = this.getExtensionHttpSessions();
            if (extensionHttpSessions != null) {
                extensionHttpSessions.removeHttpSessionToken(this.getParamsPanel().getCurrentSite(), htmlParameterStats.getName());
            }
            htmlParameterStats.removeFlag(HtmlParameter.Flags.session.name());
            this.getParamsPanel().getParamsTable().repaint();
        }
    }

    public HtmlParameterStats getSelectedParam() {
        return this.getParamsPanel().getSelectedParam();
    }

    @Override
    public void sessionAboutToChange(Session session) {
    }

    @Override
    public void sessionScopeChanged(Session session) {
    }

    @Override
    public String getAuthor() {
        return "ZAP Dev Team";
    }

    @Override
    public String getDescription() {
        return Constant.messages.getString("params.desc");
    }

    @Override
    public URL getURL() {
        try {
            return new URL("http://www.owasp.org/index.php/ZAP");
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    @Override
    public void sessionModeChanged(Control.Mode mode) {
    }
}

