/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.utils;

import java.awt.Font;
import javax.swing.JLabel;
import javax.swing.UIManager;

public class FontUtils {
    private static float scale = -1.0f;
    private static Font defaultFont;
    private static Font systemDefaultFont;

    public static Font getSystemDefaultFont() {
        if (systemDefaultFont == null && (systemDefaultFont = (Font)UIManager.getLookAndFeelDefaults().get("defaultFont")) == null) {
            systemDefaultFont = new JLabel("").getFont();
        }
        return systemDefaultFont;
    }

    public static boolean canChangeSize() {
        return UIManager.getLookAndFeelDefaults().get("defaultFont") != null;
    }

    public static void setDefaultFont(Font font) {
        if (FontUtils.canChangeSize()) {
            FontUtils.getSystemDefaultFont();
            defaultFont = font;
            scale = -1.0f;
            UIManager.getLookAndFeelDefaults().put("defaultFont", font);
        }
    }

    public static void setDefaultFont(String string, int n) {
        if (n <= 5) {
            n = FontUtils.getDefaultFont().getSize();
        }
        FontUtils.setDefaultFont(new Font(string, 0, n));
    }

    private static Font getDefaultFont() {
        if (defaultFont == null && (defaultFont = Font.getFont("defaultFont")) == null) {
            defaultFont = new JLabel("").getFont();
        }
        return defaultFont;
    }

    public static Font getFont(String string) {
        return new Font(string, 0, FontUtils.getDefaultFont().getSize());
    }

    public static Font getFont(int n) {
        return FontUtils.getDefaultFont().deriveFont(n);
    }

    public static Font getFont(String string, int n) {
        Font font = (Font)UIManager.getLookAndFeelDefaults().get("defaultFont");
        return new Font(string, n, font.getSize());
    }

    public static Font getFont(int n, Size size) {
        return FontUtils.getFont(size).deriveFont(n);
    }

    public static Font getFont(Size size) {
        float f;
        Font font = FontUtils.getDefaultFont();
        switch (size) {
            case smallest: {
                f = (float)((double)font.getSize() * 0.5);
                break;
            }
            case much_smaller: {
                f = (float)((double)font.getSize() * 0.7);
                break;
            }
            case smaller: {
                f = (float)((double)font.getSize() * 0.8);
                break;
            }
            case standard: {
                f = font.getSize();
                break;
            }
            case larger: {
                f = (float)((double)font.getSize() * 1.5);
                break;
            }
            case much_larger: {
                f = font.getSize() * 2;
                break;
            }
            case huge: {
                f = font.getSize() * 4;
                break;
            }
            default: {
                f = font.getSize();
            }
        }
        return FontUtils.getDefaultFont().deriveFont(f);
    }

    public static float getScale() {
        if (scale == -1.0f) {
            scale = FontUtils.getDefaultFont().getSize2D() / FontUtils.getSystemDefaultFont().getSize2D();
        }
        return scale;
    }

    public static enum Size {
        smallest,
        much_smaller,
        smaller,
        standard,
        larger,
        much_larger,
        huge;

    }
}

