/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.view.messagelocation;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import org.parosproxy.paros.Constant;
import org.zaproxy.zap.view.messagelocation.TextMessageLocationHighlight;

public class TextMessageLocationHighlightEditor
extends AbstractCellEditor
implements TableCellEditor,
ActionListener {
    private static final long serialVersionUID = -4872445961159101261L;
    private static final String START_EDIT = "start.edit";
    private Color currentColor;
    private final JButton button = new JButton();
    private final JColorChooser colorChooser;
    private final JDialog dialog;

    public TextMessageLocationHighlightEditor() {
        this.button.setActionCommand(START_EDIT);
        this.button.addActionListener(this);
        this.button.setBorderPainted(false);
        this.colorChooser = new JColorChooser();
        this.dialog = JColorChooser.createDialog(this.button, Constant.messages.getString("messagelocation.text.highlight.colorpicker"), true, this.colorChooser, this, null);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (START_EDIT.equals(actionEvent.getActionCommand())) {
            this.button.setBackground(this.currentColor);
            this.colorChooser.setColor(this.currentColor);
            this.dialog.setVisible(true);
            this.fireEditingStopped();
        } else {
            this.currentColor = this.colorChooser.getColor();
        }
    }

    @Override
    public Object getCellEditorValue() {
        return new TextMessageLocationHighlight(this.currentColor);
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        this.currentColor = ((TextMessageLocationHighlight)object).getColor();
        this.button.setBackground(this.currentColor);
        return this.button;
    }
}

